/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityShulkerBullet
extends IProjectile {
    private static final double b = 0.15;
    private @Nullable EntityReference<Entity> c;
    public @Nullable EnumDirection d;
    public int e;
    public double f;
    public double g;
    public double h;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
        this.ar = true;
    }

    public EntityShulkerBullet(World level, EntityLiving shooter, Entity finalTarget, EnumDirection.EnumAxis axis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.bl, level);
        this.d(shooter);
        Vec3D center = shooter.dj().f();
        this.b(center.g, center.h, center.i, this.ec(), this.ee());
        this.c = EntityReference.a(finalTarget);
        this.d = EnumDirection.b;
        this.a(axis, finalTarget);
        this.projectileSource = shooter.getBukkitLivingEntity();
    }

    public @Nullable Entity getTarget() {
        return EntityReference.a(this.c, this.ao(), Entity.class);
    }

    public void setTarget(@Nullable Entity finalTarget) {
        this.c = finalTarget == null ? null : EntityReference.a(finalTarget);
        this.d = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a, finalTarget);
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        if (this.c != null) {
            output.a("Target", UUIDUtil.a, this.c.c());
        }
        output.b("Dir", EnumDirection.k, this.d);
        output.a("Steps", this.e);
        output.a("TXD", this.f);
        output.a("TYD", this.g);
        output.a("TZD", this.h);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.e = input.a("Steps", 0);
        this.f = input.a("TXD", 0.0);
        this.g = input.a("TYD", 0.0);
        this.h = input.a("TZD", 0.0);
        this.d = input.a("Dir", EnumDirection.k).orElse(null);
        this.c = EntityReference.a(input, "Target");
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    private @Nullable EnumDirection f() {
        return this.d;
    }

    private void a(@Nullable EnumDirection direction) {
        this.d = direction;
    }

    private void a(@Nullable EnumDirection.EnumAxis axis, @Nullable Entity target) {
        BlockPosition blockPos;
        double d2 = 0.5;
        if (target == null) {
            blockPos = this.dK().e();
        } else {
            d2 = (double)target.dG() * 0.5;
            blockPos = BlockPosition.a(target.dP(), target.dR() + d2, target.dV());
        }
        double d1 = (double)blockPos.u() + 0.5;
        double d22 = (double)blockPos.v() + d2;
        double d3 = (double)blockPos.w() + 0.5;
        EnumDirection direction = null;
        if (!blockPos.a(this.dI(), 2.0)) {
            BlockPosition blockPos1 = this.dK();
            ArrayList list = Lists.newArrayList();
            if (axis != EnumDirection.EnumAxis.a) {
                if (blockPos1.u() < blockPos.u() && this.ao().A(blockPos1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockPos1.u() > blockPos.u() && this.ao().A(blockPos1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (axis != EnumDirection.EnumAxis.b) {
                if (blockPos1.v() < blockPos.v() && this.ao().A(blockPos1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockPos1.v() > blockPos.v() && this.ao().A(blockPos1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (axis != EnumDirection.EnumAxis.c) {
                if (blockPos1.w() < blockPos.w() && this.ao().A(blockPos1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockPos1.w() > blockPos.w() && this.ao().A(blockPos1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            direction = EnumDirection.b(this.as);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.ao().A(blockPos1.a(direction)) && i2 > 0; --i2) {
                    direction = EnumDirection.b(this.as);
                }
            } else {
                direction = (EnumDirection)list.get(this.as.a(list.size()));
            }
            d1 = this.dP() + (double)direction.j();
            d22 = this.dR() + (double)direction.k();
            d3 = this.dV() + (double)direction.l();
        }
        this.a(direction);
        double d4 = d1 - this.dP();
        double d5 = d22 - this.dR();
        double d6 = d3 - this.dV();
        double squareRoot = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (squareRoot == 0.0) {
            this.f = 0.0;
            this.g = 0.0;
            this.h = 0.0;
        } else {
            this.f = d4 / squareRoot * 0.15;
            this.g = d5 / squareRoot * 0.15;
            this.h = d6 / squareRoot * 0.15;
        }
        this.aF = true;
        this.e = 10 + this.as.a(5) * 10;
    }

    @Override
    public void dW() {
        if (this.ao().av() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double bs() {
        return 0.04;
    }

    @Override
    public void g() {
        Vec3D deltaMovement;
        super.g();
        Entity entity = !this.ao().B_() ? EntityReference.a(this.c, this.ao()) : null;
        MovingObjectPosition hitResult = null;
        if (!this.ao().B_()) {
            if (entity == null) {
                this.c = null;
            }
            if (entity == null || !entity.cb() || entity instanceof EntityHuman && entity.au()) {
                this.bu();
            } else {
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                this.h = MathHelper.a(this.h * 1.025, -1.0, 1.0);
                deltaMovement = this.dN();
                this.k(deltaMovement.b((this.f - deltaMovement.g) * 0.2, (this.g - deltaMovement.h) * 0.2, (this.h - deltaMovement.i) * 0.2));
            }
            hitResult = ProjectileHelper.a((Entity)this, this::b);
        }
        deltaMovement = this.dN();
        this.b(this.dI().e(deltaMovement));
        this.aW();
        if (this.aG != null && this.aG.e()) {
            this.cn();
        }
        if (hitResult != null && this.cb() && hitResult.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            this.preHitTargetOrDeflectSelf(hitResult);
        }
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.ao().B_()) {
            this.ao().a(Particles.u, this.dP() - deltaMovement.g, this.dR() - deltaMovement.h + 0.15, this.dV() - deltaMovement.i, 0.0, 0.0, 0.0);
        } else if (entity != null) {
            if (this.e > 0) {
                --this.e;
                if (this.e == 0) {
                    this.a(this.d == null ? null : this.d.o(), entity);
                }
            }
            if (this.d != null) {
                BlockPosition blockPos = this.dK();
                EnumDirection.EnumAxis axis = this.d.o();
                if (this.ao().a(blockPos.a(this.d), this)) {
                    this.a(axis, entity);
                } else {
                    BlockPosition blockPos1 = entity.dK();
                    if (axis == EnumDirection.EnumAxis.a && blockPos.u() == blockPos1.u() || axis == EnumDirection.EnumAxis.c && blockPos.w() == blockPos1.w() || axis == EnumDirection.EnumAxis.b && blockPos.v() == blockPos1.v()) {
                        this.a(axis, entity);
                    }
                }
            }
        }
    }

    @Override
    public boolean ba() {
        return !this.eh();
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) && !target.ar;
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    public boolean a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float bO() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        super.a(result);
        Entity entity = result.a();
        Entity owner = this.p();
        EntityLiving livingEntity = owner instanceof EntityLiving ? (EntityLiving)owner : null;
        DamageSource damageSource = this.en().a((Entity)this, livingEntity);
        boolean flag = entity.b(damageSource, 4.0f);
        if (flag) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, entity, damageSource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity1 = (EntityLiving)entity;
                livingEntity1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)owner, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        super.a(result);
        ((WorldServer)this.ao()).a(Particles.x, this.dP(), this.dR(), this.dV(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.zV, 1.0f, 1.0f);
    }

    private void i() {
        this.destroy(null);
    }

    private void destroy(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.ao().a(GameEvent.o, this.dI(), GameEvent.a.a(this));
    }

    @Override
    protected void b(MovingObjectPosition result) {
        super.b(result);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bX() {
        return true;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return true;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damageSource, amount, false)) {
            return false;
        }
        this.a(SoundEffects.zW, 1.0f, 1.0f);
        level.a(Particles.g, this.dP(), this.dR(), this.dV(), 15, 0.2, 0.2, 0.2, 0.0);
        this.destroy(EntityRemoveEvent.Cause.DEATH);
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.k(packet.j());
    }
}

