/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityEnderPearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jspecify.annotations.Nullable;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    private static final boolean b = false;
    private static final boolean c = false;
    public @Nullable EntityReference<Entity> a;
    public boolean d = false;
    private boolean e;
    public boolean f = false;
    private @Nullable Entity g;
    protected boolean hitCancelled = false;

    protected IProjectile(EntityTypes<? extends IProjectile> type, World level) {
        super(type, level);
    }

    protected void a(@Nullable EntityReference<Entity> owner) {
        this.a = owner;
        this.refreshProjectileSource(false);
    }

    public void d(@Nullable Entity owner) {
        this.a(EntityReference.a(owner));
    }

    public void refreshProjectileSource(boolean fillCache) {
        CraftEntity craftEntity;
        Entity owner;
        if (fillCache) {
            this.p();
        }
        if ((owner = this.p()) != null && this.projectileSource == null && (craftEntity = owner.getBukkitEntity()) instanceof ProjectileSource) {
            ProjectileSource projSource;
            this.projectileSource = projSource = (ProjectileSource)craftEntity;
        }
    }

    @Override
    public @Nullable Entity p() {
        return EntityReference.a(this.a, this.ao());
    }

    public Entity m() {
        return (Entity)MoreObjects.firstNonNull((Object)this.p(), (Object)this);
    }

    @Override
    protected void a(ValueOutput output) {
        EntityReference.a(this.a, output, "Owner");
        if (this.d) {
            output.a("LeftOwner", true);
        }
        output.a("HasBeenShot", this.f);
    }

    protected boolean e(Entity entity) {
        return this.a != null && this.a.b(entity);
    }

    @Override
    protected void a(ValueInput input) {
        this.a(EntityReference.a(input, "Owner"));
        if (this instanceof EntityEnderPearl && this.ao().paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && this.ao().paperConfig().misc.legacyEnderPearlBehavior) {
            this.a = null;
        }
        this.d = input.a("LeftOwner", false);
        this.f = input.a("HasBeenShot", false);
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof IProjectile) {
            IProjectile projectile = (IProjectile)entity;
            this.a = projectile.a;
        }
    }

    @Override
    public void g() {
        if (!this.f) {
            this.a(GameEvent.K, this.p());
            this.f = true;
        }
        this.n();
        super.g();
        this.e = false;
    }

    protected void n() {
        if (!this.d && !this.e) {
            this.d = this.f();
            this.e = true;
        }
    }

    private boolean f() {
        Entity owner = this.p();
        if (owner != null) {
            AxisAlignedBB aabb = this.dj().b(this.dN()).g(1.0);
            return owner.du().dp().filter(IEntitySelector.h).noneMatch(entity -> aabb.c(entity.dj()));
        }
        return true;
    }

    public Vec3D c(double x2, double y2, double z2, float velocity, float inaccuracy) {
        return new Vec3D(x2, y2, z2).d().b(this.as.a(0.0, 0.0172275 * (double)inaccuracy), this.as.a(0.0, 0.0172275 * (double)inaccuracy), this.as.a(0.0, 0.0172275 * (double)inaccuracy)).c((double)velocity);
    }

    public void d(double x2, double y2, double z2, float velocity, float inaccuracy) {
        Vec3D movementToShoot = this.c(x2, y2, z2, velocity, inaccuracy);
        this.k(movementToShoot);
        this.aF = true;
        double d2 = movementToShoot.i();
        this.v((float)(MathHelper.d(movementToShoot.g, movementToShoot.i) * 180.0 / 3.1415927410125732));
        this.w((float)(MathHelper.d(movementToShoot.h, d2) * 180.0 / 3.1415927410125732));
        this.ab = this.ec();
        this.ac = this.ee();
    }

    public void a(Entity shooter, float x2, float y2, float z2, float velocity, float inaccuracy) {
        float f2 = -MathHelper.a((double)(y2 * ((float)Math.PI / 180))) * MathHelper.b((double)(x2 * ((float)Math.PI / 180)));
        float f1 = -MathHelper.a((double)((x2 + z2) * ((float)Math.PI / 180)));
        float f22 = MathHelper.b((double)(y2 * ((float)Math.PI / 180))) * MathHelper.b((double)(x2 * ((float)Math.PI / 180)));
        this.d(f2, f1, f22, velocity, inaccuracy);
        Vec3D knownMovement = shooter.ag();
        if (Double.isNaN(knownMovement.g) || Double.isNaN(knownMovement.h) || Double.isNaN(knownMovement.i)) {
            knownMovement = new Vec3D(0.0, 0.0, 0.0);
        }
        if (!shooter.ao().paperConfig().misc.disableRelativeProjectileVelocity) {
            this.k(this.dN().b(knownMovement.g, shooter.aV() ? 0.0 : knownMovement.h, knownMovement.i));
        }
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        double d2 = downwards ? -0.03 : 0.1;
        this.k(this.dN().b(0.0, d2, 0.0));
        IProjectile.a(this.ao(), pos);
    }

    @Override
    public void m(boolean downwards) {
        double d2 = downwards ? -0.03 : 0.06;
        this.k(this.dN().b(0.0, d2, 0.0));
        this.l();
    }

    public static <T extends IProjectile> T a(a<T> factory, WorldServer level, ItemStack spawnedFrom, EntityLiving owner, float z2, float velocity, float inaccuracy) {
        return IProjectile.spawnProjectileFromRotationDelayed(factory, level, spawnedFrom, owner, z2, velocity, inaccuracy).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileFromRotationDelayed(a<T> factory, WorldServer level, ItemStack spawnedFrom, EntityLiving owner, float z2, float velocity, float inaccuracy) {
        return IProjectile.spawnProjectileDelayed(factory.create(level, owner, spawnedFrom), level, spawnedFrom, projectile -> projectile.a(owner, owner.ee(), owner.ec(), z2, velocity, inaccuracy));
    }

    public static <T extends IProjectile> T a(a<T> factory, WorldServer level, ItemStack spawnedFrom, EntityLiving owner, double x2, double y2, double z2, float velocity, float inaccuracy) {
        return (T)IProjectile.a(factory.create(level, owner, spawnedFrom), level, spawnedFrom, projectile -> projectile.d(x2, y2, z2, velocity, inaccuracy));
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer level, ItemStack spawnedFrom, double x2, double y2, double z2, float velocity, float inaccuracy) {
        return IProjectile.spawnProjectileUsingShootDelayed(projectile, level, spawnedFrom, x2, y2, z2, velocity, inaccuracy).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileUsingShootDelayed(T projectile, WorldServer level, ItemStack spawnedFrom, double x2, double y2, double z2, float velocity, float inaccuracy) {
        return IProjectile.spawnProjectileDelayed(projectile, level, spawnedFrom, projectile1 -> projectile.d(x2, y2, z2, velocity, inaccuracy));
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer level, ItemStack spawnedFrom) {
        return (T)IProjectile.a(projectile, level, spawnedFrom, projectile1 -> {});
    }

    public static <T extends IProjectile> T a(T projectile, WorldServer level, ItemStack stack, Consumer<T> adapter) {
        return IProjectile.spawnProjectileDelayed(projectile, level, stack, adapter).spawn();
    }

    public static <T extends IProjectile> Delayed<T> spawnProjectileDelayed(T projectile, WorldServer level, ItemStack stack, Consumer<T> adapter) {
        adapter.accept(projectile);
        return new Delayed<T>(projectile, level, stack);
    }

    public void b(WorldServer level, ItemStack spawnedFrom) {
        EntityArrow abstractArrow;
        ItemStack weaponItem;
        EnchantmentManager.a(level, spawnedFrom, this, (Item item) -> {});
        IProjectile iProjectile = this;
        if (iProjectile instanceof EntityArrow && (weaponItem = (abstractArrow = (EntityArrow)iProjectile).eq()) != null && !weaponItem.f() && !spawnedFrom.h().equals(weaponItem.h())) {
            EnchantmentManager.a(level, weaponItem, this, abstractArrow::b);
        }
    }

    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, hitResult);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            return this.a(hitResult);
        }
        return ProjectileDeflection.a;
    }

    protected ProjectileDeflection a(MovingObjectPosition hitResult) {
        ProjectileDeflection projectileDeflection1;
        MovingObjectPositionBlock blockHitResult;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            Entity entity = entityHitResult.a();
            ProjectileDeflection projectileDeflection = entity.a(this);
            if (projectileDeflection != ProjectileDeflection.a) {
                if (entity != this.g && this.a(projectileDeflection, entity, this.a, false)) {
                    this.g = entity;
                }
                return projectileDeflection;
            }
        } else if (this.ah_() && hitResult instanceof MovingObjectPositionBlock && (blockHitResult = (MovingObjectPositionBlock)hitResult).f() && this.a(projectileDeflection1 = ProjectileDeflection.b, null, this.a, false)) {
            this.k(this.dN().c(0.2));
            return projectileDeflection1;
        }
        this.b(hitResult);
        return ProjectileDeflection.a;
    }

    protected boolean ah_() {
        return false;
    }

    public boolean a(ProjectileDeflection deflection, @Nullable Entity entity, @Nullable EntityReference<Entity> owner, boolean deflectedByPlayer) {
        deflection.deflect(this, entity, this.as);
        if (!this.ao().B_()) {
            this.a(owner);
            this.a(deflectedByPlayer);
        }
        return true;
    }

    protected void a(boolean deflectedByPlayer) {
    }

    protected void b(Item item) {
    }

    protected void b(MovingObjectPosition result) {
        MovingObjectPosition.EnumMovingObjectType type = result.d();
        if (type == MovingObjectPosition.EnumMovingObjectType.c) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)result;
            Entity entity = entityHitResult.a();
            if (entity.ay().a(TagsEntity.I) && entity instanceof IProjectile) {
                IProjectile projectile = (IProjectile)entity;
                projectile.a(ProjectileDeflection.c, this.p(), this.a, true);
            }
            this.a(entityHitResult);
            this.ao().a(GameEvent.J, result.g(), GameEvent.a.a(this, null));
        } else if (type == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)result;
            this.a(blockHitResult);
            BlockPosition blockPos = blockHitResult.b();
            this.ao().a(GameEvent.J, blockPos, GameEvent.a.a(this, this.ao().a_(blockPos)));
        }
    }

    protected void a(MovingObjectPositionEntity result) {
    }

    protected void a(MovingObjectPositionBlock result) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData blockState = this.ao().a_(result.b());
        blockState.a(this.ao(), blockState, result, this);
    }

    public boolean canHitEntityPublic(Entity target) {
        return this.b(target);
    }

    protected boolean b(Entity target) {
        if (!target.bW()) {
            return false;
        }
        Entity owner = this.p();
        if (owner instanceof EntityPlayer) {
            CraftEntity collided = target.getBukkitEntity();
            Player shooter = (Player)owner.getBukkitEntity();
            if (!shooter.canSee((org.bukkit.entity.Entity)collided)) {
                return false;
            }
        }
        return owner == null || this.d || !owner.A(target);
    }

    protected void q() {
        Vec3D deltaMovement = this.dN();
        double d2 = deltaMovement.i();
        this.w(IProjectile.f(this.ac, (float)(MathHelper.d(deltaMovement.h, d2) * 180.0 / 3.1415927410125732)));
        this.v(IProjectile.f(this.ab, (float)(MathHelper.d(deltaMovement.g, deltaMovement.i) * 180.0 / 3.1415927410125732)));
    }

    protected static float f(float currentRotation, float targetRotation) {
        currentRotation += (float)Math.round((targetRotation - currentRotation) / 360.0f) * 360.0f;
        return MathHelper.h(0.2f, currentRotation, targetRotation);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entity) {
        Entity owner = this.p();
        return new PacketPlayOutSpawnEntity((Entity)this, entity, owner == null ? 0 : owner.aA());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Entity entity = this.ao().a(packet.n());
        if (entity != null) {
            this.d(entity);
        }
    }

    @Override
    public boolean c(WorldServer level, BlockPosition pos) {
        Entity owner = this.p();
        return owner instanceof EntityHuman ? owner.c(level, pos) : owner == null || level.U().a(GameRules.F) != false;
    }

    public boolean a(WorldServer level) {
        return this.ay().a(TagsEntity.h) && level.U().a(GameRules.L) != false;
    }

    @Override
    public boolean bX() {
        return this.ay().a(TagsEntity.I);
    }

    @Override
    public float ci() {
        return this.bX() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair a(EntityLiving entity, DamageSource damageSource) {
        double d2 = this.dN().g;
        double d1 = this.dN().i;
        return DoubleDoubleImmutablePair.of((double)d2, (double)d1);
    }

    @Override
    public int co() {
        return 2;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (!this.d(damageSource)) {
            this.bT();
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends IProjectile> {
        public T create(WorldServer var1, EntityLiving var2, ItemStack var3);
    }

    public record Delayed<T extends IProjectile>(T projectile, WorldServer world, ItemStack projectileStack) {
        public boolean attemptSpawn() {
            if (!this.world.b((Entity)this.projectile)) {
                return false;
            }
            ((IProjectile)this.projectile).b(this.world, this.projectileStack);
            return true;
        }

        public T spawn() {
            this.attemptSpawn();
            return this.projectile();
        }

        public boolean attemptSpawn(CreatureSpawnEvent.SpawnReason reason) {
            if (!this.world.addFreshEntity((Entity)this.projectile, reason)) {
                return false;
            }
            ((IProjectile)this.projectile).b(this.world, this.projectileStack);
            return true;
        }

        public T spawn(CreatureSpawnEvent.SpawnReason reason) {
            this.attemptSpawn(reason);
            return this.projectile();
        }
    }
}

