/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public final class ProjectileHelper {
    public static final float a = 0.3f;

    public static MovingObjectPosition a(Entity projectile, Predicate<Entity> filter) {
        Vec3D deltaMovement = projectile.dN();
        World level = projectile.ao();
        Vec3D vec3 = projectile.dI();
        return ProjectileHelper.a(vec3, projectile, filter, deltaMovement, level, ProjectileHelper.a(projectile), RayTrace.BlockCollisionOption.a);
    }

    public static Either<MovingObjectPositionBlock, Collection<MovingObjectPositionEntity>> a(Entity attacker, AttackRange attackRange, Predicate<Entity> filter, RayTrace.BlockCollisionOption clipContext) {
        Vec3D headLookAngle = attacker.ck();
        Vec3D eyePosition = attacker.bV();
        Vec3D vec3 = eyePosition.e(headLookAngle.c((double)attackRange.a(attacker)));
        double d2 = attacker.ag().b(headLookAngle);
        Vec3D vec31 = eyePosition.e(headLookAngle.c((double)attackRange.b(attacker) + Math.max(0.0, d2)));
        return ProjectileHelper.a(attacker, eyePosition, vec3, filter, vec31, attackRange.e(), clipContext);
    }

    public static MovingObjectPosition a(Entity projectile, Predicate<Entity> filter, RayTrace.BlockCollisionOption clipContext) {
        Vec3D deltaMovement = projectile.dN();
        World level = projectile.ao();
        Vec3D vec3 = projectile.dI();
        return ProjectileHelper.a(vec3, projectile, filter, deltaMovement, level, ProjectileHelper.a(projectile), clipContext);
    }

    public static MovingObjectPosition a(Entity source, Predicate<Entity> filter, double scale) {
        Vec3D vec3 = source.h(0.0f).c(scale);
        World level = source.ao();
        Vec3D eyePosition = source.bV();
        return ProjectileHelper.a(eyePosition, source, filter, vec3, level, 0.0f, RayTrace.BlockCollisionOption.a);
    }

    private static MovingObjectPosition a(Vec3D pos, Entity source, Predicate<Entity> filter, Vec3D deltaMovement, World level, float margin, RayTrace.BlockCollisionOption clipContext) {
        MovingObjectPositionEntity entityHitResult;
        Vec3D vec3 = pos.e(deltaMovement);
        MovingObjectPosition hitResult = level.b(new RayTrace(pos, vec3, clipContext, RayTrace.FluidCollisionOption.a, source));
        if (((MovingObjectPosition)hitResult).d() != MovingObjectPosition.EnumMovingObjectType.a) {
            vec3 = hitResult.g();
        }
        if ((entityHitResult = ProjectileHelper.a(level, source, pos, vec3, source.dj().b(deltaMovement).g(1.0), filter, margin)) != null) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    private static Either<MovingObjectPositionBlock, Collection<MovingObjectPositionEntity>> a(Entity source, Vec3D startVec, Vec3D minReachVec, Predicate<Entity> filter, Vec3D maxReachVec, float margin, RayTrace.BlockCollisionOption clipContext) {
        World level = source.ao();
        MovingObjectPositionBlock blockHitResult = level.b(new RayTrace(startVec, maxReachVec, clipContext, RayTrace.FluidCollisionOption.a, source));
        if (blockHitResult.d() != MovingObjectPosition.EnumMovingObjectType.a && startVec.g(maxReachVec = blockHitResult.g()) < startVec.g(minReachVec)) {
            return Either.left(blockHitResult);
        }
        AxisAlignedBB aabb = AxisAlignedBB.a(minReachVec, margin, margin, margin).b(maxReachVec.d(minReachVec)).g(1.0);
        Collection<MovingObjectPositionEntity> manyEntityHitResult = ProjectileHelper.a(level, source, minReachVec, maxReachVec, aabb, filter, margin, clipContext, true);
        return !manyEntityHitResult.isEmpty() ? Either.right(manyEntityHitResult) : Either.left(blockHitResult);
    }

    public static @Nullable MovingObjectPositionEntity a(Entity source, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World level = source.ao();
        double d2 = distance;
        Entity entity = null;
        Vec3D vec3 = null;
        for (Entity entity1 : level.a(source, boundingBox, filter)) {
            Vec3D vec31;
            double d1;
            AxisAlignedBB aabb = entity1.dj().g(entity1.ci());
            Optional<Vec3D> optional = aabb.b(startVec, endVec);
            if (aabb.d(startVec)) {
                if (!(d2 >= 0.0)) continue;
                entity = entity1;
                vec3 = optional.orElse(startVec);
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.g(vec31 = optional.get())) < d2) && d2 != 0.0) continue;
            if (entity1.du() == source.du()) {
                if (d2 != 0.0) continue;
                entity = entity1;
                vec3 = vec31;
                continue;
            }
            entity = entity1;
            vec3 = vec31;
            d2 = d1;
        }
        return entity == null ? null : new MovingObjectPositionEntity(entity, vec3);
    }

    public static @Nullable MovingObjectPositionEntity a(World level, IProjectile source, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        return ProjectileHelper.a(level, (Entity)source, startVec, endVec, boundingBox, filter, ProjectileHelper.a(source));
    }

    public static float a(Entity entity) {
        return Math.max(0.0f, Math.min(0.3f, (float)(entity.at - 2) / 20.0f));
    }

    public static @Nullable MovingObjectPositionEntity a(World level, Entity source, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, float margin) {
        double d2 = Double.MAX_VALUE;
        Optional<Object> optional = Optional.empty();
        Entity entity = null;
        for (Entity entity1 : level.a(source, boundingBox, filter)) {
            double d1;
            AxisAlignedBB aabb = entity1.dj().g(margin);
            Optional<Vec3D> optional1 = aabb.b(startVec, endVec);
            if (!optional1.isPresent() || !((d1 = startVec.g(optional1.get())) < d2)) continue;
            entity = entity1;
            d2 = d1;
            optional = optional1;
        }
        return entity == null ? null : new MovingObjectPositionEntity(entity, (Vec3D)optional.get());
    }

    public static Collection<MovingObjectPositionEntity> a(World level, Entity source, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, boolean includeFromEntity) {
        return ProjectileHelper.a(level, source, startVec, endVec, boundingBox, filter, ProjectileHelper.a(source), RayTrace.BlockCollisionOption.a, includeFromEntity);
    }

    public static Collection<MovingObjectPositionEntity> a(World level, Entity source, Vec3D startVec, Vec3D endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, float margin, RayTrace.BlockCollisionOption clipType, boolean includeFromEntity) {
        ArrayList<MovingObjectPositionEntity> list = new ArrayList<MovingObjectPositionEntity>();
        for (Entity entity : level.a(source, boundingBox, filter)) {
            Optional<Vec3D> optional2;
            Vec3D center;
            Optional<Vec3D> optional1;
            AxisAlignedBB boundingBox1 = entity.dj();
            if (includeFromEntity && boundingBox1.d(startVec)) {
                list.add(new MovingObjectPositionEntity(entity, startVec));
                continue;
            }
            Optional<Vec3D> optional = boundingBox1.b(startVec, endVec);
            if (optional.isPresent()) {
                list.add(new MovingObjectPositionEntity(entity, optional.get()));
                continue;
            }
            if ((double)margin <= 0.0 || (optional1 = boundingBox1.g(margin).b(startVec, endVec)).isEmpty()) continue;
            Vec3D vec3 = optional1.get();
            MovingObjectPositionBlock blockHitResult = level.b(new RayTrace(vec3, center = boundingBox1.f(), clipType, RayTrace.FluidCollisionOption.a, source));
            if (blockHitResult.d() != MovingObjectPosition.EnumMovingObjectType.a) {
                center = blockHitResult.g();
            }
            if (!(optional2 = entity.dj().b(vec3, center)).isPresent()) continue;
            list.add(new MovingObjectPositionEntity(entity, optional2.get()));
        }
        return list;
    }

    public static void a(Entity projectile, float rotationSpeed) {
        Vec3D deltaMovement = projectile.dN();
        if (deltaMovement.h() != 0.0) {
            double d2 = deltaMovement.i();
            projectile.v((float)(MathHelper.d(deltaMovement.i, deltaMovement.g) * 180.0 / 3.1415927410125732) + 90.0f);
            projectile.w((float)(MathHelper.d(d2, deltaMovement.h) * 180.0 / 3.1415927410125732) - 90.0f);
            while (projectile.ee() - projectile.ac < -180.0f) {
                projectile.ac -= 360.0f;
            }
            while (projectile.ee() - projectile.ac >= 180.0f) {
                projectile.ac += 360.0f;
            }
            while (projectile.ec() - projectile.ab < -180.0f) {
                projectile.ab -= 360.0f;
            }
            while (projectile.ec() - projectile.ab >= 180.0f) {
                projectile.ab += 360.0f;
            }
            projectile.w(MathHelper.h(rotationSpeed, projectile.ac, projectile.ee()));
            projectile.v(MathHelper.h(rotationSpeed, projectile.ab, projectile.ec()));
        }
    }

    public static EnumHand a(EntityLiving shooter, Item weapon) {
        return shooter.fx().a(weapon) ? EnumHand.a : EnumHand.b;
    }

    public static EntityArrow a(EntityLiving shooter, ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        ItemArrow arrowItem = (ItemArrow)(arrow.h() instanceof ItemArrow ? arrow.h() : Items.pX);
        EntityArrow abstractArrow = arrowItem.a(shooter.ao(), arrow, shooter, weapon);
        abstractArrow.a(velocity);
        return abstractArrow;
    }
}

