/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.arrow;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.configuration.type.number.IntOr;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.projectile.arrow.EntityThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityArrow
extends IProjectile {
    private static final double e = 2.0;
    private static final int f = 7;
    private static final float g = 0.6f;
    private static final float h = 0.99f;
    private static final short i = 0;
    private static final byte j = 0;
    private static final boolean k = false;
    private static final boolean l = false;
    private static final byte m = 0;
    private static final DataWatcherObject<Byte> n = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> o = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Boolean> p = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.k);
    private static final int q = 1;
    private static final int r = 2;
    private @Nullable IBlockData s;
    protected int b;
    public PickupStatus c = PickupStatus.a;
    public int d = 0;
    public int t = 0;
    public double u = 2.0;
    private SoundEffect aN = this.k();
    private @Nullable IntOpenHashSet aO;
    private @Nullable List<Entity> aP;
    public ItemStack aQ = this.u();
    public @Nullable ItemStack aR = null;

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(type, x2, y2, z2, level, pickupItemStack, firedFromWeapon, null);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @Nullable EntityLiving ownerEntity) {
        this(type, level);
        this.d(ownerEntity);
        this.aQ = pickupItemStack.v();
        this.c(pickupItemStack);
        Unit unit = pickupItemStack.e(DataComponents.x);
        if (unit != null) {
            this.c = PickupStatus.c;
        }
        this.a_(x2, y2, z2);
        if (firedFromWeapon != null && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (firedFromWeapon.f()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            this.aR = firedFromWeapon.v();
            int piercingCount = EnchantmentManager.a(serverLevel, firedFromWeapon, this.aQ);
            if (piercingCount > 0) {
                this.a((byte)piercingCount);
            }
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, EntityLiving owner, World level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        this(type, owner.dP(), owner.dT() - (double)0.1f, owner.dV(), level, pickupItemStack, firedFromWeapon, owner);
    }

    public void b(SoundEffect soundEvent) {
        this.aN = soundEvent;
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.dj().a() * 10.0;
        if (Double.isNaN(d2)) {
            d2 = 1.0;
        }
        return distance < (d2 *= 64.0 * EntityArrow.dc()) * d2;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(n, (byte)0);
        builder.a(o, (byte)0);
        builder.a(p, false);
    }

    @Override
    public void d(double x2, double y2, double z2, float velocity, float inaccuracy) {
        super.d(x2, y2, z2, velocity, inaccuracy);
        this.t = 0;
    }

    @Override
    public void j(Vec3D movement) {
        super.j(movement);
        if (!this.ao().paperConfig().entities.spawning.maxArrowDespawnInvulnerability.enabled()) {
            this.t = 0;
        }
        if (this.f() && movement.h() > 0.0) {
            this.b(false);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (!this.ay && this.d <= 0 && key.equals(p) && this.f()) {
            this.d = 7;
        }
    }

    @Override
    public void g() {
        VoxelShape collisionShape;
        boolean flag = !this.z();
        Vec3D deltaMovement = this.dN();
        BlockPosition blockPos = this.dK();
        IBlockData blockState = this.ao().a_(blockPos);
        if (!blockState.l() && flag && !(collisionShape = blockState.g(this.ao(), blockPos)).c()) {
            Vec3D vec3 = this.dI();
            for (AxisAlignedBB aabb : collisionShape.e()) {
                if (!aabb.a(blockPos).d(vec3)) continue;
                this.k(Vec3D.c);
                this.b(true);
                break;
            }
        }
        if (this.d > 0) {
            --this.d;
        }
        if (this.bA()) {
            this.aT();
        }
        if (this.f() && flag) {
            if (!this.ao().B_()) {
                if (this.s != blockState && this.A()) {
                    this.B();
                } else {
                    this.i();
                }
            }
            ++this.b;
            if (this.cb()) {
                this.aW();
            }
            if (!this.ao().B_()) {
                this.d(this.aS() > 0);
            }
        } else {
            IntOr.Disabled maxArrowDespawnInvulnerability = this.ao().paperConfig().entities.spawning.maxArrowDespawnInvulnerability;
            if (maxArrowDespawnInvulnerability.enabled() && this.at > maxArrowDespawnInvulnerability.intValue()) {
                this.i();
            }
            this.b = 0;
            Vec3D vec31 = this.dI();
            if (this.by()) {
                this.b(this.y());
                this.a(vec31);
            }
            if (this.w()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.ao().a(Particles.g, vec31.g + deltaMovement.g * (double)i2 / 4.0, vec31.h + deltaMovement.h * (double)i2 / 4.0, vec31.i + deltaMovement.i * (double)i2 / 4.0, -deltaMovement.g, -deltaMovement.h + 0.2, -deltaMovement.i);
                }
            }
            float f2 = !flag ? (float)(MathHelper.d(-deltaMovement.g, -deltaMovement.i) * 180.0 / 3.1415927410125732) : (float)(MathHelper.d(deltaMovement.g, deltaMovement.i) * 180.0 / 3.1415927410125732);
            float f1 = (float)(MathHelper.d(deltaMovement.h, deltaMovement.i()) * 180.0 / 3.1415927410125732);
            this.w(EntityArrow.f(this.ee(), f1));
            this.v(EntityArrow.f(this.ec(), f2));
            this.n();
            if (flag) {
                MovingObjectPositionBlock blockHitResult = this.ao().b(new RayTrace(vec31, vec31.e(deltaMovement), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                this.b(blockHitResult);
            } else {
                this.b(vec31.e(deltaMovement));
                this.aW();
            }
            if (!this.by()) {
                this.b(0.99f);
            }
            if (flag && !this.f()) {
                this.bu();
            }
            super.g();
        }
    }

    private void b(MovingObjectPositionBlock hitResult) {
        while (this.cb()) {
            Vec3D vec3 = this.dI();
            ArrayList<MovingObjectPositionEntity> list = new ArrayList<MovingObjectPositionEntity>(this.c(vec3, hitResult.g()));
            list.sort(Comparator.comparingDouble(entityHitResult1 -> vec3.g(entityHitResult1.a().dI())));
            MovingObjectPositionEntity entityHitResult = list.isEmpty() ? null : list.getFirst();
            Vec3D location = ((MovingObjectPosition)Objects.requireNonNullElse(entityHitResult, hitResult)).g();
            this.b(location);
            this.a(vec3, location);
            if (this.aG != null && this.aG.e()) {
                this.cn();
            }
            if (list.isEmpty()) {
                if (!this.cb() || hitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) break;
                this.preHitTargetOrDeflectSelf(hitResult);
                this.aF = true;
                break;
            }
            if (!this.cb() || this.ar) continue;
            ProjectileDeflection projectileDeflection = this.a((Collection<MovingObjectPositionEntity>)list);
            this.aF = true;
            if (this.x() > 0 && projectileDeflection == ProjectileDeflection.a) continue;
        }
    }

    private ProjectileDeflection a(Collection<MovingObjectPositionEntity> hitResults) {
        for (MovingObjectPositionEntity entityHitResult : hitResults) {
            ProjectileDeflection projectileDeflection = this.preHitTargetOrDeflectSelf(entityHitResult);
            if (this.cb() && projectileDeflection == ProjectileDeflection.a) continue;
            return projectileDeflection;
        }
        return ProjectileDeflection.a;
    }

    private void b(float inertia) {
        Vec3D deltaMovement = this.dN();
        this.k(deltaMovement.c((double)inertia));
    }

    private void a(Vec3D pos) {
        Vec3D deltaMovement = this.dN();
        for (int i2 = 0; i2 < 4; ++i2) {
            float f2 = 0.25f;
            this.ao().a(Particles.d, pos.g - deltaMovement.g * 0.25, pos.h - deltaMovement.h * 0.25, pos.i - deltaMovement.i * 0.25, deltaMovement.g, deltaMovement.h, deltaMovement.i);
        }
    }

    @Override
    public ProjectileDeflection preHitTargetOrDeflectSelf(MovingObjectPosition hitResult) {
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.x() > 0) {
                if (this.aO == null) {
                    this.aO = new IntOpenHashSet(5);
                }
                this.aO.add(entityHitResult.a().aA());
            }
        }
        return super.preHitTargetOrDeflectSelf(hitResult);
    }

    @Override
    protected double bs() {
        return 0.05;
    }

    private boolean A() {
        return this.f() && this.ao().b(new AxisAlignedBB(this.dI(), this.dI()).g(0.06));
    }

    private void B() {
        this.b(false);
        Vec3D deltaMovement = this.dN();
        this.k(deltaMovement.d(this.as.i() * 0.2f, this.as.i() * 0.2f, this.as.i() * 0.2f));
        if (!this.ao().paperConfig().entities.spawning.maxArrowDespawnInvulnerability.enabled()) {
            this.t = 0;
        }
    }

    public boolean f() {
        return this.az.a(p);
    }

    protected void b(boolean inGround) {
        this.az.a(p, inGround);
    }

    @Override
    public boolean db() {
        return !this.f();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        super.a(type, movement);
        if (type != EnumMoveType.a && this.A()) {
            this.B();
        }
    }

    protected void i() {
        ++this.t;
        if (this.t >= (this.c == PickupStatus.c ? this.ao().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.c == PickupStatus.a ? this.ao().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.ao().spigotConfig.tridentDespawnRate : this.ao().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void C() {
        if (this.aP != null) {
            this.aP.clear();
        }
        if (this.aO != null) {
            this.aO.clear();
        }
    }

    @Override
    public void b(Item item) {
        this.aR = null;
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (!this.f()) {
            super.a(downwards, pos);
        }
    }

    @Override
    public void m(boolean downwards) {
        if (!this.f()) {
            super.m(downwards);
        }
    }

    @Override
    public void push(double x2, double y2, double z2, @Nullable Entity pushingEntity) {
        if (!this.f()) {
            super.push(x2, y2, z2, pushingEntity);
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity result) {
        EntityCombustByEntityEvent combustEvent;
        World world;
        super.a(result);
        Entity entity = result.a();
        float f2 = (float)this.dN().g();
        double d2 = this.u;
        Entity owner = this.p();
        DamageSource damageSource = this.en().a(this, owner != null ? owner : this);
        if (this.eq() != null && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            d2 = EnchantmentManager.a(serverLevel, this.eq(), entity, damageSource, (float)d2);
        }
        int ceil = MathHelper.e(MathHelper.a((double)f2 * d2, 0.0, 2.147483647E9));
        if (this.x() > 0) {
            if (this.aO == null) {
                this.aO = new IntOpenHashSet(5);
            }
            if (this.aP == null) {
                this.aP = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.aO.size() >= this.x() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.aO.add(entity.aA());
        }
        if (this.w()) {
            long l2 = this.as.a(ceil / 2 + 2);
            ceil = (int)Math.min(l2 + (long)ceil, Integer.MAX_VALUE);
        }
        if (owner instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)owner;
            livingEntity.C(entity);
        }
        if (this.w()) {
            damageSource = damageSource.critical();
        }
        boolean flag = entity.ay() == EntityTypes.R;
        int remainingFireTicks = entity.aS();
        if (this.cp() && !flag && (combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f)).callEvent()) {
            entity.igniteForSeconds(combustEvent.getDuration(), false);
        }
        if (entity.b(damageSource, (float)ceil)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityPlayer serverPlayer;
                EntityLiving livingEntity1 = (EntityLiving)entity;
                if (!this.ao().B_() && this.x() <= 0) {
                    livingEntity1.o(livingEntity1.fs() + 1);
                }
                this.b(livingEntity1, damageSource);
                World world2 = this.ao();
                if (world2 instanceof WorldServer) {
                    WorldServer serverLevel1 = (WorldServer)world2;
                    EnchantmentManager.a(serverLevel1, (Entity)livingEntity1, damageSource, this.eq());
                }
                this.a(livingEntity1);
                if (livingEntity1 instanceof EntityHuman && owner instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)owner;
                    if (!this.bq() && livingEntity1 != serverPlayer) {
                        serverPlayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, 0.0f));
                    }
                }
                if (!entity.cb() && this.aP != null) {
                    this.aP.add(livingEntity1);
                }
                if (!this.ao().B_() && owner instanceof EntityPlayer) {
                    serverPlayer = (EntityPlayer)owner;
                    if (this.aP != null) {
                        CriterionTriggers.I.a(serverPlayer, this.aP, this.aR);
                    } else if (!entity.cb()) {
                        CriterionTriggers.I.a(serverPlayer, List.of(entity), this.aR);
                    }
                }
            }
            this.a(this.aN, 1.0f, 1.2f / (this.as.i() * 0.2f + 0.9f));
            if (this.x() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else {
            entity.h(remainingFireTicks);
            this.a(ProjectileDeflection.b, entity, this.a, false);
            this.k(this.dN().c(0.2));
            World world3 = this.ao();
            if (world3 instanceof WorldServer) {
                WorldServer serverLevel2 = (WorldServer)world3;
                if (this.dN().h() < 1.0E-7) {
                    if (this.c == PickupStatus.b) {
                        this.a(serverLevel2, this.s(), 0.1f);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    protected void b(EntityLiving entity, DamageSource damageSource) {
        float f2;
        World world;
        if (this.aR != null && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.aR, entity, damageSource, 0.0f);
        } else {
            f2 = 0.0f;
        }
        double d2 = f2;
        if (d2 > 0.0) {
            double max = Math.max(0.0, 1.0 - entity.i(GenericAttributes.r));
            Vec3D vec3 = this.dN().d(1.0, 0.0, 1.0).d().c(d2 * 0.6 * max);
            if (vec3.h() > 0.0) {
                entity.push(vec3.g, 0.1, vec3.i, this);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock result) {
        this.s = this.ao().a_(result.b());
        super.a(result);
        ItemStack weaponItem = this.eq();
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (weaponItem != null) {
                this.a(serverLevel, result, weaponItem);
            }
        }
        Vec3D deltaMovement = this.dN();
        Vec3D vec3 = new Vec3D(Math.signum(deltaMovement.g), Math.signum(deltaMovement.h), Math.signum(deltaMovement.i));
        Vec3D vec31 = vec3.c((double)0.05f);
        this.b(this.dI().d(vec31));
        this.k(Vec3D.c);
        this.a(this.r(), 1.0f, 1.2f / (this.as.i() * 0.2f + 0.9f));
        this.b(true);
        this.d = 7;
        this.r(false);
        this.a((byte)0);
        this.b(SoundEffects.aH);
        this.C();
    }

    protected void a(WorldServer level, MovingObjectPositionBlock hitResult, ItemStack stack) {
        EntityLiving livingEntity;
        Vec3D vec3 = hitResult.b().a(hitResult.g());
        Entity entity = this.p();
        EnchantmentManager.a(level, stack, entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null, this, null, vec3, level.a_(hitResult.b()), item -> {
            this.aR = null;
        });
    }

    @Override
    public @Nullable ItemStack eq() {
        return this.aR;
    }

    protected SoundEffect k() {
        return SoundEffects.aH;
    }

    public final SoundEffect r() {
        return this.aN;
    }

    protected void a(EntityLiving target) {
    }

    protected @Nullable MovingObjectPositionEntity b(Vec3D startVec, Vec3D endVec) {
        return ProjectileHelper.a(this.ao(), this, startVec, endVec, this.dj().b(this.dN()).g(1.0), this::b);
    }

    protected Collection<MovingObjectPositionEntity> c(Vec3D startVec, Vec3D endVec) {
        return ProjectileHelper.a(this.ao(), (Entity)this, startVec, endVec, this.dj().b(this.dN()).g(1.0), this::b, false);
    }

    @Override
    protected boolean b(Entity target) {
        EntityHuman player;
        Entity entity;
        return !(target instanceof EntityHuman && (entity = this.p()) instanceof EntityHuman && !(player = (EntityHuman)entity).a((EntityHuman)target) || !super.b(target) || this.aO != null && this.aO.contains(target.aA()));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("life", (short)this.t);
        output.b("inBlockState", IBlockData.a, this.s);
        output.a("shake", (byte)this.d);
        output.a("inGround", this.f());
        output.a("pickup", PickupStatus.d, this.c);
        output.a("damage", this.u);
        output.a("crit", this.w());
        output.a("PierceLevel", this.x());
        output.a("SoundEvent", BuiltInRegistries.b.q(), this.aN);
        output.a("item", ItemStack.b, this.aQ);
        output.b("weapon", ItemStack.b, this.aR);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.t = input.a("life", (short)0);
        this.s = input.a("inBlockState", IBlockData.a).orElse(null);
        this.d = input.a("shake", (byte)0) & 0xFF;
        this.b(input.a("inGround", false));
        this.u = input.a("damage", 2.0);
        this.c = input.a("pickup", PickupStatus.d).orElse(PickupStatus.a);
        this.r(input.a("crit", false));
        this.a(input.a("PierceLevel", (byte)0));
        this.aN = input.a("SoundEvent", BuiltInRegistries.b.q()).orElse(this.k());
        this.a(input.a("item", ItemStack.b).orElse(this.u()));
        this.aR = input.a("weapon", ItemStack.b).orElse(null);
    }

    @Override
    public void d(@Nullable Entity entity) {
        this.setOwner(entity, true);
    }

    public void setOwner(@Nullable Entity entity, boolean resetPickup) {
        PickupStatus pickupStatus;
        super.d(entity);
        if (!resetPickup) {
            return;
        }
        Entity entity2 = entity;
        int n2 = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHuman.class, OminousItemSpawner.class}, (Object)entity2, n2)) {
                case 0: {
                    EntityHuman player = (EntityHuman)entity2;
                    if (this.c != PickupStatus.a) {
                        n2 = 1;
                        continue block4;
                    }
                    pickupStatus = PickupStatus.b;
                    break block4;
                }
                case 1: {
                    OminousItemSpawner ominousItemSpawner = (OminousItemSpawner)entity2;
                    pickupStatus = PickupStatus.a;
                    break block4;
                }
                default: {
                    pickupStatus = this.c;
                    break block4;
                }
            }
            break;
        }
        this.c = pickupStatus;
    }

    @Override
    public void a_(EntityHuman entity) {
        if (!this.ao().B_() && (this.f() || this.z()) && this.d <= 0) {
            ItemStack itemstack = this.s();
            if (this.c == PickupStatus.b && !itemstack.f() && entity.gK().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)entity.getBukkitEntity(), (org.bukkit.entity.Item)item.getBukkitEntity(), (AbstractArrow)this.getBukkitEntity());
                if (!event.callEvent()) {
                    return;
                }
                itemstack = item.e();
            }
            if (this.c == PickupStatus.b && entity.gK().g(itemstack) || this.c == PickupStatus.c && entity.gL().d) {
                entity.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman player) {
        return switch (this.c.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> player.gK().g(this.s());
            case 2 -> player.gv();
        };
    }

    public ItemStack s() {
        return this.aQ.v();
    }

    protected abstract ItemStack u();

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    public ItemStack v() {
        return this.aQ;
    }

    public void i(double baseDamage) {
        this.u = baseDamage;
    }

    @Override
    public boolean cT() {
        return this.ay().a(TagsEntity.I);
    }

    public void r(boolean critArrow) {
        this.a(1, critArrow);
    }

    public void a(byte pierceLevel) {
        this.az.a(o, pierceLevel);
    }

    private void a(int id, boolean value) {
        byte b2 = this.az.a(n);
        if (value) {
            this.az.a(n, (byte)(b2 | id));
        } else {
            this.az.a(n, (byte)(b2 & ~id));
        }
    }

    public void a(ItemStack pickupItemStack) {
        this.aQ = !pickupItemStack.f() ? pickupItemStack : this.u();
    }

    public boolean w() {
        byte b2 = this.az.a(n);
        return (b2 & 1) != 0;
    }

    public byte x() {
        return this.az.a(o);
    }

    public void a(float velocity) {
        this.i((double)(velocity * 2.0f) + this.as.a((double)this.ao().av().a() * 0.11, 0.57425));
    }

    protected float y() {
        return 0.6f;
    }

    public void s(boolean noPhysics) {
        this.ar = noPhysics;
        this.a(2, noPhysics);
    }

    public boolean z() {
        return !this.ao().B_() ? this.ar : (this.az.a(n) & 2) != 0;
    }

    @Override
    public boolean bX() {
        return super.bX() && !this.f();
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        return slot == 0 ? SlotAccess.a(this::v, this::a) : super.a_(slot);
    }

    @Override
    protected boolean ah_() {
        return true;
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus a = new PickupStatus();
        public static final /* enum */ PickupStatus b = new PickupStatus();
        public static final /* enum */ PickupStatus c = new PickupStatus();
        public static final Codec<PickupStatus> d;
        private static final /* synthetic */ PickupStatus[] e;

        public static PickupStatus[] values() {
            return (PickupStatus[])e.clone();
        }

        public static PickupStatus valueOf(String name) {
            return Enum.valueOf(PickupStatus.class, name);
        }

        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{a, b, c};
        }

        static {
            e = PickupStatus.a();
            d = Codec.BYTE.xmap(PickupStatus::a, pickup -> (byte)pickup.ordinal());
        }
    }
}

