/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile;

import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityFireball
extends IProjectile {
    public static final double b = 0.1;
    public static final double c = 0.5;
    public double d = 0.1;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, World level) {
        super((EntityTypes<? extends IProjectile>)type, level);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, World level) {
        this(type, level);
        this.a_(x2, y2, z2);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, Vec3D movement, World level) {
        this(type, level);
        this.b(x2, y2, z2, this.ec(), this.ee());
        this.aH();
        this.a(movement, this.d);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, EntityLiving owner, Vec3D movement, World level) {
        this(type, owner.dP(), owner.dR(), owner.dV(), movement, level);
        this.d(owner);
        this.a(owner.ec(), owner.ee());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    public boolean a(double distance) {
        double d2 = this.dj().a() * 4.0;
        if (Double.isNaN(d2)) {
            d2 = 4.0;
        }
        return distance < (d2 *= 64.0) * d2;
    }

    protected RayTrace.BlockCollisionOption f() {
        return RayTrace.BlockCollisionOption.a;
    }

    @Override
    public void g() {
        Entity owner = this.p();
        this.u();
        if (this.ao().B_() || (owner == null || !owner.eh()) && this.ao().H(this.dK())) {
            MovingObjectPosition hitResultOnMoveVector = ProjectileHelper.a((Entity)this, this::b, this.f());
            Vec3D location = hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a ? hitResultOnMoveVector.g() : this.dI().e(this.dN());
            ProjectileHelper.a((Entity)this, 0.2f);
            this.b(location);
            this.aW();
            super.g();
            if (this.i()) {
                this.e(1.0f);
            }
            if (hitResultOnMoveVector.d() != MovingObjectPosition.EnumMovingObjectType.a && this.cb()) {
                this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
            }
            this.v();
        } else {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void u() {
        float liquidInertia;
        Vec3D deltaMovement = this.dN();
        Vec3D vec3 = this.dI();
        if (this.by()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                float f2 = 0.25f;
                this.ao().a(Particles.d, vec3.g - deltaMovement.g * 0.25, vec3.h - deltaMovement.h * 0.25, vec3.i - deltaMovement.i * 0.25, deltaMovement.g, deltaMovement.h, deltaMovement.i);
            }
            liquidInertia = this.s();
        } else {
            liquidInertia = this.r();
        }
        this.k(deltaMovement.e(deltaMovement.d().c(this.d)).c((double)liquidInertia));
    }

    private void v() {
        ParticleParam trailParticle = this.k();
        Vec3D vec3 = this.dI();
        if (trailParticle != null) {
            this.ao().a(trailParticle, vec3.g, vec3.h + 0.5, vec3.i, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    protected boolean b(Entity target) {
        return super.b(target) && !target.ar;
    }

    protected boolean i() {
        return true;
    }

    protected @Nullable ParticleParam k() {
        return Particles.ai;
    }

    protected float r() {
        return 0.95f;
    }

    protected float s() {
        return 0.8f;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("acceleration_power", this.d);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.d = input.a("acceleration_power", 0.1);
    }

    @Override
    public float bO() {
        return 1.0f;
    }

    public void a(Vec3D movement, double accelerationPower) {
        this.k(movement.d().c(accelerationPower));
        this.aF = true;
    }

    @Override
    protected void a(boolean deflectedByPlayer) {
        super.a(deflectedByPlayer);
        this.d = deflectedByPlayer ? 0.1 : (this.d *= 0.5);
    }
}

