/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExpBottleEvent;

public class EntityThrownExpBottle
extends EntityProjectileThrowable {
    public EntityThrownExpBottle(EntityTypes<? extends EntityThrownExpBottle> type, World level) {
        super((EntityTypes<? extends EntityProjectileThrowable>)type, level);
    }

    public EntityThrownExpBottle(World level, EntityLiving owner, ItemStack item) {
        super(EntityTypes.Y, owner, level, item);
    }

    public EntityThrownExpBottle(World level, double x2, double y2, double z2, ItemStack item) {
        super(EntityTypes.Y, x2, y2, z2, level, item);
    }

    @Override
    public Item f() {
        return Items.wh;
    }

    @Override
    protected double bs() {
        return 0.07;
    }

    @Override
    protected void b(MovingObjectPosition result) {
        super.b(result);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            int i2 = 3 + serverLevel.y.a(5) + serverLevel.y.a(5);
            ExpBottleEvent event = CraftEventFactory.callExpBottleEvent(this, result, i2);
            i2 = event.getExperience();
            if (result instanceof MovingObjectPositionBlock) {
                MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)result;
                Vec3D unitVec3 = blockHitResult.c().r();
                EntityExperienceOrb.awardWithDirection(serverLevel, result.g(), unitVec3, i2, ExperienceOrb.SpawnReason.EXP_BOTTLE, this.p(), this);
            } else {
                EntityExperienceOrb.awardWithDirection(serverLevel, result.g(), this.dN().c(-1.0), i2, ExperienceOrb.SpawnReason.EXP_BOTTLE, this.p(), this);
            }
            if (event.getShowEffect()) {
                this.ao().c(2002, this.dK(), -13083194);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

