/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.LingeringPotionSplashEvent;

public class ThrownLingeringPotion
extends EntityPotion {
    public ThrownLingeringPotion(EntityTypes<? extends ThrownLingeringPotion> type, World level) {
        super((EntityTypes<? extends EntityPotion>)type, level);
    }

    public ThrownLingeringPotion(World level, EntityLiving owner, ItemStack item) {
        super(EntityTypes.be, level, owner, item);
    }

    public ThrownLingeringPotion(World level, double x2, double y2, double z2, ItemStack item) {
        super(EntityTypes.be, level, x2, y2, z2, item);
    }

    @Override
    public Item f() {
        return Items.xG;
    }

    @Override
    public boolean onHitAsPotion(WorldServer level, ItemStack stack, MovingObjectPosition hitResult) {
        EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(this.ao(), this.dP(), this.dR(), this.dV());
        Entity entity = this.p();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            areaEffectCloud.a(livingEntity);
        }
        areaEffectCloud.a(3.0f);
        areaEffectCloud.c(-0.5f);
        areaEffectCloud.a(600);
        areaEffectCloud.d(10);
        areaEffectCloud.d(-areaEffectCloud.c() / (float)areaEffectCloud.h());
        areaEffectCloud.c(stack);
        boolean noEffects = this.e().a(DataComponents.Y, PotionContents.a).c();
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, hitResult, areaEffectCloud);
        if (!(event.isCancelled() || areaEffectCloud.eh() || !event.allowsEmptyCreation() && noEffects && !areaEffectCloud.u.c())) {
            level.b(areaEffectCloud);
        } else {
            areaEffectCloud.discard(null);
        }
        return !event.isCancelled();
    }
}

