/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.jspecify.annotations.Nullable;

public class Raid {
    private static final String PDC_NBT_KEY = "BukkitValues";
    private static final CraftPersistentDataTypeRegistry PDC_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public final CraftPersistentDataContainer persistentDataContainer;
    public int idOrNegativeOne = -1;
    public static final SpawnPlacementType a = EntityPositionTypes.a(EntityTypes.bh);
    public static final MapCodec<Raid> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("started").forGetter(raid -> raid.D), (App)Codec.BOOL.fieldOf("active").forGetter(raid -> raid.G), (App)Codec.LONG.fieldOf("ticks_active").forGetter(raid -> raid.B), (App)Codec.INT.fieldOf("raid_omen_level").forGetter(raid -> raid.F), (App)Codec.INT.fieldOf("groups_spawned").forGetter(raid -> raid.H), (App)Codec.INT.fieldOf("cooldown_ticks").forGetter(raid -> raid.K), (App)Codec.INT.fieldOf("post_raid_ticks").forGetter(raid -> raid.J), (App)Codec.FLOAT.fieldOf("total_health").forGetter(raid -> Float.valueOf(raid.E)), (App)Codec.INT.fieldOf("group_count").forGetter(raid -> raid.M), (App)Status.e.fieldOf("status").forGetter(raid -> raid.N), (App)BlockPosition.a.fieldOf("center").forGetter(raid -> raid.C), (App)UUIDUtil.b.fieldOf("heroes_of_the_village").forGetter(raid -> raid.A), (App)CraftPersistentDataContainer.createCodec(PDC_TYPE_REGISTRY).lenientOptionalFieldOf(PDC_NBT_KEY).forGetter(raid -> raid.persistentDataContainer.isEmpty() ? Optional.empty() : Optional.of(raid.persistentDataContainer))).apply((Applicative)instance, Raid::new));
    private static final int i = 7;
    private static final int j = 2;
    private static final int k = 32;
    private static final int l = 48000;
    private static final int m = 5;
    private static final IChatBaseComponent n = IChatBaseComponent.c("block.minecraft.ominous_banner");
    private static final String o = "event.minecraft.raid.raiders_remaining";
    public static final int c = 16;
    private static final int p = 40;
    private static final int q = 300;
    public static final int d = 2400;
    public static final int e = 600;
    private static final int r = 30;
    public static final int f = 5;
    private static final int s = 2;
    private static final IChatBaseComponent t = IChatBaseComponent.c("event.minecraft.raid");
    private static final IChatBaseComponent u = IChatBaseComponent.c("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent v = IChatBaseComponent.c("event.minecraft.raid.defeat.full");
    private static final int w = 48000;
    private static final int x = 96;
    public static final int g = 9216;
    public static final int h = 12544;
    private final Map<Integer, EntityRaider> y = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> z = Maps.newHashMap();
    public final Set<UUID> A = Sets.newHashSet();
    public long B;
    private BlockPosition C;
    private boolean D;
    public float E;
    public int F;
    private boolean G;
    private int H;
    public final BossBattleServer I = new BossBattleServer(t, BossBattle.BarColor.c, BossBattle.BarStyle.c);
    private int J;
    private int K;
    private final RandomSource L = RandomSource.a();
    public int M;
    private Status N;
    private int O;
    private Optional<BlockPosition> P = Optional.empty();

    public Raid(BlockPosition center, EnumDifficulty difficulty) {
        this.G = true;
        this.K = 300;
        this.I.a(0.0f);
        this.C = center;
        this.M = this.a(difficulty);
        this.N = Status.a;
        this.persistentDataContainer = new CraftPersistentDataContainer(PDC_TYPE_REGISTRY);
    }

    private Raid(boolean started, boolean active, long ticksActive, int raidOmenLevel, int groupsSpawned, int raidCooldownTicks, int postRaidTicks, float totalHealth, int numGroups, Status status, BlockPosition center, Set<UUID> heroesOfTheVillage, Optional<CraftPersistentDataContainer> persistentDataContainer) {
        this.D = started;
        this.G = active;
        this.B = ticksActive;
        this.F = raidOmenLevel;
        this.H = groupsSpawned;
        this.K = raidCooldownTicks;
        this.J = postRaidTicks;
        this.E = totalHealth;
        this.C = center;
        this.M = numGroups;
        this.N = status;
        this.A.addAll(heroesOfTheVillage);
        this.persistentDataContainer = persistentDataContainer.orElseGet(() -> new CraftPersistentDataContainer(PDC_TYPE_REGISTRY));
    }

    public boolean a() {
        return this.e() || this.f();
    }

    public boolean b() {
        return this.c() && this.p() == 0 && this.K > 0;
    }

    public boolean c() {
        return this.H > 0;
    }

    public boolean d() {
        return this.N == Status.d;
    }

    public boolean e() {
        return this.N == Status.b;
    }

    public boolean f() {
        return this.N == Status.c;
    }

    public boolean isInProgress() {
        return this.N == Status.a;
    }

    public float g() {
        return this.E;
    }

    public Set<EntityRaider> h() {
        HashSet set = Sets.newHashSet();
        for (Set<EntityRaider> set1 : this.z.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public boolean i() {
        return this.D;
    }

    public int j() {
        return this.H;
    }

    private Predicate<EntityPlayer> t() {
        return player -> {
            BlockPosition blockPos = player.dK();
            return player.cb() && player.A().f(blockPos) == this;
        };
    }

    private void b(WorldServer level) {
        HashSet set = Sets.newHashSet(this.I.h());
        List<EntityPlayer> players = level.a(this.t());
        for (EntityPlayer serverPlayer : players) {
            if (set.contains(serverPlayer)) continue;
            this.I.a(serverPlayer);
        }
        for (EntityPlayer serverPlayerx : set) {
            if (players.contains(serverPlayerx)) continue;
            this.I.b(serverPlayerx);
        }
    }

    public int k() {
        return 5;
    }

    public int l() {
        return this.F;
    }

    public void a(int raidOmenLevel) {
        this.F = raidOmenLevel;
    }

    public boolean a(EntityPlayer player) {
        MobEffect effect = player.e(MobEffects.I);
        if (effect == null) {
            return false;
        }
        this.F = this.F + effect.e() + 1;
        this.F = MathHelper.a(this.F, 0, this.k());
        if (!this.c()) {
            player.a(StatisticList.aC);
            CriterionTriggers.K.a(player);
        }
        return true;
    }

    public void m() {
        this.G = false;
        this.I.b();
        this.N = Status.d;
    }

    public void a(WorldServer level) {
        if (!this.d()) {
            if (this.N == Status.a) {
                boolean flag = this.G;
                this.G = level.H(this.C);
                if (level.av() == EnumDifficulty.a) {
                    CraftEventFactory.callRaidStopEvent(level, this, RaidStopEvent.Reason.PEACE);
                    this.m();
                    return;
                }
                if (flag != this.G) {
                    this.I.d(this.G);
                }
                if (!this.G) {
                    return;
                }
                if (!level.e(this.C)) {
                    this.c(level);
                }
                if (!level.e(this.C)) {
                    if (this.H > 0) {
                        this.N = Status.c;
                        CraftEventFactory.callRaidFinishEvent(level, this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(level, this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.m();
                    }
                }
                ++this.B;
                if (this.B >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(level, this, RaidStopEvent.Reason.TIMEOUT);
                    this.m();
                    return;
                }
                int totalRaidersAlive = this.p();
                if (totalRaidersAlive == 0 && this.u()) {
                    if (this.K <= 0) {
                        if (this.K == 0 && this.H > 0) {
                            this.K = 300;
                            this.I.a(t);
                            return;
                        }
                    } else {
                        boolean flag1;
                        boolean isPresent = this.P.isPresent();
                        boolean bl = flag1 = !isPresent && this.K % 5 == 0;
                        if (isPresent && !level.h(this.P.get())) {
                            flag1 = true;
                        }
                        if (flag1) {
                            this.P = this.d(level);
                        }
                        if (this.K == 300 || this.K % 20 == 0) {
                            this.b(level);
                        }
                        --this.K;
                        this.I.a(MathHelper.a((float)(300 - this.K) / 300.0f, 0.0f, 1.0f));
                    }
                }
                if (this.B % 20L == 0L) {
                    this.b(level);
                    this.e(level);
                    if (totalRaidersAlive > 0) {
                        if (totalRaidersAlive <= 2) {
                            this.I.a(t.f().f(" - ").b(IChatBaseComponent.a(o, totalRaidersAlive)));
                        } else {
                            this.I.a(t);
                        }
                    } else {
                        this.I.a(t);
                    }
                }
                if (SharedConstants.T) {
                    this.I.a(t.f().f(" wave: ").f("" + this.H).b(CommonComponents.x).f("Raiders alive: ").f("" + this.p()).b(CommonComponents.x).f("" + this.o()).f(" / ").f("" + this.E).f(" Is bonus? ").f("" + (this.w() && this.x())).f(" Status: ").f(this.N.c()));
                }
                boolean isPresentx = false;
                int i2 = 0;
                while (this.z()) {
                    BlockPosition blockPos = this.P.orElseGet(() -> this.a(level, 20));
                    if (blockPos != null) {
                        this.D = true;
                        this.b(level, blockPos);
                        if (!isPresentx) {
                            this.a(level, blockPos);
                            isPresentx = true;
                        }
                    } else {
                        ++i2;
                    }
                    if (i2 <= 5) continue;
                    CraftEventFactory.callRaidStopEvent(level, this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.m();
                    break;
                }
                if (this.i() && !this.u() && totalRaidersAlive == 0) {
                    if (this.J < 40) {
                        ++this.J;
                    } else {
                        this.N = Status.b;
                        ArrayList<Player> winners = new ArrayList<Player>();
                        for (UUID uuid : this.A) {
                            Entity entity = level.d(uuid);
                            if (!(entity instanceof EntityLiving)) continue;
                            EntityLiving livingEntity = (EntityLiving)entity;
                            if (entity.au()) continue;
                            livingEntity.a(new MobEffect(MobEffects.F, 48000, this.F - 1, false, false, true));
                            if (!(livingEntity instanceof EntityPlayer)) continue;
                            EntityPlayer serverPlayer = (EntityPlayer)livingEntity;
                            serverPlayer.a(StatisticList.aD);
                            CriterionTriggers.J.a(serverPlayer);
                            winners.add(serverPlayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(level, this, winners);
                    }
                }
                this.f(level);
            } else if (this.a()) {
                ++this.O;
                if (this.O >= 600) {
                    CraftEventFactory.callRaidStopEvent(level, this, RaidStopEvent.Reason.FINISHED);
                    this.m();
                    return;
                }
                if (this.O % 20 == 0) {
                    this.b(level);
                    this.I.d(true);
                    if (this.e()) {
                        this.I.a(0.0f);
                        this.I.a(u);
                    } else {
                        this.I.a(v);
                    }
                }
            }
        }
    }

    private void c(WorldServer level) {
        Stream<SectionPosition> stream = SectionPosition.a(SectionPosition.a(this.C), 2);
        stream.filter(level::a).map(SectionPosition::k).min(Comparator.comparingDouble(pos -> pos.j(this.C))).ifPresent(this::a);
    }

    private Optional<BlockPosition> d(WorldServer level) {
        BlockPosition blockPos = this.a(level, 8);
        return blockPos != null ? Optional.of(blockPos) : Optional.empty();
    }

    private boolean u() {
        return this.w() ? !this.x() : !this.v();
    }

    private boolean v() {
        return this.j() == this.M;
    }

    private boolean w() {
        return this.F > 1;
    }

    private boolean x() {
        return this.j() > this.M;
    }

    private boolean y() {
        return this.v() && this.p() == 0 && this.w();
    }

    private void e(WorldServer level) {
        Iterator<Set<EntityRaider>> iterator = this.z.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<EntityRaider> set1 = iterator.next();
            for (EntityRaider raider : set1) {
                BlockPosition blockPos = raider.dK();
                if (raider.eh() || raider.ao().aq() != level.aq() || this.C.j(blockPos) >= 12544.0) {
                    set.add(raider);
                    continue;
                }
                if (raider.at <= 600) continue;
                if (level.d(raider.cY()) == null) {
                    set.add(raider);
                }
                if (!level.e(blockPos) && raider.eP() > 2400) {
                    raider.b(raider.hk() + 1);
                }
                if (raider.hk() < 30) continue;
                set.add(raider);
            }
        }
        for (EntityRaider raider1 : set) {
            this.a(level, raider1, true);
            if (!raider1.gR()) continue;
            this.c(raider1.hi());
        }
    }

    private void a(WorldServer level, BlockPosition pos) {
        float f2 = 13.0f;
        int i2 = 64;
        Collection<EntityPlayer> players = this.I.h();
        long randomLong = this.L.g();
        for (EntityPlayer serverPlayer : level.E()) {
            Vec3D vec3 = serverPlayer.dI();
            Vec3D vec31 = Vec3D.b(pos);
            double squareRoot = Math.sqrt((vec31.g - vec3.g) * (vec31.g - vec3.g) + (vec31.i - vec3.i) * (vec31.i - vec3.i));
            double d2 = vec3.g + 13.0 / squareRoot * (vec31.g - vec3.g);
            double d1 = vec3.i + 13.0 / squareRoot * (vec31.i - vec3.i);
            if (!(squareRoot <= 64.0) && !players.contains(serverPlayer)) continue;
            serverPlayer.g.b(new PacketPlayOutNamedSoundEffect(SoundEffects.xN, SoundCategory.g, d2, serverPlayer.dR(), d1, 64.0f, 1.0f, randomLong));
        }
    }

    private void b(WorldServer level, BlockPosition pos) {
        int i2;
        boolean flag = false;
        int wave = i2 = this.H + 1;
        this.E = 0.0f;
        DifficultyDamageScaler currentDifficultyAt = level.c(pos);
        boolean shouldSpawnBonusGroup = this.y();
        for (Wave raiderType : Wave.f) {
            EntityRaider raider;
            int i1 = this.a(raiderType, i2, shouldSpawnBonusGroup) + this.a(raiderType, this.L, i2, currentDifficultyAt, shouldSpawnBonusGroup);
            int i22 = 0;
            for (int i3 = 0; i3 < i1 && (raider = raiderType.g.a(level, EntitySpawnReason.h)) != null; ++i3) {
                if (!flag && raider.k()) {
                    raider.x(true);
                    this.a(i2, raider);
                    flag = true;
                }
                this.a(level, i2, raider, pos, false);
                if (raiderType.g != EntityTypes.bh) continue;
                EntityRaider raider1 = null;
                if (i2 == this.a(EnumDifficulty.c)) {
                    raider1 = EntityTypes.bb.a(level, EntitySpawnReason.h);
                } else if (i2 >= this.a(EnumDifficulty.d)) {
                    raider1 = i22 == 0 ? (EntityRaider)EntityTypes.W.a(level, EntitySpawnReason.h) : (EntityRaider)EntityTypes.bM.a(level, EntitySpawnReason.h);
                }
                ++i22;
                if (raider1 == null) continue;
                this.a(level, i2, raider1, pos, false);
                raider1.a(pos, 0.0f, 0.0f);
                raider1.a((Entity)raider, false, false);
            }
        }
        this.P = Optional.empty();
        ++this.H;
        this.n();
        this.f(level);
        CraftEventFactory.callRaidSpawnWaveEvent(level, this, Objects.requireNonNull(this.b(wave)), this.z.get(wave));
    }

    public void a(WorldServer level, int wave, EntityRaider raider, @Nullable BlockPosition pos, boolean isRecruited) {
        boolean flag = this.a(level, wave, raider);
        if (flag) {
            raider.a(this);
            raider.a(wave);
            raider.A(true);
            raider.b(0);
            if (!isRecruited && pos != null) {
                raider.a_((double)pos.u() + 0.5, (double)pos.v() + 1.0, (double)pos.w() + 0.5);
                raider.a((WorldAccess)level, level.c(pos), EntitySpawnReason.h, null);
                raider.a(level, wave, false);
                raider.e(true);
                level.addFreshEntityWithPassengers(raider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void n() {
        this.I.a(MathHelper.a(this.o() / this.E, 0.0f, 1.0f));
    }

    public float o() {
        float f2 = 0.0f;
        for (Set<EntityRaider> set : this.z.values()) {
            for (EntityRaider raider : set) {
                f2 += raider.eZ();
            }
        }
        return f2;
    }

    private boolean z() {
        return this.K == 0 && (this.H < this.M || this.y()) && this.p() == 0;
    }

    public int p() {
        return this.z.values().stream().mapToInt(Set::size).sum();
    }

    public void a(WorldServer level, EntityRaider raider, boolean wanderedOutOfRaid) {
        boolean flag;
        Set<EntityRaider> set = this.z.get(raider.hi());
        if (set != null && (flag = set.remove(raider))) {
            if (wanderedOutOfRaid) {
                this.E -= raider.eZ();
            }
            raider.a((Raid)null);
            this.n();
            this.f(level);
        }
    }

    private void f(WorldServer level) {
        level.G().u();
    }

    public static ItemStack a(HolderGetter<EnumBannerPatternType> patternRegistry) {
        ItemStack itemStack = new ItemStack(Items.xe);
        BannerPatternLayers bannerPatternLayers = new BannerPatternLayers.a().a(patternRegistry, BannerPatterns.z, EnumColor.j).a(patternRegistry, BannerPatterns.f, EnumColor.i).a(patternRegistry, BannerPatterns.j, EnumColor.h).a(patternRegistry, BannerPatterns.E, EnumColor.i).a(patternRegistry, BannerPatterns.k, EnumColor.p).a(patternRegistry, BannerPatterns.B, EnumColor.i).a(patternRegistry, BannerPatterns.y, EnumColor.i).a(patternRegistry, BannerPatterns.E, EnumColor.p).a();
        itemStack.b(DataComponents.at, bannerPatternLayers);
        itemStack.b(DataComponents.t, TooltipDisplay.c.a(DataComponents.at, true));
        itemStack.b(DataComponents.k, n);
        itemStack.b(DataComponents.n, EnumItemRarity.b);
        return itemStack;
    }

    public @Nullable EntityRaider b(int wave) {
        return this.y.get(wave);
    }

    private @Nullable BlockPosition a(WorldServer level, int attempts) {
        int i2 = this.K / 20;
        float f2 = 0.22f * (float)i2 - 0.24f;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        float f1 = level.y.i() * ((float)Math.PI * 2);
        for (int i1 = 0; i1 < attempts; ++i1) {
            int i3;
            float f22 = f1 + (float)Math.PI * (float)i1 / 8.0f;
            int i22 = this.C.u() + MathHelper.b(MathHelper.b((double)f22) * 32.0f * f2) + level.y.a(3) * MathHelper.b(f2);
            int height = level.a(HeightMap.Type.b, i22, i3 = this.C.w() + MathHelper.b(MathHelper.a((double)f22) * 32.0f * f2) + level.y.a(3) * MathHelper.b(f2));
            if (MathHelper.a(height - this.C.v()) > 96) continue;
            mutableBlockPos.d(i22, height, i3);
            if (level.e(mutableBlockPos) && i2 > 7) continue;
            int i4 = 10;
            if (!level.b(mutableBlockPos.u() - 10, mutableBlockPos.w() - 10, mutableBlockPos.u() + 10, mutableBlockPos.w() + 10) || !level.h(mutableBlockPos) || !a.isSpawnPositionOk(level, mutableBlockPos, EntityTypes.bh) && (!level.a_(mutableBlockPos.e()).a(Blocks.ep) || !level.a_(mutableBlockPos).l())) continue;
            return mutableBlockPos;
        }
        return null;
    }

    private boolean a(WorldServer level, int wave, EntityRaider raider) {
        return this.a(level, wave, raider, true);
    }

    public boolean a(WorldServer level, int wave, EntityRaider raider, boolean isRecruited) {
        this.z.computeIfAbsent(wave, integer -> Sets.newHashSet());
        Set<EntityRaider> set = this.z.get(wave);
        EntityRaider raider1 = null;
        for (EntityRaider raider2 : set) {
            if (!raider2.cY().equals(raider.cY())) continue;
            raider1 = raider2;
            break;
        }
        if (raider1 != null) {
            set.remove(raider1);
            set.add(raider);
        }
        set.add(raider);
        if (isRecruited) {
            this.E += raider.eZ();
        }
        this.n();
        this.f(level);
        return true;
    }

    public void a(int wave, EntityRaider raider) {
        this.y.put(wave, raider);
        raider.a(EnumItemSlot.f, Raid.a(raider.eo().f(Registries.aR)));
        raider.a(EnumItemSlot.f, 2.0f);
    }

    public void c(int wave) {
        this.y.remove(wave);
    }

    public BlockPosition q() {
        return this.C;
    }

    private void a(BlockPosition center) {
        this.C = center;
    }

    private int a(Wave raiderType, int wave, boolean shouldSpawnBonusGroup) {
        return shouldSpawnBonusGroup ? raiderType.h[this.M] : raiderType.h[wave];
    }

    private int a(Wave raiderType, RandomSource random, int wave, DifficultyDamageScaler difficulty, boolean shouldSpawnBonusGroup) {
        int i2;
        EnumDifficulty difficulty1 = difficulty.a();
        boolean flag = difficulty1 == EnumDifficulty.b;
        boolean flag1 = difficulty1 == EnumDifficulty.c;
        switch (raiderType.ordinal()) {
            case 0: 
            case 2: {
                if (flag) {
                    i2 = random.a(2);
                    break;
                }
                if (flag1) {
                    i2 = 1;
                    break;
                }
                i2 = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag || wave <= 2 || wave == 4) {
                    return 0;
                }
                i2 = 1;
                break;
            }
            case 4: {
                i2 = !flag && shouldSpawnBonusGroup ? 1 : 0;
            }
        }
        return i2 > 0 ? random.a(i2 + 1) : 0;
    }

    public boolean r() {
        return this.G;
    }

    public int a(EnumDifficulty difficulty) {
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case EnumDifficulty.a -> 0;
            case EnumDifficulty.b -> 3;
            case EnumDifficulty.c -> 5;
            case EnumDifficulty.d -> 7;
        };
    }

    public float s() {
        int raidOmenLevel = this.l();
        if (raidOmenLevel == 2) {
            return 0.1f;
        }
        if (raidOmenLevel == 3) {
            return 0.25f;
        }
        if (raidOmenLevel == 4) {
            return 0.5f;
        }
        return raidOmenLevel == 5 ? 0.75f : 0.0f;
    }

    public void a(Entity player) {
        this.A.add(player.cY());
    }

    public Collection<EntityRaider> getRaiders() {
        return this.z.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    static final class Status
    extends Enum<Status>
    implements INamable {
        public static final /* enum */ Status a = new Status("ongoing");
        public static final /* enum */ Status b = new Status("victory");
        public static final /* enum */ Status c = new Status("loss");
        public static final /* enum */ Status d = new Status("stopped");
        public static final Codec<Status> e;
        private final String f;
        private static final /* synthetic */ Status[] g;

        public static Status[] values() {
            return (Status[])g.clone();
        }

        public static Status valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        private Status(String name) {
            this.f = name;
        }

        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ Status[] a() {
            return new Status[]{a, b, c, d};
        }

        static {
            g = Status.a();
            e = INamable.a(Status::values);
        }
    }

    static final class Wave
    extends Enum<Wave> {
        public static final /* enum */ Wave a = new Wave(EntityTypes.bM, new int[]{0, 0, 2, 0, 1, 4, 2, 5});
        public static final /* enum */ Wave b = new Wave(EntityTypes.W, new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        public static final /* enum */ Wave c = new Wave(EntityTypes.bb, new int[]{0, 4, 3, 3, 4, 4, 4, 2});
        public static final /* enum */ Wave d = new Wave(EntityTypes.bQ, new int[]{0, 0, 0, 0, 3, 0, 0, 1});
        public static final /* enum */ Wave e = new Wave(EntityTypes.bh, new int[]{0, 0, 0, 1, 0, 1, 0, 2});
        static final Wave[] f;
        final EntityTypes<? extends EntityRaider> g;
        final int[] h;
        private static final /* synthetic */ Wave[] i;

        public static Wave[] values() {
            return (Wave[])i.clone();
        }

        public static Wave valueOf(String name) {
            return Enum.valueOf(Wave.class, name);
        }

        private Wave(EntityTypes<? extends EntityRaider> entityType, int[] spawnsPerWaveBeforeBonus) {
            this.g = entityType;
            this.h = spawnsPerWaveBeforeBonus;
        }

        private static /* synthetic */ Wave[] a() {
            return new Wave[]{a, b, c, d, e};
        }

        static {
            i = Wave.a();
            f = Wave.values();
        }
    }
}

