/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.destroystokyo.paper.loottable.PaperLootableInventory;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public interface ContainerEntity
extends IInventory,
ITileInventory {
    public Vec3D dI();

    public AxisAlignedBB dj();

    public @Nullable ResourceKey<LootTable> h();

    public void a(@Nullable ResourceKey<LootTable> var1);

    public long i();

    public void a(long var1);

    public NonNullList<ItemStack> j();

    public void k();

    public World ao();

    public boolean eh();

    @Override
    default public boolean c() {
        return this.al_();
    }

    default public void c_(ValueOutput output) {
        if (this.h() != null) {
            output.a("LootTable", this.h().a().toString());
            this.lootableData().saveNbt(output);
            if (this.i() != 0L) {
                output.a("LootTableSeed", this.i());
            }
        }
        ContainerUtil.a(output, this.j());
    }

    default public void b_(ValueInput input) {
        this.k();
        ResourceKey resourceKey = input.a("LootTable", LootTable.a).orElse(null);
        this.a(resourceKey);
        this.a(input.a("LootTableSeed", 0L));
        if (this.h() != null) {
            this.lootableData().loadNbt(input);
        }
        ContainerUtil.a(input, this.j());
    }

    default public void a(DamageSource damageSource, WorldServer level, Entity entity) {
        if (level.U().a(GameRules.k).booleanValue()) {
            InventoryUtils.a((World)level, entity, (IInventory)this);
            Entity directEntity = damageSource.c();
            if (directEntity != null && directEntity.ay() == EntityTypes.cb) {
                PiglinAI.a(level, (EntityHuman)directEntity, true);
            }
        }
    }

    default public EnumInteractionResult c_(EntityHuman player) {
        if (player.a(this).isEmpty()) {
            return EnumInteractionResult.e;
        }
        return EnumInteractionResult.a;
    }

    default public void d_(@Nullable EntityHuman player) {
        MinecraftServer server = this.ao().s();
        if (server != null && this.lootableData().shouldReplenish(this, PaperLootableInventoryData.ENTITY, player)) {
            LootTable lootTable = server.be().a(this.h());
            if (player != null) {
                CriterionTriggers.R.a((EntityPlayer)player, this.h());
            }
            if (this.lootableData().shouldClearLootTable(this, PaperLootableInventoryData.ENTITY, player)) {
                this.a((ResourceKey<LootTable>)null);
            }
            LootParams.a builder = new LootParams.a((WorldServer)this.ao()).a(LootContextParameters.h, this.dI());
            if (player != null) {
                builder.a(player.eB()).a(LootContextParameters.a, player);
            }
            lootTable.a(this, builder.a(LootContextParameterSets.c), this.i());
        }
    }

    default public void ak_() {
        this.d_(null);
        this.j().clear();
    }

    default public boolean al_() {
        for (ItemStack itemStack : this.j()) {
            if (itemStack.f()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack f_(int slot) {
        this.d_(null);
        ItemStack itemStack = this.j().get(slot);
        if (itemStack.f()) {
            return ItemStack.l;
        }
        this.j().set(slot, ItemStack.l);
        return itemStack;
    }

    default public ItemStack g_(int slot) {
        this.d_(null);
        return this.j().get(slot);
    }

    default public ItemStack b(int slot, int amount) {
        this.d_(null);
        return ContainerUtil.a(this.j(), slot, amount);
    }

    default public void c(int slot, ItemStack stack) {
        this.d_(null);
        this.j().set(slot, stack);
        stack.f(this.f_(stack));
    }

    default public @Nullable SlotAccess h_(final int slot) {
        return slot >= 0 && slot < this.b() ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return ContainerEntity.this.g_(slot);
            }

            @Override
            public boolean a(ItemStack carried) {
                ContainerEntity.this.c(slot, carried);
                return true;
            }
        } : null;
    }

    default public boolean e_(EntityHuman player) {
        return !this.eh() && player.a(this.dj(), 4.0);
    }

    default public PaperLootableInventoryData lootableData() {
        throw new UnsupportedOperationException("Implement this method");
    }

    default public PaperLootableInventory getLootableInventory() {
        return (PaperLootableInventory)((Object)((Entity)((Object)this)).getBukkitEntity());
    }
}

