/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle.boat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBoat
extends VehicleEntity
implements Leashable {
    private static final DataWatcherObject<Boolean> s = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> t = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> u = DataWatcher.a(AbstractBoat.class, DataWatcherRegistry.b);
    public static final int d = 0;
    public static final int e = 1;
    private static final int aN = 60;
    private static final float aO = 0.3926991f;
    public static final double f = 0.7853981852531433;
    public static final int r = 60;
    private final float[] aP = new float[2];
    private float aQ;
    private float aR;
    private final InterpolationHandler aS = new InterpolationHandler((Entity)this, 3);
    private boolean aT;
    private boolean aU;
    private boolean aV;
    private boolean aW;
    private double aX;
    private float aY;
    public EnumStatus aZ;
    private EnumStatus ba;
    private double bb;
    private boolean bc;
    private boolean bd;
    private float be;
    private float bf;
    private float bg;
    private @Nullable Leashable.a bh;
    private final Supplier<Item> bi;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public AbstractBoat(EntityTypes<? extends AbstractBoat> type, World level, Supplier<Item> dropItem) {
        super(type, level);
        this.bi = dropItem;
        this.W = true;
    }

    public void o(double x2, double y2, double z2) {
        this.a_(x2, y2, z2);
        this.Y = x2;
        this.Z = y2;
        this.aa = z2;
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(s, false);
        builder.a(t, false);
        builder.a(u, 0);
    }

    @Override
    public boolean i(Entity entity) {
        return AbstractBoat.a((Entity)this, entity);
    }

    public static boolean a(Entity first, Entity second) {
        return (second.j(first) || second.bY()) && !first.A(second);
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return true;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.n(super.a(axis, portal));
    }

    protected abstract double b(EntitySize var1);

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        float singlePassengerXOffset = this.E();
        if (this.dn().size() > 1) {
            int index = this.dn().indexOf(entity);
            singlePassengerXOffset = index == 0 ? 0.2f : -0.6f;
            if (entity instanceof EntityAnimal) {
                singlePassengerXOffset += 0.2f;
            }
        }
        return new Vec3D(0.0, this.b(dimensions), singlePassengerXOffset).b(-this.ec() * ((float)Math.PI / 180));
    }

    @Override
    public void a(boolean downwards, BlockPosition pos) {
        if (this.ao() instanceof WorldServer) {
            this.bc = true;
            this.bd = downwards;
            if (this.M() == 0) {
                this.n(60);
            }
        }
        if (!this.bC() && this.as.a(100) == 0) {
            this.ao().a(this.dP(), this.dR(), this.dV(), this.bl(), this.dB(), 1.0f, 0.8f + 0.4f * this.as.i(), false);
            this.ao().a(Particles.aq, this.dP() + (double)this.as.i(), this.dR() + 0.7, this.dV() + (double)this.as.i(), 0.0, 0.0, 0.0);
            this.a(GameEvent.O, this.dl());
        }
    }

    @Override
    public void h(Entity entity) {
        if (!this.ao().paperConfig().collisions.allowVehicleCollisions && this.ao().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityHuman)) {
            return;
        }
        if (entity instanceof AbstractBoat) {
            if (entity.dj().b < this.dj().e) {
                VehicleEntityCollisionEvent event;
                if (!this.A(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                    return;
                }
                super.h(entity);
            }
        } else if (entity.dj().b <= this.dj().b) {
            VehicleEntityCollisionEvent event;
            if (!this.A(entity) && !(event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity())).callEvent()) {
                return;
            }
            super.h(entity);
        }
    }

    @Override
    public void q(float yaw) {
        this.l(-this.n());
        this.d(10);
        this.a(this.f() * 11.0f);
    }

    @Override
    public boolean bX() {
        return !this.eh();
    }

    @Override
    public InterpolationHandler l_() {
        return this.aS;
    }

    @Override
    public EnumDirection dh() {
        return this.dg().h();
    }

    @Override
    public void g() {
        this.ba = this.aZ;
        this.aZ = this.H();
        this.aQ = this.aZ != EnumStatus.b && this.aZ != EnumStatus.c ? 0.0f : (this.aQ += 1.0f);
        if (!this.ao().B_() && this.aQ >= 60.0f) {
            this.ce();
        }
        if (this.m() > 0) {
            this.d(this.m() - 1);
        }
        if (this.f() > 0.0f) {
            this.a(this.f() - 1.0f);
        }
        super.g();
        this.aS.e();
        if (this.dv()) {
            if (!(this.do() instanceof EntityHuman)) {
                this.a(false, false);
            }
            this.K();
            if (this.ao().B_()) {
                this.L();
                this.ao().a(new PacketPlayInBoatMove(this.m(0), this.m(1)));
            }
            this.a(EnumMoveType.a, this.dN());
        } else {
            this.k(Vec3D.c);
        }
        Location to = CraftLocation.toBukkit(this.dI(), this.ao(), this.ec(), this.ee());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        new VehicleUpdateEvent(vehicle).callEvent();
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            event.callEvent();
        }
        this.lastLocation = vehicle.getLocation();
        this.aW();
        this.aW();
        this.G();
        for (int i2 = 0; i2 <= 1; ++i2) {
            if (this.m(i2)) {
                SoundEffect paddleSound;
                if (!this.bq() && this.aP[i2] % ((float)Math.PI * 2) <= 0.7853982f && (this.aP[i2] + 0.3926991f) % ((float)Math.PI * 2) >= 0.7853982f && (paddleSound = this.q()) != null) {
                    Vec3D viewVector = this.h(1.0f);
                    double d2 = i2 == 1 ? -viewVector.i : viewVector.i;
                    double d1 = i2 == 1 ? viewVector.g : -viewVector.g;
                    this.ao().a(null, this.dP() + d2, this.dR(), this.dV() + d1, paddleSound, this.dB(), 1.0f, 0.8f + 0.4f * this.as.i());
                }
                this.aP[i2] = this.aP[i2] + 0.3926991f;
                continue;
            }
            this.aP[i2] = 0.0f;
        }
        List<Entity> entities = this.ao().a((Entity)this, this.dj().c(0.2f, -0.01f, 0.2f), IEntitySelector.a(this));
        if (!entities.isEmpty()) {
            boolean flag = !this.ao().B_() && !(this.dl() instanceof EntityHuman);
            for (Entity entity : entities) {
                if (entity.z(this)) continue;
                if (flag && this.dn().size() < this.F() && !entity.cq() && this.C(entity) && entity instanceof EntityLiving && !entity.ay().a(TagsEntity.P)) {
                    entity.o(this);
                    continue;
                }
                this.h(entity);
            }
        }
    }

    private void G() {
        if (this.ao().B_()) {
            int bubbleTime = this.M();
            this.be = bubbleTime > 0 ? (this.be += 0.05f) : (this.be -= 0.1f);
            this.be = MathHelper.a(this.be, 0.0f, 1.0f);
            this.bg = this.bf;
            this.bf = 10.0f * (float)Math.sin(0.5 * (double)this.at) * this.be;
        } else {
            int bubbleTime;
            if (!this.bc) {
                this.n(0);
            }
            if ((bubbleTime = this.M()) > 0) {
                this.n(--bubbleTime);
                int i2 = 60 - bubbleTime - 1;
                if (i2 > 0 && bubbleTime == 0) {
                    this.n(0);
                    Vec3D deltaMovement = this.dN();
                    if (this.bd) {
                        this.k(deltaMovement.b(0.0, -0.7, 0.0));
                        this.ce();
                    } else {
                        this.m(deltaMovement.g, this.a((Entity entity) -> entity instanceof EntityHuman) ? 2.7 : 0.6, deltaMovement.i);
                    }
                }
                this.bc = false;
            }
        }
    }

    protected @Nullable SoundEffect q() {
        return switch (this.H().ordinal()) {
            case 0, 1, 2 -> SoundEffects.cy;
            case 3 -> SoundEffects.cx;
            default -> null;
        };
    }

    public void a(boolean left, boolean right) {
        this.az.a(s, left);
        this.az.a(t, right);
    }

    public float a(int side, float partialTick) {
        return this.m(side) ? MathHelper.b(partialTick, this.aP[side] - 0.3926991f, this.aP[side]) : 0.0f;
    }

    @Override
    public @Nullable Leashable.a T_() {
        return this.bh;
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.bh = leashData;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.88f * this.dG(), 0.64f * this.dF());
    }

    @Override
    public boolean z() {
        return true;
    }

    @Override
    public Vec3D[] A() {
        return Leashable.a(this, 0.0, 0.64, 0.382, 0.88);
    }

    public EnumStatus H() {
        EnumStatus status = this.J();
        if (status != null) {
            this.aX = this.dj().e;
            return status;
        }
        if (this.I()) {
            return EnumStatus.a;
        }
        float groundFriction = this.D();
        if (groundFriction > 0.0f) {
            this.aY = groundFriction;
            return EnumStatus.d;
        }
        return EnumStatus.e;
    }

    public float u() {
        AxisAlignedBB boundingBox = this.dj();
        int floor = MathHelper.c(boundingBox.a);
        int ceil = MathHelper.e(boundingBox.d);
        int floor1 = MathHelper.c(boundingBox.e);
        int ceil1 = MathHelper.e(boundingBox.e - this.bb);
        int floor2 = MathHelper.c(boundingBox.c);
        int ceil2 = MathHelper.e(boundingBox.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (int i2 = floor1; i2 < ceil1; ++i2) {
            float f2 = 0.0f;
            for (int i1 = floor; i1 < ceil; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i1, i2, i22);
                    Fluid fluidState = this.ao().b_(mutableBlockPos);
                    if (fluidState.a(TagsFluid.a)) {
                        f2 = Math.max(f2, fluidState.a(this.ao(), mutableBlockPos));
                    }
                    if (f2 >= 1.0f) continue block0;
                }
            }
            if (!(f2 < 1.0f)) continue;
            return (float)mutableBlockPos.v() + f2;
        }
        return ceil1 + 1;
    }

    public float D() {
        AxisAlignedBB boundingBox = this.dj();
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a, boundingBox.b - 0.001, boundingBox.c, boundingBox.d, boundingBox.b, boundingBox.f);
        int i2 = MathHelper.c(aabb.a) - 1;
        int i1 = MathHelper.e(aabb.d) + 1;
        int i22 = MathHelper.c(aabb.b) - 1;
        int i3 = MathHelper.e(aabb.e) + 1;
        int i4 = MathHelper.c(aabb.c) - 1;
        int i5 = MathHelper.e(aabb.f) + 1;
        VoxelShape voxelShape = VoxelShapes.a(aabb);
        float f2 = 0.0f;
        int i6 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i7 = i2; i7 < i1; ++i7) {
            for (int i8 = i4; i8 < i5; ++i8) {
                int i9 = (i7 != i2 && i7 != i1 - 1 ? 0 : 1) + (i8 != i4 && i8 != i5 - 1 ? 0 : 1);
                if (i9 == 2) continue;
                for (int i10 = i22; i10 < i3; ++i10) {
                    if (i9 > 0 && (i10 == i22 || i10 == i3 - 1)) continue;
                    mutableBlockPos.d(i7, i10, i8);
                    IBlockData blockState = this.ao().a_(mutableBlockPos);
                    if (blockState.b() instanceof BlockWaterLily || !VoxelShapes.c(blockState.g(this.ao(), mutableBlockPos).a(mutableBlockPos), voxelShape, OperatorBoolean.i)) continue;
                    f2 += blockState.b().g();
                    ++i6;
                }
            }
        }
        return f2 / (float)i6;
    }

    private boolean I() {
        AxisAlignedBB boundingBox = this.dj();
        int floor = MathHelper.c(boundingBox.a);
        int ceil = MathHelper.e(boundingBox.d);
        int floor1 = MathHelper.c(boundingBox.b);
        int ceil1 = MathHelper.e(boundingBox.b + 0.001);
        int floor2 = MathHelper.c(boundingBox.c);
        int ceil2 = MathHelper.e(boundingBox.f);
        boolean flag = false;
        this.aX = -1.7976931348623157E308;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.ao().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a)) continue;
                    float f2 = (float)i1 + fluidState.a(this.ao(), mutableBlockPos);
                    this.aX = Math.max((double)f2, this.aX);
                    flag |= boundingBox.b < (double)f2;
                }
            }
        }
        return flag;
    }

    private @Nullable EnumStatus J() {
        AxisAlignedBB boundingBox = this.dj();
        double d2 = boundingBox.e + 0.001;
        int floor = MathHelper.c(boundingBox.a);
        int ceil = MathHelper.e(boundingBox.d);
        int floor1 = MathHelper.c(boundingBox.e);
        int ceil1 = MathHelper.e(d2);
        int floor2 = MathHelper.c(boundingBox.c);
        int ceil2 = MathHelper.e(boundingBox.f);
        boolean flag = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = floor; i2 < ceil; ++i2) {
            for (int i1 = floor1; i1 < ceil1; ++i1) {
                for (int i22 = floor2; i22 < ceil2; ++i22) {
                    mutableBlockPos.d(i2, i1, i22);
                    Fluid fluidState = this.ao().b_(mutableBlockPos);
                    if (!fluidState.a(TagsFluid.a) || !(d2 < (double)((float)mutableBlockPos.v() + fluidState.a(this.ao(), mutableBlockPos)))) continue;
                    if (!fluidState.b()) {
                        return EnumStatus.c;
                    }
                    flag = true;
                }
            }
        }
        return flag ? EnumStatus.b : null;
    }

    @Override
    protected double bs() {
        return 0.04;
    }

    private void K() {
        double d2 = -this.bt();
        double d1 = 0.0;
        float f2 = 0.05f;
        if (this.ba == EnumStatus.e && this.aZ != EnumStatus.e && this.aZ != EnumStatus.d) {
            this.aX = this.f(1.0);
            double d22 = (double)(this.u() - this.dG()) + 0.101;
            if (this.ao().a((Entity)this, this.dj().d(0.0, d22 - this.dR(), 0.0))) {
                this.a(EnumMoveType.a, new Vec3D(0.0, d22 - this.dR(), 0.0));
                this.k(this.dN().d(1.0, 0.0, 1.0));
                this.bb = 0.0;
            }
            this.aZ = EnumStatus.a;
        } else {
            if (this.aZ == EnumStatus.a) {
                d1 = (this.aX - this.dR()) / (double)this.dG();
                f2 = 0.9f;
            } else if (this.aZ == EnumStatus.c) {
                d2 = -7.0E-4;
                f2 = 0.9f;
            } else if (this.aZ == EnumStatus.b) {
                d1 = 0.01f;
                f2 = 0.45f;
            } else if (this.aZ == EnumStatus.e) {
                f2 = 0.9f;
            } else if (this.aZ == EnumStatus.d) {
                f2 = this.aY;
                if (this.dl() instanceof EntityHuman) {
                    this.aY /= 2.0f;
                }
            }
            Vec3D deltaMovement = this.dN();
            this.m(deltaMovement.g * (double)f2, deltaMovement.h + d2, deltaMovement.i * (double)f2);
            this.aR *= f2;
            if (d1 > 0.0) {
                Vec3D deltaMovement1 = this.dN();
                this.m(deltaMovement1.g, (deltaMovement1.h + d1 * (this.bs() / 0.65)) * 0.75, deltaMovement1.i);
            }
        }
    }

    private void L() {
        if (this.cr()) {
            float f2 = 0.0f;
            if (this.aT) {
                this.aR -= 1.0f;
            }
            if (this.aU) {
                this.aR += 1.0f;
            }
            if (this.aU != this.aT && !this.aV && !this.aW) {
                f2 += 0.005f;
            }
            this.v(this.ec() + this.aR);
            if (this.aV) {
                f2 += 0.04f;
            }
            if (this.aW) {
                f2 -= 0.005f;
            }
            this.k(this.dN().b(MathHelper.a((double)(-this.ec() * ((float)Math.PI / 180))) * f2, 0.0, MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))) * f2));
            this.a(this.aU && !this.aT || this.aV, this.aT && !this.aU || this.aV);
        }
    }

    protected float E() {
        return 0.0f;
    }

    public boolean C(Entity entity) {
        return entity.dF() < this.dF();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (!passenger.ay().a(TagsEntity.t)) {
            passenger.v(passenger.ec() + this.aR);
            passenger.r(passenger.cS() + this.aR);
            this.D(passenger);
            if (passenger instanceof EntityAnimal && this.dn().size() == this.F()) {
                int i2 = passenger.aA() % 2 == 0 ? 90 : 270;
                passenger.s(((EntityAnimal)passenger).bC + (float)i2);
                passenger.r(passenger.cS() + (float)i2);
            }
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D collisionHorizontalEscapeVector = AbstractBoat.a(this.dF() * MathHelper.g, (double)passenger.dF(), passenger.ec());
        double d2 = this.dP() + collisionHorizontalEscapeVector.g;
        double d1 = this.dV() + collisionHorizontalEscapeVector.i;
        BlockPosition blockPos = BlockPosition.a(d2, this.dj().e, d1);
        BlockPosition blockPos1 = blockPos.e();
        if (!this.ao().F(blockPos1)) {
            double blockFloorHeight1;
            ArrayList list = Lists.newArrayList();
            double blockFloorHeight = this.ao().m(blockPos);
            if (DismountUtil.a(blockFloorHeight)) {
                list.add(new Vec3D(d2, (double)blockPos.v() + blockFloorHeight, d1));
            }
            if (DismountUtil.a(blockFloorHeight1 = this.ao().m(blockPos1))) {
                list.add(new Vec3D(d2, (double)blockPos1.v() + blockFloorHeight1, d1));
            }
            for (EntityPose pose : passenger.go()) {
                for (Vec3D vec3 : list) {
                    if (!DismountUtil.a(this.ao(), vec3, passenger, pose)) continue;
                    passenger.c(pose);
                    return vec3;
                }
            }
        }
        return super.b(passenger);
    }

    protected void D(Entity entity) {
        entity.s(this.ec());
        float f2 = MathHelper.f(entity.ec() - this.ec());
        float f1 = MathHelper.a(f2, -105.0f, 105.0f);
        entity.ab += f1 - f2;
        entity.v(entity.ec() + f1 - f2);
        entity.r(entity.ec());
    }

    @Override
    public void l(Entity entityToUpdate) {
        this.D(entityToUpdate);
    }

    @Override
    protected void a(ValueOutput output) {
        this.a(output, this.bh);
    }

    @Override
    protected void a(ValueInput input) {
        this.b(input);
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.a(player, hand);
        if (interactionResult != EnumInteractionResult.e) {
            return interactionResult;
        }
        return (EnumInteractionResult)((Object)(player.gA() || !(this.aQ < 60.0f) || !this.ao().B_() && !player.o(this) ? EnumInteractionResult.e : EnumInteractionResult.a));
    }

    @Override
    public void remove(Entity.RemovalReason reason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause eventCause) {
        if (!this.ao().B_() && reason.a() && this.S_()) {
            this.o();
        }
        super.remove(reason, eventCause);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        this.bb = this.dN().h;
        if (!this.cq()) {
            if (onGround) {
                this.l();
            } else if (!this.ao().b_(this.dK().e()).a(TagsFluid.a) && y2 < 0.0) {
                this.an -= (double)((float)y2);
            }
        }
    }

    public boolean m(int side) {
        return this.az.a(side == 0 ? s : t) != false && this.dl() != null;
    }

    private void n(int bubbleTime) {
        this.az.a(u, bubbleTime);
    }

    private int M() {
        return this.az.a(u);
    }

    public float b(float partialTick) {
        return MathHelper.h(partialTick, this.bg, this.bf);
    }

    @Override
    protected boolean s(Entity passenger) {
        return this.dn().size() < this.F() && !this.a(TagsFluid.a);
    }

    protected int F() {
        return 2;
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityLiving livingEntity;
        Entity entity = this.do();
        return entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : super.dl();
    }

    public void a(boolean left, boolean right, boolean up, boolean down) {
        this.aT = left;
        this.aU = right;
        this.aV = up;
        this.aW = down;
    }

    @Override
    public boolean bC() {
        return this.aZ == EnumStatus.b || this.aZ == EnumStatus.c;
    }

    @Override
    public final Item p() {
        return this.bi.get();
    }

    @Override
    public final ItemStack dZ() {
        return new ItemStack(this.bi.get());
    }

    public static final class EnumStatus
    extends Enum<EnumStatus> {
        public static final /* enum */ EnumStatus a = new EnumStatus();
        public static final /* enum */ EnumStatus b = new EnumStatus();
        public static final /* enum */ EnumStatus c = new EnumStatus();
        public static final /* enum */ EnumStatus d = new EnumStatus();
        public static final /* enum */ EnumStatus e = new EnumStatus();
        private static final /* synthetic */ EnumStatus[] f;

        public static EnumStatus[] values() {
            return (EnumStatus[])f.clone();
        }

        public static EnumStatus valueOf(String name) {
            return Enum.valueOf(EnumStatus.class, name);
        }

        private static /* synthetic */ EnumStatus[] a() {
            return new EnumStatus[]{a, b, c, d, e};
        }

        static {
            f = EnumStatus.a();
        }
    }
}

