/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle.minecart;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.jspecify.annotations.Nullable;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte e = 10;
    private static final String f = "explosion_power";
    private static final String g = "explosion_speed_factor";
    private static final String h = "fuse";
    private static final float i = 4.0f;
    private static final float j = 1.0f;
    private static final int k = -1;
    private @Nullable DamageSource l;
    public int m = -1;
    public float n = 4.0f;
    public float o = 1.0f;
    public boolean isIncendiary = false;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> type, World level) {
        super(type, level);
    }

    @Override
    public IBlockData w() {
        return Blocks.cu.m();
    }

    @Override
    public void g() {
        double d2;
        super.g();
        if (this.m > 0) {
            if (this.ao().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dR() > (double)v2)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.m;
            this.ao().a(Particles.ai, this.dP(), this.dR() + 0.5, this.dV(), 0.0, 0.0, 0.0);
        } else if (this.m == 0) {
            this.a(this.l, this.dN().j());
        }
        if (this.ad && (d2 = this.dN().j()) >= (double)0.01f) {
            this.a(this.l, d2);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        EntityArrow abstractArrow;
        Entity entity = damageSource.c();
        if (entity instanceof EntityArrow && (abstractArrow = (EntityArrow)entity).cp()) {
            DamageSource damageSource1 = this.en().d(this, damageSource.d());
            this.a(damageSource1, abstractArrow.dN().h());
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public void a(WorldServer level, DamageSource damageSource) {
        double d2 = this.dN().j();
        if (!EntityMinecartTNT.f(damageSource) && !(d2 >= (double)0.01f)) {
            this.a(level, this.p());
        } else if (this.m < 0) {
            this.e(damageSource);
            this.m = this.as.a(20) + this.as.a(20);
        }
    }

    @Override
    public Item p() {
        return Items.pl;
    }

    @Override
    public ItemStack dZ() {
        return new ItemStack(Items.pl);
    }

    public void a(@Nullable DamageSource damageSource, double radiusModifier) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (serverLevel.U().a(GameRules.ad).booleanValue()) {
                double min = Math.min(Math.sqrt(radiusModifier), 5.0);
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)((double)this.n + (double)this.o * this.as.j() * 1.5 * min), this.isIncendiary);
                if (!event.callEvent()) {
                    this.m = -1;
                    return;
                }
                serverLevel.a((Entity)this, damageSource, null, this.dP(), this.dR(), this.dV(), event.getRadius(), event.getFire(), World.a.d);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else if (this.i()) {
                this.discard(null);
            }
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (fallDistance >= 3.0) {
            double d2 = fallDistance / 10.0;
            this.a(this.l, d2 * d2);
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    @Override
    public void a(WorldServer level, int x2, int y2, int z2, boolean receivingPower) {
        if (receivingPower && this.m < 0) {
            this.e((DamageSource)null);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 10) {
            this.e((DamageSource)null);
        } else {
            super.b(id);
        }
    }

    public void e(@Nullable DamageSource damageSource) {
        WorldServer serverLevel;
        World world = this.ao();
        if (!(world instanceof WorldServer) || (serverLevel = (WorldServer)world).U().a(GameRules.ad).booleanValue()) {
            this.m = 80;
            if (!this.ao().B_()) {
                if (damageSource != null && this.l == null) {
                    this.l = this.en().d(this, damageSource.d());
                }
                this.ao().a((Entity)this, (byte)10);
                if (!this.bq()) {
                    this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.CQ, SoundCategory.e, 1.0f, 1.0f);
                }
            }
        }
    }

    public int e() {
        return this.m;
    }

    public boolean i() {
        return this.m > -1;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData state, Fluid fluidState, float explosionPower) {
        return !this.i() || !state.a(TagsBlock.L) && !level.a_(pos.d()).a(TagsBlock.L) ? super.a(explosion, level, pos, state, fluidState, explosionPower) : 0.0f;
    }

    @Override
    public boolean a(Explosion explosion, IBlockAccess level, BlockPosition pos, IBlockData state, float explosionPower) {
        return (!this.i() || !state.a(TagsBlock.L) && !level.a_(pos.d()).a(TagsBlock.L)) && super.a(explosion, level, pos, state, explosionPower);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.m = input.a(h, -1);
        this.n = MathHelper.a(input.a(f, 4.0f), 0.0f, 128.0f);
        this.o = MathHelper.a(input.a(g, 1.0f), 0.0f, 128.0f);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(h, this.m);
        if (this.n != 4.0f) {
            output.a(f, this.n);
        }
        if (this.o != 1.0f) {
            output.a(g, this.o);
        }
    }

    @Override
    protected boolean a(DamageSource damageSource) {
        return EntityMinecartTNT.f(damageSource);
    }

    private static boolean f(DamageSource damageSource) {
        boolean bl;
        Entity entity = damageSource.c();
        if (entity instanceof IProjectile) {
            IProjectile projectile = (IProjectile)entity;
            bl = projectile.cp();
        } else {
            bl = damageSource.a(DamageTypeTags.i) || damageSource.a(DamageTypeTags.l);
        }
        return bl;
    }
}

