/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodMetaData {
    private static final int a = 0;
    private static final float b = 0.0f;
    public int c = 20;
    public float d = 5.0f;
    public float e;
    private int f;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;

    private void b(int nutrition, float saturationLevel) {
        this.c = MathHelper.a(nutrition + this.c, 0, 20);
        this.d = MathHelper.a(saturationLevel + this.d, 0.0f, (float)this.c);
    }

    public void a(int nutrition, float saturationModifier) {
        this.b(nutrition, FoodConstants.a(nutrition, saturationModifier));
    }

    public void a(FoodInfo foodProperties) {
        this.b(foodProperties.a(), foodProperties.b());
    }

    public void eat(FoodInfo foodProperties, ItemStack stack, EntityPlayer serverPlayer) {
        int oldFoodLevel = this.c;
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(serverPlayer, foodProperties.a() + oldFoodLevel, stack);
        if (!event.isCancelled()) {
            this.b(event.getFoodLevel() - oldFoodLevel, foodProperties.b());
        }
        serverPlayer.getBukkitEntity().sendHealthUpdate();
    }

    public void a(EntityPlayer player) {
        boolean flag;
        WorldServer serverLevel = player.A();
        EnumDifficulty difficulty = serverLevel.av();
        if (this.e > 4.0f) {
            this.e -= 4.0f;
            if (this.d > 0.0f) {
                this.d = Math.max(this.d - 1.0f, 0.0f);
            } else if (difficulty != EnumDifficulty.a) {
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(player, Math.max(this.c - 1, 0));
                if (!event.isCancelled()) {
                    this.c = event.getFoodLevel();
                }
                player.g.b(new PacketPlayOutUpdateHealth(player.getBukkitEntity().getScaledHealth(), this.c, this.d));
            }
        }
        if ((flag = serverLevel.U().a(GameRules.G).booleanValue()) && this.d > 0.0f && player.gX() && this.c >= 20) {
            ++this.f;
            if (this.f >= this.saturatedRegenRate) {
                float min = Math.min(this.d, 6.0f);
                player.heal(min / 6.0f, EntityRegainHealthEvent.RegainReason.SATIATED, true);
                player.causeFoodExhaustion(min, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.f = 0;
            }
        } else if (flag && this.c >= 18 && player.gX()) {
            ++this.f;
            if (this.f >= this.unsaturatedRegenRate) {
                player.heal(1.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                player.causeFoodExhaustion(player.A().spigotConfig.regenExhaustion, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.f = 0;
            }
        } else if (this.c <= 0) {
            ++this.f;
            if (this.f >= this.starvationRate) {
                if (player.eZ() > 10.0f || difficulty == EnumDifficulty.d || player.eZ() > 1.0f && difficulty == EnumDifficulty.c) {
                    player.a(serverLevel, player.en().j(), 1.0f);
                }
                this.f = 0;
            }
        } else {
            this.f = 0;
        }
    }

    public void a(ValueInput input) {
        this.c = input.a("foodLevel", 20);
        this.f = input.a("foodTickTimer", 0);
        this.d = input.a("foodSaturationLevel", 5.0f);
        this.e = input.a("foodExhaustionLevel", 0.0f);
    }

    public void a(ValueOutput output) {
        output.a("foodLevel", this.c);
        output.a("foodTickTimer", this.f);
        output.a("foodSaturationLevel", this.d);
        output.a("foodExhaustionLevel", this.e);
    }

    public int a() {
        return this.c;
    }

    public boolean b() {
        return (float)this.a() > 6.0f;
    }

    public boolean c() {
        return this.c < 20;
    }

    public void a(float exhaustion) {
        this.e = Math.min(this.e + exhaustion, 40.0f);
    }

    public float d() {
        return this.d;
    }

    public void a(int foodLevel) {
        this.c = foodLevel;
    }

    public void b(float saturationLevel) {
        this.d = saturationLevel;
    }
}

