/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.criterion.CriterionConditionBlock;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AdventureModePredicate {
    private static final Logger e = LogUtils.getLogger();
    public static final Codec<AdventureModePredicate> a = ExtraCodecs.c(CriterionConditionBlock.a, ExtraCodecs.b(CriterionConditionBlock.a.listOf())).xmap(AdventureModePredicate::new, adventureModePredicate -> adventureModePredicate.g);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> b = StreamCodec.a(CriterionConditionBlock.b.a(ByteBufCodecs.a()), (C adventureModePredicate) -> adventureModePredicate.g, AdventureModePredicate::new);
    public static final IChatBaseComponent c = IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h);
    public static final IChatBaseComponent d = IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h);
    private static final IChatBaseComponent f = IChatBaseComponent.c("item.canUse.unknown").a(EnumChatFormat.h);
    public final List<CriterionConditionBlock> g;
    private @Nullable List<IChatBaseComponent> h;
    private @Nullable ShapeDetectorBlock i;
    private boolean j;
    private boolean k;

    public AdventureModePredicate(List<CriterionConditionBlock> predicates) {
        this.g = predicates;
    }

    private static boolean a(ShapeDetectorBlock first, @Nullable ShapeDetectorBlock second, boolean checkNbt) {
        if (second == null || first.a() != second.a()) {
            return false;
        }
        if (!checkNbt) {
            return true;
        }
        if (first.b() == null && second.b() == null) {
            return true;
        }
        if (first.b() != null && second.b() != null) {
            boolean var7;
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(e);){
                IRegistryCustom registryAccess = first.c().J_();
                NBTTagCompound compoundTag = AdventureModePredicate.a(first.b(), registryAccess, scopedCollector);
                NBTTagCompound compoundTag1 = AdventureModePredicate.a(second.b(), registryAccess, scopedCollector);
                var7 = Objects.equals(compoundTag, compoundTag1);
            }
            return var7;
        }
        return false;
    }

    private static NBTTagCompound a(TileEntity blockEntity, IRegistryCustom registryAccess, ProblemReporter problemReporter) {
        TagValueOutput tagValueOutput = TagValueOutput.a(problemReporter.a(blockEntity.v()), registryAccess);
        blockEntity.d(tagValueOutput);
        return tagValueOutput.b();
    }

    public boolean a(ShapeDetectorBlock block) {
        if (AdventureModePredicate.a(block, this.i, this.k)) {
            return this.j;
        }
        this.i = block;
        this.k = false;
        for (CriterionConditionBlock blockPredicate : this.g) {
            if (!blockPredicate.a(block)) continue;
            this.k |= blockPredicate.a();
            this.j = true;
            return true;
        }
        this.j = false;
        return false;
    }

    private List<IChatBaseComponent> a() {
        if (this.h == null) {
            this.h = AdventureModePredicate.a(this.g);
        }
        return this.h;
    }

    public void a(Consumer<IChatBaseComponent> tooltipAdder) {
        this.a().forEach(tooltipAdder);
    }

    private static List<IChatBaseComponent> a(List<CriterionConditionBlock> predicates) {
        for (CriterionConditionBlock blockPredicate : predicates) {
            if (!blockPredicate.b().isEmpty()) continue;
            return List.of(f);
        }
        return predicates.stream().flatMap(predicate -> predicate.b().orElseThrow().a()).distinct().map(holder -> ((Block)holder.a()).f().a(EnumChatFormat.i)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof AdventureModePredicate)) return false;
        AdventureModePredicate adventureModePredicate = (AdventureModePredicate)other;
        if (!this.g.equals(adventureModePredicate.g)) return false;
        return true;
    }

    public int hashCode() {
        return this.g.hashCode();
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.g) + "}";
    }
}

