/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.apache.logging.log4j.LogManager;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jspecify.annotations.Nullable;

public class ItemBlock
extends Item {
    @Deprecated
    private final Block a;

    public ItemBlock(Block block, Item.Info properties) {
        super(properties);
        this.a = block;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult interactionResult = this.a(new BlockActionContext(context));
        return !interactionResult.a() && context.n().c(DataComponents.z) ? super.a(context.q(), context.o(), context.p()) : interactionResult;
    }

    public EnumInteractionResult a(BlockActionContext context) {
        CraftBlockState oldBukkitState;
        if (!this.c().a(context.q().Q())) {
            return EnumInteractionResult.d;
        }
        if (!context.b()) {
            return EnumInteractionResult.d;
        }
        BlockActionContext blockPlaceContext = this.b(context);
        if (blockPlaceContext == null) {
            return EnumInteractionResult.d;
        }
        IBlockData placementState = this.c(blockPlaceContext);
        CraftBlockState bukkitState = null;
        if (this instanceof PlaceOnWaterBlockItem || this instanceof SolidBucketItem) {
            bukkitState = CraftBlockStates.getBlockState(blockPlaceContext.q(), blockPlaceContext.a());
        }
        CraftBlockState craftBlockState = oldBukkitState = bukkitState != null ? bukkitState : CraftBlockStates.getBlockState(blockPlaceContext.q(), blockPlaceContext.a());
        if (placementState == null) {
            return EnumInteractionResult.d;
        }
        if (!this.a(blockPlaceContext, placementState)) {
            return EnumInteractionResult.d;
        }
        BlockPosition clickedPos = blockPlaceContext.a();
        World level = blockPlaceContext.q();
        EntityHuman player = blockPlaceContext.o();
        ItemStack itemInHand = blockPlaceContext.n();
        IBlockData blockState = level.a_(clickedPos);
        if (blockState.a(placementState.b())) {
            BlockPlaceEvent placeEvent;
            blockState = this.a(clickedPos, level, itemInHand, blockState);
            try {
                this.a(clickedPos, level, player, itemInHand, blockState);
                ItemBlock.a(level, clickedPos, itemInHand);
            }
            catch (Exception ex) {
                oldBukkitState.revertPlace();
                if (player instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)player;
                    LogManager.getLogger().error("Player {} tried placing invalid block", (Object)player.da(), (Object)ex);
                    serverPlayer.getBukkitEntity().kickPlayer("Packet processing error");
                    return EnumInteractionResult.d;
                }
                throw ex;
            }
            blockState.b().a(level, clickedPos, blockState, (EntityLiving)player, itemInHand);
            if (bukkitState != null && (placeEvent = CraftEventFactory.callBlockPlaceEvent((WorldServer)level, player, blockPlaceContext.p(), bukkitState, clickedPos)) != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                bukkitState.revertPlace();
                player.cn.forceHeldSlot(blockPlaceContext.p());
                return EnumInteractionResult.d;
            }
            if (player instanceof EntityPlayer) {
                CriterionTriggers.z.a((EntityPlayer)player, clickedPos, itemInHand);
            }
        }
        SoundEffectType soundType = blockState.A();
        if (player == null) {
            level.a((Entity)player, clickedPos, this.a(blockState), SoundCategory.e, (soundType.a() + 1.0f) / 2.0f, soundType.b() * 0.8f);
        }
        level.a(GameEvent.i, clickedPos, GameEvent.a.a(player, blockState));
        itemInHand.a(1, (EntityLiving)player);
        return EnumInteractionResult.a.configurePaper(e2 -> e2.placedBlockAt(clickedPos.j()));
    }

    protected SoundEffect a(IBlockData state) {
        return state.A().e();
    }

    public @Nullable BlockActionContext b(BlockActionContext context) {
        return context;
    }

    private static void a(World level, BlockPosition pos, ItemStack stack) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity != null) {
            blockEntity.a(stack);
            blockEntity.e();
        }
    }

    protected boolean a(BlockPosition pos, World level, @Nullable EntityHuman player, ItemStack stack, IBlockData state) {
        return ItemBlock.a(level, player, pos, stack);
    }

    protected @Nullable IBlockData c(BlockActionContext context) {
        IBlockData stateForPlacement = this.c().a(context);
        return stateForPlacement != null && this.b(context, stateForPlacement) ? stateForPlacement : null;
    }

    private IBlockData a(BlockPosition pos, World level, ItemStack stack, IBlockData state) {
        BlockItemStateProperties blockItemStateProperties = stack.a(DataComponents.ax, BlockItemStateProperties.a);
        if (blockItemStateProperties.a()) {
            return state;
        }
        IBlockData blockState = blockItemStateProperties.a(state);
        if (blockState != state) {
            level.a(pos, blockState, 2);
        }
        return blockState;
    }

    protected boolean b(BlockActionContext context, IBlockData state) {
        EntityHuman player = context.o();
        World world = context.q();
        boolean canBuild = (!this.b() || state.a((IWorldReader)world, context.a())) && world.checkEntityCollision(state, player, VoxelShapeCollision.a(player), context.a(), true);
        Player bukkitPlayer = context.o() instanceof EntityPlayer ? (Player)context.o().getBukkitEntity() : null;
        BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(world, context.a()), bukkitPlayer, (BlockData)CraftBlockData.fromData(state), canBuild, CraftEquipmentSlot.getHand(context.p()));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event.isBuildable();
    }

    protected boolean b() {
        return true;
    }

    protected boolean a(BlockActionContext context, IBlockData state) {
        return context.q().a(context.a(), state, 11);
    }

    public static boolean a(World level, @Nullable EntityHuman player, BlockPosition pos, ItemStack stack) {
        TileEntity blockEntity;
        if (level.B_()) {
            return false;
        }
        TypedEntityData<TileEntityTypes<?>> typedEntityData = stack.a(DataComponents.ah);
        if (typedEntityData != null && (blockEntity = level.c_(pos)) != null) {
            TileEntityTypes<?> type = blockEntity.s();
            if (type != typedEntityData.a()) {
                return false;
            }
            if (!type.b() || player != null && (player.hi() || player.gL().d && player.getBukkitEntity().hasPermission("minecraft.nbt.place"))) {
                return typedEntityData.a(blockEntity, level.J_());
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean a(ItemStack stack, @Nullable EntityHuman player) {
        TypedEntityData<TileEntityTypes<?>> typedEntityData;
        if (player != null && player.I().hasPermission(Permissions.b) && (typedEntityData = stack.a(DataComponents.ah)) != null) {
            return typedEntityData.a().b();
        }
        return false;
    }

    public Block c() {
        return this.a;
    }

    public void a(Map<Block, Item> blockToItemMap, Item item) {
        blockToItemMap.put(this.c(), item);
    }

    @Override
    public boolean d() {
        return !(this.c() instanceof BlockShulkerBox);
    }

    @Override
    public void a(EntityItem itemEntity) {
        ItemContainerContents itemContainerContents = itemEntity.e().b(DataComponents.aw, ItemContainerContents.a);
        if (itemContainerContents != null) {
            ItemLiquidUtil.a(itemEntity, itemContainerContents.e());
        }
    }

    public static void a(ItemStack stack, TileEntityTypes<?> blockEntityType, TagValueOutput output) {
        output.c("id");
        if (output.a()) {
            stack.e(DataComponents.ah);
        } else {
            TileEntity.a(output, blockEntityType);
            stack.b(DataComponents.ah, TypedEntityData.a(blockEntityType, output.b()));
        }
    }

    @Override
    public FeatureFlagSet k() {
        return this.c().k();
    }
}

