/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.jspecify.annotations.Nullable;

public class ItemBlockWallable
extends ItemBlock {
    public final Block a;
    private final EnumDirection b;

    public ItemBlockWallable(Block block, Block wallBlock, EnumDirection attachmentDirection, Item.Info properties) {
        super(block, properties);
        this.a = wallBlock;
        this.b = attachmentDirection;
    }

    protected boolean a(IWorldReader level, IBlockData state, BlockPosition pos) {
        return state.a(level, pos);
    }

    @Override
    protected @Nullable IBlockData c(BlockActionContext context) {
        IBlockData stateForPlacement = this.a.a(context);
        IBlockData blockState = null;
        World level = context.q();
        BlockPosition clickedPos = context.a();
        for (EnumDirection direction : context.f()) {
            IBlockData blockState1;
            if (direction == this.b.g()) continue;
            IBlockData iBlockData = blockState1 = direction == this.b ? this.c().a(context) : stateForPlacement;
            if (blockState1 == null || !this.a((IWorldReader)level, blockState1, clickedPos)) continue;
            blockState = blockState1;
            break;
        }
        if (blockState != null) {
            CraftPlayer craftPlayer;
            boolean defaultReturn = level.a(blockState, clickedPos, VoxelShapeCollision.a());
            EntityHuman entityHuman = context.o();
            if (entityHuman instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
                craftPlayer = serverPlayer.getBukkitEntity();
            } else {
                craftPlayer = null;
            }
            CraftPlayer player = craftPlayer;
            BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(context.q(), clickedPos), (Player)player, (BlockData)CraftBlockData.fromData(blockState), defaultReturn, CraftEquipmentSlot.getHand(context.p()));
            context.q().getCraftServer().getPluginManager().callEvent((Event)event);
            return event.isBuildable() ? blockState : null;
        }
        return null;
    }

    @Override
    public void a(Map<Block, Item> blockToItemMap, Item item) {
        super.a(blockToItemMap, item);
        blockToItemMap.put(this.a, item);
    }
}

