/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jspecify.annotations.Nullable;

public class ItemBoat
extends Item {
    private final EntityTypes<? extends AbstractBoat> a;

    public ItemBoat(EntityTypes<? extends AbstractBoat> entityType, Item.Info properties) {
        super(properties);
        this.a = entityType;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        MovingObjectPositionBlock playerPovHitResult = ItemBoat.a(level, player, RayTrace.FluidCollisionOption.c);
        if (playerPovHitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) {
            return EnumInteractionResult.e;
        }
        Vec3D viewVector = player.h(1.0f);
        double d2 = 5.0;
        List<Entity> entities = level.a((Entity)player, player.dj().b(viewVector.c(5.0)).g(1.0), IEntitySelector.h);
        if (!entities.isEmpty()) {
            Vec3D eyePosition = player.bV();
            for (Entity entity : entities) {
                AxisAlignedBB aabb = entity.dj().g(entity.ci());
                if (!aabb.d(eyePosition)) continue;
                return EnumInteractionResult.e;
            }
        }
        if (playerPovHitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, playerPovHitResult.b(), playerPovHitResult.c(), itemInHand, false, hand, playerPovHitResult.g());
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            AbstractBoat boat = this.a(level, playerPovHitResult, itemInHand, player);
            if (boat == null) {
                return EnumInteractionResult.d;
            }
            boat.v(player.ec());
            if (!level.a((Entity)boat, boat.dj())) {
                return EnumInteractionResult.d;
            }
            if (!level.B_()) {
                if (CraftEventFactory.callEntityPlaceEvent(level, playerPovHitResult.b(), player.dg(), player, boat, hand).isCancelled()) {
                    return EnumInteractionResult.d;
                }
                if (!level.b(boat)) {
                    return EnumInteractionResult.e;
                }
                level.a((Entity)player, GameEvent.t, playerPovHitResult.g());
                itemInHand.a(1, (EntityLiving)player);
            }
            player.b(StatisticList.c.b(this));
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    private @Nullable AbstractBoat a(World level, MovingObjectPosition hitResult, ItemStack stack, EntityHuman player) {
        AbstractBoat abstractBoat = this.a.a(level, EntitySpawnReason.m);
        if (abstractBoat != null) {
            Vec3D location = hitResult.g();
            abstractBoat.o(location.g, location.h, location.i);
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                EntityTypes.a((World)serverLevel, stack, player).accept(abstractBoat);
            }
        }
        return abstractBoat;
    }
}

