/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.event.player.PlayerItemCooldownEvent;
import io.papermc.paper.event.player.PlayerItemGroupCooldownEvent;
import net.minecraft.network.protocol.game.PacketPlayOutSetCooldown;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.Player;

public class ItemCooldownPlayer
extends ItemCooldown {
    private final EntityPlayer a;

    public ItemCooldownPlayer(EntityPlayer player) {
        this.a = player;
    }

    private int getCurrentCooldown(MinecraftKey groupId) {
        ItemCooldown.Info cooldownInstance = ((ItemCooldown)this).a.get(groupId);
        if (cooldownInstance == null) {
            return 0;
        }
        return Math.max(0, cooldownInstance.b() - this.b);
    }

    @Override
    public void a(ItemStack item, int duration) {
        MinecraftKey cooldownGroup = this.b(item);
        PlayerItemCooldownEvent event = new PlayerItemCooldownEvent((Player)this.a.getBukkitEntity(), CraftItemType.minecraftToBukkit(item.h()), CraftNamespacedKey.fromMinecraft(cooldownGroup), duration);
        if (event.callEvent()) {
            this.addCooldown(cooldownGroup, event.getCooldown(), false);
        } else {
            this.a.g.b(new PacketPlayOutSetCooldown(cooldownGroup, this.getCurrentCooldown(cooldownGroup)));
        }
    }

    @Override
    public void addCooldown(MinecraftKey groupId, int duration, boolean callEvent) {
        if (callEvent) {
            PlayerItemGroupCooldownEvent event = new PlayerItemGroupCooldownEvent((Player)this.a.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(groupId), duration);
            if (!event.callEvent()) {
                this.a.g.b(new PacketPlayOutSetCooldown(groupId, this.getCurrentCooldown(groupId)));
                return;
            }
            duration = event.getCooldown();
        }
        super.addCooldown(groupId, duration, false);
    }

    @Override
    protected void b(MinecraftKey group, int cooldown) {
        super.b(group, cooldown);
        this.a.g.b(new PacketPlayOutSetCooldown(group, cooldown));
    }

    @Override
    protected void b(MinecraftKey group) {
        super.b(group);
        this.a.g.b(new PacketPlayOutSetCooldown(group, 0));
    }
}

