/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.painting.EntityPainting;
import net.minecraft.world.entity.decoration.painting.PaintingVariant;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemHanging
extends Item {
    private static final IChatBaseComponent a = IChatBaseComponent.c("painting.random").a(EnumChatFormat.h);
    private final EntityTypes<? extends EntityHanging> b;

    public ItemHanging(EntityTypes<? extends EntityHanging> type, Item.Info properties) {
        super(properties);
        this.b = type;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        EntityHanging hangingEntity;
        BlockPosition clickedPos = context.a();
        EnumDirection clickedFace = context.k();
        BlockPosition blockPos = clickedPos.a(clickedFace);
        EntityHuman player = context.o();
        ItemStack itemInHand = context.n();
        if (player != null && !this.a(player, clickedFace, itemInHand, blockPos)) {
            return EnumInteractionResult.d;
        }
        World level = context.q();
        if (this.b == EntityTypes.aR) {
            Optional<EntityPainting> optional = EntityPainting.a(level, blockPos, clickedFace);
            if (optional.isEmpty()) {
                return EnumInteractionResult.c;
            }
            hangingEntity = optional.get();
        } else if (this.b == EntityTypes.ax) {
            hangingEntity = new EntityItemFrame(level, blockPos, clickedFace);
        } else {
            if (this.b != EntityTypes.ak) {
                return EnumInteractionResult.a;
            }
            hangingEntity = new GlowItemFrame(level, blockPos, clickedFace);
        }
        EntityTypes.a(level, itemInHand, player).accept(hangingEntity);
        if (hangingEntity.f()) {
            if (!level.B_()) {
                Player bukkitPlayer = player == null ? null : (Player)player.getBukkitEntity();
                CraftBlock blockClicked = CraftBlock.at(level, blockPos);
                BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(context.p());
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)hangingEntity.getBukkitEntity(), bukkitPlayer, (Block)blockClicked, blockFace, hand, CraftItemStack.asBukkitCopy(itemInHand));
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (player != null) {
                        player.cn.b();
                    }
                    return EnumInteractionResult.d;
                }
                hangingEntity.v();
                level.a((Entity)player, GameEvent.t, hangingEntity.dI());
                level.b(hangingEntity);
            }
            itemInHand.h(1);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.c;
    }

    protected boolean a(EntityHuman player, EnumDirection direction, ItemStack hangingEntityStack, BlockPosition pos) {
        return !direction.o().b() && player.a(pos, direction, hangingEntityStack);
    }

    @Override
    public void a(ItemStack stack, Item.b context, TooltipDisplay tooltipDisplay, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag) {
        if (this.b == EntityTypes.aR && tooltipDisplay.a(DataComponents.aU)) {
            Holder<PaintingVariant> holder = stack.a(DataComponents.aU);
            if (holder != null) {
                holder.a().e().ifPresent(tooltipAdder);
                holder.a().f().ifPresent(tooltipAdder);
                tooltipAdder.accept(IChatBaseComponent.a("painting.dimensions", holder.a().b(), holder.a().c()));
            } else if (flag.b()) {
                tooltipAdder.accept(a);
            }
        }
    }
}

