/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info properties) {
        super(properties);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        BlockPosition clickedPos;
        World level = context.q();
        IBlockData blockState = level.a_(clickedPos = context.a());
        if (blockState.a(TagsBlock.S)) {
            EntityHuman player = context.o();
            if (!level.B_() && player != null) {
                return ItemLeash.bindPlayerMobs(player, level, clickedPos, context.p());
            }
        }
        return EnumInteractionResult.e;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman player, World level, BlockPosition pos, EnumHand interactionHand) {
        Entity leashFenceKnotEntity = null;
        List<Leashable> list = Leashable.a(level, Vec3D.b(pos), (Leashable leashable1) -> leashable1.C() == player);
        boolean flag = false;
        for (Leashable leashable : list) {
            if (leashFenceKnotEntity == null) {
                MutableBoolean created = new MutableBoolean(false);
                leashFenceKnotEntity = EntityLeash.getOrCreateKnot(level, pos, created);
                if (created.booleanValue()) {
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(interactionHand);
                    HangingPlaceEvent event = new HangingPlaceEvent((Hanging)leashFenceKnotEntity.getBukkitEntity(), player != null ? (Player)player.getBukkitEntity() : null, (Block)CraftBlock.at(level, pos), BlockFace.SELF, hand);
                    level.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        leashFenceKnotEntity.discard(null);
                        return EnumInteractionResult.e;
                    }
                }
                ((EntityLeash)leashFenceKnotEntity).k();
            }
            if (!leashable.b_(leashFenceKnotEntity) || !CraftEventFactory.handlePlayerLeashEntityEvent(leashable, leashFenceKnotEntity, player, interactionHand)) continue;
            leashable.a_(leashFenceKnotEntity, true);
            flag = true;
        }
        if (flag) {
            level.a(GameEvent.b, pos, GameEvent.a.a(player));
            return EnumInteractionResult.b;
        }
        if (leashFenceKnotEntity != null) {
            leashFenceKnotEntity.discard(null);
        }
        return EnumInteractionResult.e;
    }

    public static EnumInteractionResult a(EntityHuman player, World world, BlockPosition pos) {
        return ItemLeash.bindPlayerMobs(player, world, pos, EnumHand.a);
    }
}

