/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<?>, ItemMonsterEgg> a = Maps.newIdentityHashMap();

    public ItemMonsterEgg(Item.Info properties) {
        super(properties);
        TypedEntityData<EntityTypes<?>> typedEntityData = this.f().a(DataComponents.af);
        if (typedEntityData != null) {
            a.put(typedEntityData.a(), this);
        }
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        World level = context.q();
        if (!(level instanceof WorldServer)) {
            return EnumInteractionResult.a;
        }
        WorldServer serverLevel = (WorldServer)level;
        ItemStack itemInHand = context.n();
        BlockPosition clickedPos = context.a();
        EnumDirection clickedFace = context.k();
        IBlockData blockState = level.a_(clickedPos);
        TileEntity tileEntity = level.c_(clickedPos);
        if (tileEntity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileEntity);
            EntityTypes<?> type = this.g(itemInHand);
            if (type == null) {
                return EnumInteractionResult.d;
            }
            if (!serverLevel.Z()) {
                EntityHuman entityHuman = context.o();
                if (entityHuman instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entityHuman;
                    serverPlayer.a(IChatBaseComponent.c("advMode.notEnabled.spawner"));
                }
                return EnumInteractionResult.d;
            }
            if (level.paperConfig().entities.spawning.disableMobSpawnerSpawnEggTransformation) {
                return EnumInteractionResult.d;
            }
            spawner.a(type, level.G_());
            level.a(clickedPos, blockState, blockState, 3);
            level.a((Entity)context.o(), GameEvent.c, clickedPos);
            itemInHand.h(1);
            return EnumInteractionResult.a;
        }
        BlockPosition blockPos = blockState.g(level, clickedPos).c() ? clickedPos : clickedPos.a(clickedFace);
        return this.a((EntityLiving)context.o(), itemInHand, level, blockPos, true, !Objects.equals(clickedPos, blockPos) && clickedFace == EnumDirection.b);
    }

    private EnumInteractionResult a(@Nullable EntityLiving owner, ItemStack stack, World level, BlockPosition pos, boolean shouldOffsetY, boolean shouldOffsetYMore) {
        EntityTypes<?> type = this.g(stack);
        if (type == null) {
            return EnumInteractionResult.d;
        }
        if (!type.isAllowedInPeaceful(stack.a(DataComponents.af).b()) && level.av() == EnumDifficulty.a) {
            return EnumInteractionResult.d;
        }
        if (type.a((WorldServer)level, stack, owner, pos, EntitySpawnReason.m, shouldOffsetY, shouldOffsetYMore) != null) {
            stack.a(1, owner);
            level.a((Entity)owner, GameEvent.t, pos);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        MovingObjectPositionBlock playerPovHitResult = ItemMonsterEgg.a(level, player, RayTrace.FluidCollisionOption.b);
        if (playerPovHitResult.d() != MovingObjectPosition.EnumMovingObjectType.b) {
            return EnumInteractionResult.e;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            BlockPosition blockPos = playerPovHitResult.b();
            if (!(level.a_(blockPos).b() instanceof BlockFluids)) {
                return EnumInteractionResult.e;
            }
            if (level.a((Entity)player, blockPos) && player.a(blockPos, playerPovHitResult.c(), itemInHand)) {
                EnumInteractionResult interactionResult = this.a((EntityLiving)player, itemInHand, level, blockPos, false, false);
                if (interactionResult == EnumInteractionResult.a) {
                    player.b(StatisticList.c.b(this));
                }
                return interactionResult;
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.a;
    }

    public boolean a(ItemStack stack, EntityTypes<?> entityType) {
        return Objects.equals(this.g(stack), entityType);
    }

    public static @Nullable ItemMonsterEgg a(@Nullable EntityTypes<?> type) {
        return a.get(type);
    }

    public static Iterable<ItemMonsterEgg> a() {
        return Iterables.unmodifiableIterable(a.values());
    }

    public @Nullable EntityTypes<?> g(ItemStack stack) {
        TypedEntityData<EntityTypes<?>> typedEntityData = stack.a(DataComponents.af);
        return typedEntityData != null ? typedEntityData.a() : null;
    }

    @Override
    public FeatureFlagSet k() {
        return Optional.ofNullable(this.f().a(DataComponents.af)).map(TypedEntityData::a).map(EntityTypes::k).orElseGet(FeatureFlagSet::a);
    }

    public Optional<EntityInsentient> a(EntityHuman player, EntityInsentient mob, EntityTypes<? extends EntityInsentient> entityType, WorldServer level, Vec3D pos, ItemStack stack) {
        if (!this.a(stack, entityType)) {
            return Optional.empty();
        }
        EntityInsentient breedOffspring = mob instanceof EntityAgeable ? ((EntityAgeable)mob).a(level, (EntityAgeable)mob) : entityType.a(level, EntitySpawnReason.m);
        if (breedOffspring == null) {
            return Optional.empty();
        }
        breedOffspring.a_(true);
        if (!breedOffspring.e_()) {
            return Optional.empty();
        }
        breedOffspring.b(pos.a(), pos.b(), pos.c(), 0.0f, 0.0f);
        breedOffspring.c(stack);
        level.addFreshEntityWithPassengers(breedOffspring, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        stack.a(1, (EntityLiving)player);
        return Optional.of(breedOffspring);
    }

    @Override
    public boolean a(ItemStack stack, @Nullable EntityHuman player) {
        TypedEntityData<EntityTypes<?>> typedEntityData;
        if (player != null && player.I().hasPermission(Permissions.b) && (typedEntityData = stack.a(DataComponents.af)) != null) {
            return typedEntityData.a().t();
        }
        return false;
    }
}

