/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import io.papermc.paper.util.SafeAutoClosable;
import io.papermc.paper.util.sanitizer.ItemComponentSanitizer;
import io.papermc.paper.util.sanitizer.ItemObfuscationSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.SwingAnimation;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseEffects;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<IChatBaseComponent> m = List.of(IChatBaseComponent.c("item.op_warning.line1").a(EnumChatFormat.m, EnumChatFormat.r), IChatBaseComponent.c("item.op_warning.line2").a(EnumChatFormat.m), IChatBaseComponent.c("item.op_warning.line3").a(EnumChatFormat.m));
    private static final IChatBaseComponent n = IChatBaseComponent.c("item.unbreakable").a(EnumChatFormat.j);
    private static final IChatBaseComponent o = IChatBaseComponent.c("item.intangible").a(EnumChatFormat.h);
    public static final MapCodec<ItemStack> a = MapCodec.recursive((String)"ItemStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)ExtraCodecs.a(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::N), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(stack -> stack.u.g())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> b = Codec.lazyInitialized(() -> a.codec());
    public static final Codec<ItemStack> c = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.e.fieldOf("id").forGetter(ItemStack::i), (App)DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).forGetter(stack -> stack.u.g())).apply((Applicative)instance, (item, components) -> new ItemStack((Holder<Item>)item, 1, (DataComponentPatch)components))));
    public static final Codec<ItemStack> d = b.validate(ItemStack::a);
    public static final Codec<ItemStack> e = c.validate(ItemStack::a);
    public static final Codec<ItemStack> f = ExtraCodecs.g(b).xmap(optional -> optional.orElse(l), stack -> stack.f() ? Optional.empty() : Optional.of(stack));
    public static final Codec<ItemStack> g = Item.e.xmap(ItemStack::new, ItemStack::i);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> h = ItemStack.b(DataComponentPatch.c);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> i = ItemStack.b(DataComponentPatch.d);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> j = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        public ItemStack a(RegistryFriendlyByteBuf buffer) {
            ItemStack itemStack = (ItemStack)h.decode(buffer);
            if (itemStack.f()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemStack;
        }

        public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
            if (value.f()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            h.encode(buffer, value);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> k = h.a(ByteBufCodecs.a(NonNullList::a));
    private static final Logger p = LogUtils.getLogger();
    public static final ItemStack l = new ItemStack((Void)null);
    private static final IChatBaseComponent q = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private int r;
    private int s;
    @Deprecated
    private @Nullable Item t;
    PatchedDataComponentMap u;
    private @Nullable net.minecraft.world.entity.Entity v;
    private @Nullable CraftItemStack bukkitStack;

    public static DataResult<ItemStack> a(ItemStack stack) {
        DataResult<Unit> dataResult = ItemStack.a(stack.a());
        if (dataResult.isError()) {
            return dataResult.map(unit -> stack);
        }
        return stack.N() > stack.k() ? DataResult.error(() -> "Item stack with stack size of " + stack.N() + " was larger than maximum: " + stack.k()) : DataResult.success((Object)stack);
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> b(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf buffer) {
                int varInt = buffer.l();
                if (varInt <= 0) {
                    return l;
                }
                Holder holder = (Holder)Item.f.decode(buffer);
                DataComponentPatch dataComponentPatch = (DataComponentPatch)codec.decode(buffer);
                return new ItemStack(holder, varInt, dataComponentPatch);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
                if (value.f() || value.h() == null) {
                    buffer.c(0);
                } else {
                    buffer.c(ItemComponentSanitizer.sanitizeCount(ItemObfuscationSession.currentSession(), value, value.N()));
                    Item.f.encode(buffer, value.i());
                    boolean prev = ComponentSerialization.DONT_RENDER_TRANSLATABLES.get();
                    try (SafeAutoClosable ignored = ItemObfuscationSession.withContext(c2 -> c2.itemStack(value));){
                        ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(true);
                        codec.encode(buffer, value.u.g());
                    }
                    finally {
                        ComponentSerialization.DONT_RENDER_TRANSLATABLES.set(prev);
                    }
                }
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> a(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            public ItemStack a(RegistryFriendlyByteBuf buffer) {
                ItemStack itemStack = (ItemStack)codec.decode(buffer);
                if (!itemStack.f()) {
                    RegistryOps<Unit> registryOps = buffer.G().a(NullOps.a);
                    b.encodeStart(registryOps, (Object)itemStack).getOrThrow(DecoderException::new);
                }
                return itemStack;
            }

            public void a(RegistryFriendlyByteBuf buffer, ItemStack value) {
                codec.encode(buffer, value);
            }
        };
    }

    public Optional<TooltipComponent> b() {
        return this.h().k(this);
    }

    @Override
    public DataComponentMap a() {
        return !this.f() ? this.u : DataComponentMap.a;
    }

    public DataComponentMap c() {
        return !this.f() ? this.h().f() : DataComponentMap.a;
    }

    public DataComponentPatch d() {
        return !this.f() ? this.u.g() : DataComponentPatch.a;
    }

    public DataComponentMap e() {
        return !this.f() ? this.u.i() : DataComponentMap.a;
    }

    public boolean d(DataComponentType<?> component) {
        return !this.f() && this.u.d(component);
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> tag) {
        this(tag.a(), 1);
    }

    public ItemStack(Holder<Item> tag, int count, DataComponentPatch components) {
        this(tag.a(), count, PatchedDataComponentMap.a(tag.a().f(), components));
    }

    public ItemStack(Holder<Item> item, int count) {
        this(item.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this(item, count, new PatchedDataComponentMap(item.h().f()));
    }

    private ItemStack(IMaterial item, int count, PatchedDataComponentMap components) {
        this.t = item.h();
        this.r = count;
        this.u = components;
    }

    private ItemStack(@Nullable Void unused) {
        this.t = null;
        this.u = new PatchedDataComponentMap(DataComponentMap.a);
    }

    public static DataResult<Unit> a(DataComponentMap components) {
        if (components.c(DataComponents.d) && components.a(DataComponents.c, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemContainerContents = components.a(DataComponents.aw, ItemContainerContents.a);
        for (ItemStack itemStack : itemContainerContents.d()) {
            int maxStackSize;
            int count = itemStack.N();
            if (count <= (maxStackSize = itemStack.k())) continue;
            return DataResult.error(() -> "Item stack with count of " + count + " was larger than maximum: " + maxStackSize);
        }
        return DataResult.success((Object)((Object)Unit.a));
    }

    public boolean f() {
        return this == l || this.t == Items.a || this.r <= 0;
    }

    public boolean a(FeatureFlagSet enabledFlags) {
        return this.f() || this.h().a(enabledFlags);
    }

    public ItemStack a(int amount) {
        int min = Math.min(amount, this.N());
        ItemStack itemStack = this.c(min);
        this.h(min);
        return itemStack;
    }

    public ItemStack g() {
        if (this.f()) {
            return l;
        }
        ItemStack itemStack = this.v();
        this.e(0);
        return itemStack;
    }

    public Item h() {
        return this.f() ? Items.a : this.t;
    }

    public Holder<Item> i() {
        return this.h().e();
    }

    public boolean a(TagKey<Item> tag) {
        return this.h().e().a(tag);
    }

    public boolean a(Item item) {
        return this.h() == item;
    }

    public boolean a(Predicate<Holder<Item>> item) {
        return item.test(this.h().e());
    }

    public boolean a(Holder<Item> item) {
        return this.h().e() == item;
    }

    public boolean a(HolderSet<Item> item) {
        return item.a(this.i());
    }

    public Stream<TagKey<Item>> j() {
        return this.h().e().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult.d success;
        EnumInteractionResult interactionResult;
        EntityHuman player = context.o();
        BlockPosition clickedPos = context.a();
        if (player != null && !player.gL().e && !this.a(new ShapeDetectorBlock(context.q(), clickedPos, false))) {
            return EnumInteractionResult.e;
        }
        Item item = this.h();
        DataComponentPatch previousPatch = this.u.g();
        int oldCount = this.N();
        WorldServer serverLevel = (WorldServer)context.q();
        if (!(item instanceof ItemBucket)) {
            serverLevel.captureBlockStates = true;
            if (item == Items.tC) {
                serverLevel.captureTreeGeneration = true;
            }
        }
        try {
            interactionResult = item.a(context);
        }
        finally {
            serverLevel.captureBlockStates = false;
        }
        DataComponentPatch newPatch = this.u.g();
        int newCount = this.N();
        this.e(oldCount);
        this.restorePatch(previousPatch);
        if (interactionResult.a() && serverLevel.captureTreeGeneration && !serverLevel.capturedBlockStates.isEmpty()) {
            serverLevel.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit((BaseBlockPosition)clickedPos, (World)serverLevel);
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.h() == Items.tC;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)player.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(serverLevel, clickedPos), (Player)player.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.N() == oldCount && Objects.equals(this.u.g(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.e(newCount);
                }
                for (CraftBlockState snapshot : blocks) {
                    snapshot.place(snapshot.getFlags());
                    serverLevel.checkCapturedTreeStateForObserverNotify(clickedPos, snapshot);
                }
                player.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return interactionResult;
        }
        serverLevel.captureTreeGeneration = false;
        if (player != null && interactionResult instanceof EnumInteractionResult.d && (success = (EnumInteractionResult.d)interactionResult).c()) {
            EnumHand hand = context.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(serverLevel.capturedBlockStates.values());
            serverLevel.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(serverLevel, player, hand, blocks, clickedPos);
            } else if (blocks.size() == 1 && item != Items.sn) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(serverLevel, player, hand, (BlockState)blocks.getFirst(), clickedPos);
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                interactionResult = EnumInteractionResult.d;
                player.cn.forceHeldSlot(hand);
                serverLevel.capturedTileEntities.clear();
                for (BlockState blockstate : blocks) {
                    ((CraftBlockState)blockstate).revertPlace();
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition pos;
                IBlockData state;
                TileEntity te;
                if (this.N() == oldCount && Objects.equals(this.u.g(), previousPatch)) {
                    this.restorePatch(newPatch);
                    this.e(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> e2 : serverLevel.capturedTileEntities.entrySet()) {
                    serverLevel.b(e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlags = ((CraftBlockState)blockstate).getFlags();
                    IBlockData oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newPos = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = serverLevel.a_(newPos);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.onPlace(serverLevel, newPos, oldBlock, true, context);
                    }
                    serverLevel.notifyAndUpdatePhysics(newPos, null, oldBlock, block, serverLevel.a_(newPos), updateFlags, 512);
                }
                if (this.t == Items.wy) {
                    BlockPosition bp = clickedPos;
                    if (!serverLevel.a_(clickedPos).v()) {
                        bp = !serverLevel.a_(clickedPos).e() ? null : bp.a(context.k());
                    }
                    if (bp != null && (te = serverLevel.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((World)serverLevel, bp, (TileEntitySkull)te);
                    }
                }
                if (this.t instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        te = serverLevel.c_(ItemSign.openSign);
                        if (te instanceof TileEntitySign) {
                            TileEntitySign blockEntity = (TileEntitySign)te;
                            Block block = serverLevel.a_(ItemSign.openSign).b();
                            if (block instanceof BlockSign) {
                                BlockSign signBlock = (BlockSign)block;
                                signBlock.openTextEdit(player, blockEntity, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.t instanceof ItemBed && (state = serverLevel.a_(pos = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    serverLevel.a(pos, Blocks.a);
                    state.a((GeneratorAccess)serverLevel, pos, 3);
                }
                if (this.t instanceof ItemBlock && success.paperSuccessContext().placedBlockPosition() != null) {
                    IBlockData state2 = serverLevel.a_(success.paperSuccessContext().placedBlockPosition());
                    SoundEffectType soundType = state2.A();
                    serverLevel.a((net.minecraft.world.entity.Entity)player, clickedPos, soundType.e(), SoundCategory.e, (soundType.a() + 1.0f) / 2.0f, soundType.b() * 0.8f);
                }
                player.b(StatisticList.c.b(item));
            }
        }
        serverLevel.capturedTileEntities.clear();
        serverLevel.capturedBlockStates.clear();
        return interactionResult;
    }

    public float a(IBlockData state) {
        return this.h().a(this, state);
    }

    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        EnumInteractionResult.d success;
        ItemStack itemStack = this.v();
        boolean flag = this.a(player) <= 0;
        EnumInteractionResult interactionResult = this.h().a(level, player, hand);
        return flag && interactionResult instanceof EnumInteractionResult.d ? success.a((success = (EnumInteractionResult.d)interactionResult).d() == null ? this.a((EntityLiving)player, itemStack) : success.d().a((EntityLiving)player, itemStack)) : interactionResult;
    }

    public ItemStack a(World level, EntityLiving livingEntity) {
        ItemStack itemStack = this.v();
        ItemStack itemStack1 = this.h().a(this, level, livingEntity);
        return itemStack1.a(livingEntity, itemStack);
    }

    private ItemStack a(EntityLiving entity, ItemStack stack) {
        UseRemainder useRemainder = stack.a(DataComponents.A);
        UseCooldown useCooldown = stack.a(DataComponents.B);
        int count = stack.N();
        ItemStack itemStack = this;
        if (useRemainder != null) {
            itemStack = useRemainder.a(this, count, entity.gv(), entity::b);
        }
        if (useCooldown != null) {
            useCooldown.a(stack, entity);
        }
        return itemStack;
    }

    public int k() {
        return this.a(DataComponents.c, Integer.valueOf(1));
    }

    public boolean l() {
        return this.k() > 1 && (!this.m() || !this.n());
    }

    public boolean m() {
        return this.c(DataComponents.d) && !this.c(DataComponents.f) && this.c(DataComponents.e);
    }

    public boolean n() {
        return this.m() && this.o() > 0;
    }

    public int o() {
        return MathHelper.a((int)this.a(DataComponents.e, Integer.valueOf(0)), 0, this.p());
    }

    public void b(int damage) {
        this.b(DataComponents.e, Integer.valueOf(MathHelper.a(damage, 0, this.p())));
    }

    public int p() {
        return this.a(DataComponents.d, Integer.valueOf(0));
    }

    public boolean q() {
        return this.m() && this.o() >= this.p();
    }

    public boolean r() {
        return this.m() && this.o() >= this.p() - 1;
    }

    public void hurtAndBreak(int damage, WorldServer level, @Nullable EntityLiving player, Consumer<Item> onBreak) {
        this.hurtAndBreak(damage, level, player, onBreak, false);
    }

    public void hurtAndBreak(int damage, WorldServer level, @Nullable EntityLiving player, Consumer<Item> onBreak, boolean force) {
        int originalDamage = damage;
        int i2 = this.processDurabilityChange(damage, level, player, force);
        if (i2 > 0 && player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2, originalDamage);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDamage();
        } else if (i2 > 0 && player != null) {
            EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2);
            if (!event.callEvent()) {
                return;
            }
            i2 = event.getDamage();
        }
        if (i2 != 0) {
            this.applyDamage(this.o() + i2, player, onBreak);
        }
    }

    private int processDurabilityChange(int damage, WorldServer level, @Nullable EntityLiving player) {
        return this.processDurabilityChange(damage, level, player, false);
    }

    private int processDurabilityChange(int damage, WorldServer level, @Nullable EntityLiving player, boolean force) {
        if (!this.m()) {
            return 0;
        }
        if (player instanceof EntityPlayer && player.gv() && !force) {
            return 0;
        }
        return damage > 0 ? EnchantmentManager.a(level, this, damage) : damage;
    }

    private void applyDamage(int damage, @Nullable EntityLiving player, Consumer<Item> onBreak) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            CriterionTriggers.u.a(serverPlayer, this, damage);
        }
        this.b(damage);
        if (this.q()) {
            Item item = this.h();
            if (this.r == 1 && player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CraftEventFactory.callPlayerItemBreakEvent(serverPlayer, this);
            }
            this.h(1);
            onBreak.accept(item);
        }
    }

    public void a(int damage, EntityHuman player) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            int i2 = this.processDurabilityChange(damage, serverPlayer.A(), serverPlayer);
            if (i2 == 0) {
                return;
            }
            int min = Math.min(this.o() + i2, this.p() - 1);
            if (min - this.o() > 0) {
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), min - this.o(), damage);
                if (!event.callEvent() || event.getDamage() == 0) {
                    return;
                }
                min = Math.min(this.o() + event.getDamage(), this.p() - 1);
            }
            this.applyDamage(min, serverPlayer, item -> {});
        }
    }

    public void a(int amount, EntityLiving entity, EnumHand hand) {
        this.a(amount, entity, hand.a());
    }

    public void a(int amount, EntityLiving entity, EnumItemSlot slot) {
        this.hurtAndBreak(amount, entity, slot, false);
    }

    public void hurtAndBreak(int amount, EntityLiving entity, EnumItemSlot slot, boolean force) {
        World world = entity.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.hurtAndBreak(amount, serverLevel, entity, item -> {
                if (slot != null) {
                    entity.a((Item)item, slot);
                }
            }, force);
        }
    }

    public ItemStack a(int amount, IMaterial item, EntityLiving entity, EnumItemSlot slot) {
        this.a(amount, entity, slot);
        if (this.f()) {
            ItemStack itemStack = this.b(item, 1);
            if (itemStack.m()) {
                itemStack.b(0);
            }
            return itemStack;
        }
        return this;
    }

    public boolean s() {
        return this.h().d(this);
    }

    public int t() {
        return this.h().e(this);
    }

    public int u() {
        return this.h().f(this);
    }

    public boolean a(Slot slot, ClickAction action, EntityHuman player) {
        return this.h().a(this, slot, action, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction action, EntityHuman player, SlotAccess access) {
        return this.h().a(this, stack, slot, action, player, access);
    }

    public boolean a(EntityLiving enemy, EntityLiving attacker) {
        Item item = this.h();
        item.a(this, enemy, attacker);
        if (this.c(DataComponents.E)) {
            if (attacker instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)attacker;
                player.b(StatisticList.c.b(item));
            }
            return true;
        }
        return false;
    }

    public void b(EntityLiving enemy, EntityLiving attacker) {
        this.h().b(this, enemy, attacker);
        Weapon weapon = this.a(DataComponents.E);
        if (weapon != null) {
            this.a(weapon.a(), attacker, EnumItemSlot.a);
        }
    }

    public void a(World level, IBlockData state, BlockPosition pos, EntityHuman player) {
        Item item = this.h();
        if (item.a(this, level, state, pos, (EntityLiving)player)) {
            player.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.h().b(this, state);
    }

    public EnumInteractionResult a(EntityHuman player, EntityLiving entity, EnumHand usedHand) {
        EnumInteractionResult interactionResult;
        Equippable equippable = this.a(DataComponents.H);
        if (equippable != null && equippable.j() && (interactionResult = equippable.a(player, entity, this)) != EnumInteractionResult.e) {
            return interactionResult;
        }
        return this.h().a(this, player, entity, usedHand);
    }

    public ItemStack v() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.f()) {
            return l;
        }
        ItemStack itemStack = new ItemStack(originalItem ? this.t : this.h(), this.r, this.u.h());
        itemStack.d(this.M());
        return itemStack;
    }

    public ItemStack c(int count) {
        if (this.f()) {
            return l;
        }
        ItemStack itemStack = this.v();
        itemStack.e(count);
        return itemStack;
    }

    public ItemStack a(IMaterial item) {
        return this.a(item, this.N());
    }

    public ItemStack a(IMaterial item, int count) {
        return this.f() ? l : this.b(item, count);
    }

    private ItemStack b(IMaterial item, int count) {
        return new ItemStack(item.h().e(), count, this.u.g());
    }

    public static boolean a(ItemStack stack, ItemStack other) {
        return stack == other || stack.N() == other.N() && ItemStack.c(stack, other);
    }

    @Deprecated
    public static boolean a(List<ItemStack> list, List<ItemStack> other) {
        if (list.size() != other.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (ItemStack.a(list.get(i2), other.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean b(ItemStack stack, ItemStack other) {
        return stack.a(other.h());
    }

    public static boolean c(ItemStack stack, ItemStack other) {
        return stack.a(other.h()) && (stack.f() && other.f() || Objects.equals(stack.u, other.u));
    }

    public static boolean a(ItemStack stack, ItemStack other, Predicate<DataComponentType<?>> ignoreType) {
        if (stack == other) {
            return true;
        }
        if (stack.N() != other.N()) {
            return false;
        }
        if (!stack.a(other.h())) {
            return false;
        }
        if (stack.f() && other.f()) {
            return true;
        }
        if (stack.u.d() != other.u.d()) {
            return false;
        }
        for (DataComponentType<?> dataComponentType : stack.u.b()) {
            Object object = stack.u.a(dataComponentType);
            Object object1 = other.u.a(dataComponentType);
            if (object == null || object1 == null) {
                return false;
            }
            if (Objects.equals(object, object1) || ignoreType.test(dataComponentType)) continue;
            return false;
        }
        return true;
    }

    public static MapCodec<ItemStack> a(String fieldName) {
        return b.lenientOptionalFieldOf(fieldName).xmap(optional -> optional.orElse(l), itemStack -> itemStack.f() ? Optional.empty() : Optional.of(itemStack));
    }

    public static int b(@Nullable ItemStack stack) {
        if (stack != null) {
            int i2 = 31 + stack.h().hashCode();
            return 31 * i2 + stack.a().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int a(List<ItemStack> list) {
        int i2 = 0;
        for (ItemStack itemStack : list) {
            i2 = i2 * 31 + ItemStack.b(itemStack);
        }
        return i2;
    }

    public String toString() {
        return this.N() + " " + String.valueOf(this.h());
    }

    public void a(World level, net.minecraft.world.entity.Entity entity, @Nullable EnumItemSlot slot) {
        if (this.s > 0) {
            --this.s;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            this.h().a(this, serverLevel, entity, slot);
        }
    }

    public void a(EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.h()), amount);
        this.h().c(this, player);
    }

    public void a(World level) {
        this.h().a(this, level);
    }

    public int a(EntityLiving entity) {
        return this.h().a(this, entity);
    }

    public ItemUseAnimation w() {
        return this.h().b(this);
    }

    public void a(World level, EntityLiving livingEntity, int timeLeft) {
        ItemStack itemStack1;
        ItemStack itemStack = this.v();
        if (this.h().a(this, level, livingEntity, timeLeft) && (itemStack1 = this.a(livingEntity, itemStack)) != this) {
            livingEntity.a(livingEntity.ga(), itemStack1);
        }
    }

    public void a(net.minecraft.world.entity.Entity causer, Holder.c<GameEvent> event) {
        UseEffects useEffects = this.a(DataComponents.g);
        if (useEffects != null && useEffects.b()) {
            causer.c(event);
        }
    }

    public boolean x() {
        return this.h().e_(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.u.b(datacomponentpatch);
    }

    public <T> @Nullable T b(DataComponentType<T> component, @Nullable T value) {
        return this.u.b(component, value);
    }

    public <T> @Nullable T a(TypedDataComponent<T> component) {
        return this.u.a(component);
    }

    public <T> void a(DataComponentType<T> componentType, DataComponentGetter componentGetter) {
        this.b(componentType, componentGetter.a(componentType));
    }

    public <T, U> @Nullable T a(DataComponentType<T> component, T defaultValue, U updateValue, BiFunction<T, U, T> updater) {
        return this.b(component, updater.apply(this.a(component, defaultValue), updateValue));
    }

    public <T> @Nullable T a(DataComponentType<T> component, T defaultValue, UnaryOperator<T> updater) {
        T orDefault = this.a(component, defaultValue);
        return this.b(component, updater.apply(orDefault));
    }

    public <T> @Nullable T e(DataComponentType<? extends T> component) {
        return this.u.e(component);
    }

    public void a(DataComponentPatch components) {
        DataComponentPatch patch = this.u.g();
        this.u.a(components);
        Optional optional = ItemStack.a(this).error();
        if (optional.isPresent()) {
            p.error("Failed to apply component patch '{}' to item: '{}'", (Object)components, (Object)((DataResult.Error)optional.get()).message());
            this.u.b(patch);
        }
    }

    public void b(DataComponentPatch components) {
        this.u.a(components);
    }

    public void b(DataComponentMap components) {
        this.u.a(components);
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.v());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public IChatBaseComponent y() {
        IChatBaseComponent customName = this.z();
        return customName != null ? customName : this.A();
    }

    public @Nullable IChatBaseComponent z() {
        String string;
        IChatBaseComponent component = this.a(DataComponents.h);
        if (component != null) {
            return component;
        }
        WrittenBookContent writtenBookContent = this.a(DataComponents.ac);
        if (writtenBookContent != null && !UtilColor.h(string = writtenBookContent.d().a())) {
            return IChatBaseComponent.b(string);
        }
        return null;
    }

    public IChatBaseComponent A() {
        return this.h().a(this);
    }

    public IChatBaseComponent B() {
        IChatMutableComponent mutableComponent = IChatBaseComponent.i().b(this.y()).a(this.D().a());
        if (this.c(DataComponents.h)) {
            mutableComponent.a(EnumChatFormat.u);
        }
        return mutableComponent;
    }

    public <T extends TooltipProvider> void a(DataComponentType<T> component, Item.b context, TooltipDisplay tooltipDisplay, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag tooltipFlag) {
        TooltipProvider tooltipProvider = (TooltipProvider)this.a(component);
        if (tooltipProvider != null && tooltipDisplay.a(component)) {
            tooltipProvider.a(context, tooltipAdder, tooltipFlag, this.u);
        }
    }

    public List<IChatBaseComponent> a(Item.b tooltipContext, @Nullable EntityHuman player, TooltipFlag tooltipFlag) {
        TooltipDisplay tooltipDisplay = this.a(DataComponents.t, TooltipDisplay.c);
        if (!tooltipFlag.b() && tooltipDisplay.a()) {
            boolean shouldPrintOpWarning = this.h().a(this, player);
            return shouldPrintOpWarning ? m : List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.B());
        this.a(tooltipContext, tooltipDisplay, player, tooltipFlag, list::add);
        return list;
    }

    public void a(Item.b context, TooltipDisplay tooltipDisplay, @Nullable EntityHuman player, TooltipFlag tooltipFlag, Consumer<IChatBaseComponent> tooltipAdder) {
        boolean shouldPrintOpWarning;
        AdventureModePredicate adventureModePredicate1;
        AdventureModePredicate adventureModePredicate;
        this.h().a(this, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aJ, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ai, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.T, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ay, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aA, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aw, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.at, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.av, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ac, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.W, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aq, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ap, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.Y, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.al, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ad, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.Q, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.o, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.R, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ar, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.m, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(tooltipAdder, tooltipDisplay, player);
        this.a(DataComponents.x, o, tooltipDisplay, tooltipAdder);
        this.a(DataComponents.f, n, tooltipDisplay, tooltipAdder);
        this.a(DataComponents.ak, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.aa, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.ax, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        this.a(DataComponents.af, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if ((this.a(Items.fr) || this.a(Items.Bx)) && tooltipDisplay.a(DataComponents.ah)) {
            TypedEntityData<TileEntityTypes<?>> typedEntityData = this.a(DataComponents.ah);
            Spawner.a(typedEntityData, tooltipAdder, "SpawnData");
        }
        if ((adventureModePredicate = this.a(DataComponents.q)) != null && tooltipDisplay.a(DataComponents.q)) {
            tooltipAdder.accept(CommonComponents.a);
            tooltipAdder.accept(AdventureModePredicate.c);
            adventureModePredicate.a(tooltipAdder);
        }
        if ((adventureModePredicate1 = this.a(DataComponents.p)) != null && tooltipDisplay.a(DataComponents.p)) {
            tooltipAdder.accept(CommonComponents.a);
            tooltipAdder.accept(AdventureModePredicate.d);
            adventureModePredicate1.a(tooltipAdder);
        }
        if (tooltipFlag.a()) {
            if (this.n() && tooltipDisplay.a(DataComponents.e)) {
                tooltipAdder.accept(IChatBaseComponent.a("item.durability", this.p() - this.o(), this.p()));
            }
            tooltipAdder.accept(IChatBaseComponent.b(BuiltInRegistries.h.b(this.h()).toString()).a(EnumChatFormat.i));
            int size = this.u.d();
            if (size > 0) {
                tooltipAdder.accept(IChatBaseComponent.a("item.components", size).a(EnumChatFormat.i));
            }
        }
        if (player != null && !this.h().a(player.ao().Q())) {
            tooltipAdder.accept(q);
        }
        if (shouldPrintOpWarning = this.h().a(this, player)) {
            m.forEach(tooltipAdder);
        }
    }

    private void a(DataComponentType<?> type, IChatBaseComponent message, TooltipDisplay tooltipDisplay, Consumer<IChatBaseComponent> tooltipAdder) {
        if (this.c(type) && tooltipDisplay.a(type)) {
            tooltipAdder.accept(message);
        }
    }

    private void a(Consumer<IChatBaseComponent> tooltipAdder, TooltipDisplay tooltipDisplay, @Nullable EntityHuman player) {
        if (tooltipDisplay.a(DataComponents.r)) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableBoolean = new MutableBoolean(true);
                this.a(equipmentSlotGroup, (TriConsumer<Holder<AttributeBase>, AttributeModifier, ItemAttributeModifiers.b>)((TriConsumer)(holder, attributeModifier, display) -> {
                    if (display != ItemAttributeModifiers.b.b()) {
                        if (mutableBoolean.isTrue()) {
                            tooltipAdder.accept(CommonComponents.a);
                            tooltipAdder.accept(IChatBaseComponent.c("item.modifiers." + equipmentSlotGroup.c()).a(EnumChatFormat.h));
                            mutableBoolean.setFalse();
                        }
                        display.a(tooltipAdder, player, (Holder<AttributeBase>)holder, (AttributeModifier)attributeModifier);
                    }
                }));
            }
        }
    }

    public boolean C() {
        Boolean _boolean = this.a(DataComponents.w);
        return _boolean != null ? _boolean.booleanValue() : this.h().d_(this);
    }

    public EnumItemRarity D() {
        EnumItemRarity rarity = this.a(DataComponents.n, EnumItemRarity.a);
        if (!this.F()) {
            return rarity;
        }
        return switch (rarity) {
            case EnumItemRarity.a, EnumItemRarity.b -> EnumItemRarity.c;
            case EnumItemRarity.c -> EnumItemRarity.d;
            default -> rarity;
        };
    }

    public boolean E() {
        if (!this.c(DataComponents.G)) {
            return false;
        }
        ItemEnchantments itemEnchantments = this.a(DataComponents.o);
        return itemEnchantments != null && itemEnchantments.d();
    }

    public void a(Holder<Enchantment> enchantment, int level) {
        EnchantmentManager.a(this, (ItemEnchantments.a mutable) -> mutable.b(enchantment, level));
    }

    public boolean F() {
        return !this.a(DataComponents.o, ItemEnchantments.a).d();
    }

    public ItemEnchantments G() {
        return this.a(DataComponents.o, ItemEnchantments.a);
    }

    public boolean H() {
        return this.v instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity) {
        if (!this.f()) {
            this.v = entity;
        }
    }

    public @Nullable EntityItemFrame I() {
        return this.v instanceof EntityItemFrame ? (EntityItemFrame)this.J() : null;
    }

    public @Nullable net.minecraft.world.entity.Entity J() {
        return !this.f() ? this.v : null;
    }

    public void a(EquipmentSlotGroup slot, TriConsumer<Holder<AttributeBase>, AttributeModifier, ItemAttributeModifiers.b> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.r, ItemAttributeModifiers.a);
        itemAttributeModifiers.a(slot, action);
        EnchantmentManager.a(this, slot, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> action.accept(holder, attributeModifier, (Object)ItemAttributeModifiers.b.a()));
    }

    public void a(EnumItemSlot slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        ItemAttributeModifiers itemAttributeModifiers = this.a(DataComponents.r, ItemAttributeModifiers.a);
        itemAttributeModifiers.a(slot, action);
        EnchantmentManager.a(this, slot, action);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.t = item;
        DataComponentPatch patch = this.d();
        this.u = new PatchedDataComponentMap(this.t.f());
        this.b(patch);
    }

    public IChatBaseComponent K() {
        IChatMutableComponent mutableComponent = IChatBaseComponent.i().b(this.y());
        if (this.c(DataComponents.h)) {
            mutableComponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent mutableComponent1 = ChatComponentUtils.a(mutableComponent);
        if (!this.f()) {
            mutableComponent1.a(this.D().a()).a(style -> style.a(new ChatHoverable.d(this)));
        }
        return mutableComponent1;
    }

    public SwingAnimation L() {
        return this.a(DataComponents.P, SwingAnimation.a);
    }

    public boolean a(ShapeDetectorBlock block) {
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.p);
        return adventureModePredicate != null && adventureModePredicate.a(block);
    }

    public boolean b(ShapeDetectorBlock block) {
        AdventureModePredicate adventureModePredicate = this.a(DataComponents.q);
        return adventureModePredicate != null && adventureModePredicate.a(block);
    }

    public int M() {
        return this.s;
    }

    public void d(int popTime) {
        this.s = popTime;
    }

    public int N() {
        return this.f() ? 0 : this.r;
    }

    public void e(int count) {
        this.r = count;
    }

    public void f(int maxSize) {
        if (!this.f() && this.N() > maxSize) {
            this.e(maxSize);
        }
    }

    public void g(int increment) {
        this.e(this.N() + increment);
    }

    public void h(int decrement) {
        this.g(-decrement);
    }

    public void a(int amount, @Nullable EntityLiving entity) {
        if (!(entity != null && entity.gv() || this == l)) {
            this.h(amount);
        }
    }

    public ItemStack b(int amount, @Nullable EntityLiving entity) {
        ItemStack itemStack = this.c(amount);
        this.a(amount, entity);
        return itemStack;
    }

    public void b(World level, EntityLiving livingEntity, int remainingUseDuration) {
        KineticWeapon kineticWeapon;
        Consumable consumable = this.a(DataComponents.z);
        if (consumable != null && consumable.a(remainingUseDuration)) {
            consumable.a(livingEntity.ep(), livingEntity, this, 5);
        }
        if ((kineticWeapon = this.a(DataComponents.O)) != null && !level.B_()) {
            kineticWeapon.a(this, remainingUseDuration, livingEntity, livingEntity.ga().a());
        } else {
            this.h().a(level, livingEntity, this, remainingUseDuration);
        }
    }

    public void a(EntityItem itemEntity) {
        this.h().a(itemEntity);
    }

    public boolean a(DamageSource damageSource) {
        DamageResistant damageResistant = this.a(DataComponents.C);
        return damageResistant == null || !damageResistant.a(damageSource);
    }

    public boolean c(ItemStack item) {
        Repairable repairable = this.a(DataComponents.I);
        return repairable != null && repairable.a(item);
    }

    public boolean a(IBlockData state, World level, BlockPosition pos, EntityHuman player) {
        return this.h().a(this, state, level, pos, (EntityLiving)player);
    }

    public DamageSource a(EntityLiving attacker, Supplier<DamageSource> fallback) {
        return Optional.ofNullable(this.a(DataComponents.j)).flatMap(eitherHolder -> eitherHolder.a(attacker.eo())).map(holder -> new DamageSource((Holder<DamageType>)holder, attacker)).or(() -> Optional.ofNullable(this.h().a(attacker))).orElseGet(fallback);
    }
}

