/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.arrow.EntityThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;

public class ItemTrident
extends Item
implements ProjectileItem {
    public static final int a = 10;
    public static final float b = 8.0f;
    public static final float c = 2.5f;

    public ItemTrident(Item.Info properties) {
        super(properties);
    }

    public static ItemAttributeModifiers b() {
        return ItemAttributeModifiers.a().a(GenericAttributes.d, new AttributeModifier(Item.h, 8.0, AttributeModifier.Operation.a), EquipmentSlotGroup.b).a(GenericAttributes.f, new AttributeModifier(Item.i, -2.9f, AttributeModifier.Operation.a), EquipmentSlotGroup.b).a();
    }

    public static Tool c() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public ItemUseAnimation b(ItemStack stack) {
        return ItemUseAnimation.f;
    }

    @Override
    public int a(ItemStack stack, EntityLiving entity) {
        return 72000;
    }

    @Override
    public boolean a(ItemStack stack, World level, EntityLiving entity, int timeLeft) {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            int i2 = this.a(stack, entity) - timeLeft;
            if (i2 < 10) {
                return false;
            }
            float tridentSpinAttackStrength = EnchantmentManager.a(stack, (EntityLiving)player);
            if (tridentSpinAttackStrength > 0.0f && !player.bA()) {
                return false;
            }
            if (stack.r()) {
                return false;
            }
            Holder<SoundEffect> holder = EnchantmentManager.b(stack, EnchantmentEffectComponents.D).orElse(SoundEffects.CY);
            player.b(StatisticList.c.b(this));
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (tridentSpinAttackStrength == 0.0f) {
                    ItemStack itemStack = stack.c(1);
                    IProjectile.Delayed<EntityThrownTrident> tridentDelayed = IProjectile.spawnProjectileFromRotationDelayed(EntityThrownTrident::new, serverLevel, itemStack, player, 0.0f, 2.5f, 1.0f);
                    PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(stack), (Projectile)tridentDelayed.projectile().getBukkitEntity());
                    if (!event.callEvent() || !tridentDelayed.attemptSpawn()) {
                        return false;
                    }
                    EntityThrownTrident thrownTrident = tridentDelayed.projectile();
                    if (event.shouldConsume()) {
                        itemStack.a(1, player);
                    }
                    thrownTrident.aQ = itemStack.v();
                    if (event.shouldConsume()) {
                        stack.a(1, (EntityLiving)player);
                    }
                    if (player.gv()) {
                        thrownTrident.c = EntityArrow.PickupStatus.c;
                    }
                    level.a(null, thrownTrident, holder.a(), SoundCategory.h, 1.0f, 1.0f);
                    return true;
                }
                stack.a(1, player);
            }
            if (tridentSpinAttackStrength > 0.0f) {
                float squareRoot;
                float yRot = player.ec();
                float xRot = player.ee();
                float f2 = -MathHelper.a((double)(yRot * ((float)Math.PI / 180))) * MathHelper.b((double)(xRot * ((float)Math.PI / 180)));
                float f1 = -MathHelper.a((double)(xRot * ((float)Math.PI / 180)));
                float f22 = MathHelper.b((double)(yRot * ((float)Math.PI / 180))) * MathHelper.b((double)(xRot * ((float)Math.PI / 180)));
                if (!CraftEventFactory.callPlayerRiptideEvent(player, stack, f2 *= tridentSpinAttackStrength / (squareRoot = MathHelper.a(f2 * f2 + f1 * f1 + f22 * f22)), f1 *= tridentSpinAttackStrength / squareRoot, f22 *= tridentSpinAttackStrength / squareRoot)) {
                    return false;
                }
                player.i(f2, f1, f22);
                player.a(20, 8.0f, stack);
                if (player.aV()) {
                    float f3 = 1.1999999f;
                    player.a(EnumMoveType.a, new Vec3D(0.0, 1.1999999284744263, 0.0));
                }
                level.a(null, player, holder.a(), SoundCategory.h, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult a(World level, EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.r()) {
            return EnumInteractionResult.d;
        }
        if (EnchantmentManager.a(itemInHand, (EntityLiving)player) > 0.0f && !player.bA()) {
            return EnumInteractionResult.d;
        }
        player.c(hand);
        return EnumInteractionResult.c;
    }

    @Override
    public IProjectile a(World level, IPosition pos, ItemStack stack, EnumDirection direction) {
        EntityThrownTrident thrownTrident = new EntityThrownTrident(level, pos.a(), pos.b(), pos.c(), stack.c(1));
        thrownTrident.c = EntityArrow.PickupStatus.b;
        return thrownTrident;
    }
}

