/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.jspecify.annotations.Nullable;

public class ItemWorldMap
extends Item {
    public static final int a = 128;
    public static final int b = 128;

    public ItemWorldMap(Item.Info properties) {
        super(properties);
    }

    public static ItemStack a(WorldServer level, int x2, int z2, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemStack = new ItemStack(Items.tY);
        MapId mapId = ItemWorldMap.a(level, x2, z2, scale, trackingPosition, unlimitedTracking, level.aq());
        itemStack.b(DataComponents.T, mapId);
        return itemStack;
    }

    public static @Nullable WorldMap a(@Nullable MapId mapId, World level) {
        return mapId == null ? null : level.a(mapId);
    }

    public static @Nullable WorldMap b(ItemStack stack, World level) {
        MapId mapId = stack.a(DataComponents.T);
        return ItemWorldMap.a(mapId, level);
    }

    public static MapId a(WorldServer level, int x2, int z2, int scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<World> dimension) {
        WorldMap mapItemSavedData = WorldMap.a(x2, z2, (byte)scale, trackingPosition, unlimitedTracking, dimension);
        MapId freeMapId = level.B();
        level.a(freeMapId, mapItemSavedData);
        return freeMapId;
    }

    public void a(World level, Entity viewer, WorldMap data) {
        if (level.aq() == data.f && viewer instanceof EntityHuman) {
            int i2 = 1 << data.g;
            int i1 = data.d;
            int i22 = data.e;
            int i3 = MathHelper.c(viewer.dP() - (double)i1) / i2 + 64;
            int i4 = MathHelper.c(viewer.dV() - (double)i22) / i2 + 64;
            int i5 = 128 / i2;
            if (level.F_().f()) {
                i5 /= 2;
            }
            WorldMap.WorldMapHumanTracker holdingPlayer = data.a((EntityHuman)viewer);
            ++holdingPlayer.b;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
            boolean flag = false;
            for (int i6 = i3 - i5 + 1; i6 < i3 + i5; ++i6) {
                if ((i6 & 0xF) != (holdingPlayer.b & 0xF) && !flag) continue;
                flag = false;
                double d2 = 0.0;
                for (int i7 = i4 - i5 - 1; i7 < i4 + i5; ++i7) {
                    double d22;
                    if (i6 < 0 || i7 < -1 || i6 >= 128 || i7 >= 128) continue;
                    int i8 = MathHelper.i(i6 - i3) + MathHelper.i(i7 - i4);
                    boolean flag1 = i8 > (i5 - 2) * (i5 - 2);
                    int i9 = (i1 / i2 + i6 - 64) * i2;
                    int i10 = (i22 / i2 + i7 - 64) * i2;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    Chunk chunk = level.getChunkIfLoaded(SectionPosition.a(i9), SectionPosition.a(i10));
                    if (chunk == null || chunk.F()) continue;
                    int i11 = 0;
                    double d1 = 0.0;
                    if (level.F_().f()) {
                        i12 = i9 + i10 * 231871;
                        if (((i12 = i12 * i12 * 31287121 + i12 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.j.m().a((IBlockAccess)level, BlockPosition.c), 10);
                        } else {
                            multiset.add((Object)Blocks.b.m().a((IBlockAccess)level, BlockPosition.c), 100);
                        }
                        d1 = 100.0;
                    } else {
                        for (i12 = 0; i12 < i2; ++i12) {
                            for (int i13 = 0; i13 < i2; ++i13) {
                                IBlockData blockState;
                                mutableBlockPos.d(i9 + i12, 0, i10 + i13);
                                int i14 = chunk.a(HeightMap.Type.b, mutableBlockPos.u(), mutableBlockPos.w()) + 1;
                                if (i14 <= level.K_()) {
                                    blockState = Blocks.I.m();
                                } else {
                                    do {
                                        mutableBlockPos.q(--i14);
                                    } while ((blockState = chunk.a_(mutableBlockPos)).a((IBlockAccess)level, (BlockPosition)mutableBlockPos) == MaterialMapColor.a && i14 > level.K_());
                                    if (i14 > level.K_() && !blockState.y().c()) {
                                        IBlockData blockState1;
                                        int i15 = i14 - 1;
                                        mutableBlockPos1.g(mutableBlockPos);
                                        do {
                                            mutableBlockPos1.q(i15--);
                                            blockState1 = chunk.a_(mutableBlockPos1);
                                            ++i11;
                                        } while (i15 > level.K_() && !blockState1.y().c());
                                        blockState = this.a(level, blockState, mutableBlockPos);
                                    }
                                }
                                data.a(level, mutableBlockPos.u(), mutableBlockPos.w());
                                d1 += (double)i14 / (double)(i2 * i2);
                                multiset.add((Object)blockState.a((IBlockAccess)level, (BlockPosition)mutableBlockPos));
                            }
                        }
                    }
                    MaterialMapColor mapColor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.a);
                    MaterialMapColor.a brightness = mapColor == MaterialMapColor.m ? ((d22 = (double)(i11 /= i2 * i2) * 0.1 + (double)(i6 + i7 & 1) * 0.2) < 0.5 ? MaterialMapColor.a.c : (d22 > 0.9 ? MaterialMapColor.a.a : MaterialMapColor.a.b)) : ((d22 = (d1 - d2) * 4.0 / (double)(i2 + 4) + ((double)(i6 + i7 & 1) - 0.5) * 0.4) > 0.6 ? MaterialMapColor.a.c : (d22 < -0.6 ? MaterialMapColor.a.a : MaterialMapColor.a.b));
                    d2 = d1;
                    if (i7 < 0 || i8 >= i5 * i5 || flag1 && (i6 + i7 & 1) == 0) continue;
                    flag |= data.a(i6, i7, mapColor.b(brightness));
                }
            }
        }
    }

    private IBlockData a(World level, IBlockData state, BlockPosition pos) {
        Fluid fluidState = state.y();
        return !fluidState.c() && !state.c((IBlockAccess)level, pos, EnumDirection.b) ? fluidState.g() : state;
    }

    private static boolean a(boolean[] wateryMap, int xSample, int zSample) {
        return wateryMap[zSample * 128 + xSample];
    }

    public static void a(WorldServer level, ItemStack stack) {
        WorldMap savedData = ItemWorldMap.b(stack, (World)level);
        if (savedData != null && level.aq() == savedData.f) {
            int i6;
            int i5;
            int i2 = 1 << savedData.g;
            int i1 = savedData.d;
            int i22 = savedData.e;
            boolean[] flags = new boolean[16384];
            int i3 = i1 / i2 - 64;
            int i4 = i22 / i2 - 64;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (i5 = 0; i5 < 128; ++i5) {
                for (i6 = 0; i6 < 128; ++i6) {
                    Holder<BiomeBase> biome = level.a(QuartPos.a((i3 + i6) * i2), QuartPos.a(0), QuartPos.a((i4 + i5) * i2));
                    flags[i5 * 128 + i6] = biome.a(BiomeTags.Z);
                }
            }
            for (i5 = 1; i5 < 127; ++i5) {
                for (i6 = 1; i6 < 127; ++i6) {
                    int i7 = 0;
                    for (int i8 = -1; i8 < 2; ++i8) {
                        for (int i9 = -1; i9 < 2; ++i9) {
                            if (i8 == 0 && i9 == 0 || !ItemWorldMap.a(flags, i5 + i8, i6 + i9)) continue;
                            ++i7;
                        }
                    }
                    MaterialMapColor.a brightness = MaterialMapColor.a.d;
                    MaterialMapColor mapColor = MaterialMapColor.a;
                    if (ItemWorldMap.a(flags, i5, i6)) {
                        mapColor = MaterialMapColor.p;
                        if (i7 > 7 && i6 % 2 == 0) {
                            switch ((i5 + (int)(MathHelper.a((double)((float)i6 + 0.0f)) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    brightness = MaterialMapColor.a.a;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    brightness = MaterialMapColor.a.b;
                                    break;
                                }
                                case 2: {
                                    brightness = MaterialMapColor.a.c;
                                }
                            }
                        } else if (i7 > 7) {
                            mapColor = MaterialMapColor.a;
                        } else if (i7 > 5) {
                            brightness = MaterialMapColor.a.b;
                        } else if (i7 > 3) {
                            brightness = MaterialMapColor.a.a;
                        } else if (i7 > 1) {
                            brightness = MaterialMapColor.a.a;
                        }
                    } else if (i7 > 0) {
                        mapColor = MaterialMapColor.A;
                        brightness = i7 > 3 ? MaterialMapColor.a.b : MaterialMapColor.a.d;
                    }
                    if (mapColor == MaterialMapColor.a) continue;
                    savedData.b(i5, i6, mapColor.b(brightness));
                }
            }
        }
    }

    @Override
    public void a(ItemStack stack, WorldServer level, Entity entity, @Nullable EnumItemSlot slot) {
        WorldMap savedData = ItemWorldMap.b(stack, (World)level);
        if (savedData != null) {
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                savedData.a(player, stack);
            }
            if (!savedData.i && slot != null && slot.a() == EnumItemSlot.Function.a) {
                this.a((World)level, entity, savedData);
            }
        }
    }

    @Override
    public void a(ItemStack stack, World level) {
        MapPostProcessing mapPostProcessing = stack.e(DataComponents.V);
        if (mapPostProcessing != null && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            switch (mapPostProcessing) {
                case a: {
                    ItemWorldMap.b(stack, serverLevel);
                    break;
                }
                case b: {
                    ItemWorldMap.a(stack, serverLevel);
                }
            }
        }
    }

    private static void a(ItemStack stack, WorldServer level) {
        WorldMap savedData = ItemWorldMap.b(stack, (World)level);
        if (savedData != null) {
            MapId freeMapId = level.B();
            level.a(freeMapId, savedData.c());
            stack.b(DataComponents.T, freeMapId);
        }
    }

    private static void b(ItemStack stack, WorldServer level) {
        WorldMap savedData = ItemWorldMap.b(stack, (World)level);
        if (savedData != null) {
            MapId freeMapId = level.B();
            WorldMap mapItemSavedData = savedData.b();
            level.a(freeMapId, mapItemSavedData);
            stack.b(DataComponents.T, freeMapId);
        }
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        IBlockData blockState = context.q().a_(context.a());
        if (blockState.a(TagsBlock.aw)) {
            WorldMap savedData;
            if (!context.q().B_() && (savedData = ItemWorldMap.b(context.n(), context.q())) != null && !savedData.a((GeneratorAccess)context.q(), context.a())) {
                return EnumInteractionResult.d;
            }
            return EnumInteractionResult.a;
        }
        return super.a(context);
    }
}

