/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class AttackRange
extends Record {
    private final float c;
    private final float d;
    private final float e;
    private final float f;
    private final float g;
    private final float h;
    public static final AttackRange CODEC_DEFAULT = new AttackRange(0.0f, 3.0f, 0.0f, 5.0f, 0.3f, 1.0f);
    public static final Codec<AttackRange> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("min_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::a), (App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("max_reach", (Object)Float.valueOf(3.0f)).forGetter(AttackRange::b), (App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("min_creative_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::c), (App)ExtraCodecs.a(0.0f, 64.0f).optionalFieldOf("max_creative_reach", (Object)Float.valueOf(5.0f)).forGetter(AttackRange::d), (App)ExtraCodecs.a(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(AttackRange::e), (App)Codec.floatRange((float)0.0f, (float)2.0f).optionalFieldOf("mob_factor", (Object)Float.valueOf(1.0f)).forGetter(AttackRange::f)).apply((Applicative)instance, AttackRange::new));
    public static final StreamCodec<ByteBuf, AttackRange> b = StreamCodec.a(ByteBufCodecs.l, AttackRange::a, ByteBufCodecs.l, AttackRange::b, ByteBufCodecs.l, AttackRange::c, ByteBufCodecs.l, AttackRange::d, ByteBufCodecs.l, AttackRange::e, ByteBufCodecs.l, AttackRange::f, AttackRange::new);

    public AttackRange(float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin, float mobFactor) {
        this.c = minRange;
        this.d = maxRange;
        this.e = minCreativeRange;
        this.f = maxCreativeRange;
        this.g = hitboxMargin;
        this.h = mobFactor;
    }

    public static AttackRange a(EntityLiving livingEntity) {
        return new AttackRange(0.0f, (float)livingEntity.i(GenericAttributes.l), 0.0f, (float)livingEntity.i(GenericAttributes.l), 0.0f, 1.0f);
    }

    public MovingObjectPosition a(Entity attacker, float partialTick, Predicate<Entity> filter) {
        Either<MovingObjectPositionBlock, Collection<MovingObjectPositionEntity>> hitEntitiesAlong = ProjectileHelper.a(attacker, this, filter, RayTrace.BlockCollisionOption.b);
        if (hitEntitiesAlong.left().isPresent()) {
            return hitEntitiesAlong.left().get();
        }
        Collection<MovingObjectPositionEntity> collection = hitEntitiesAlong.right().get();
        MovingObjectPositionEntity entityHitResult = null;
        Vec3D eyePosition = attacker.n(partialTick);
        double d2 = Double.MAX_VALUE;
        for (MovingObjectPositionEntity entityHitResult1 : collection) {
            double d1 = eyePosition.g(entityHitResult1.g());
            if (!(d1 < d2)) continue;
            d2 = d1;
            entityHitResult = entityHitResult1;
        }
        if (entityHitResult != null) {
            return entityHitResult;
        }
        Vec3D headLookAngle = attacker.ck();
        Vec3D vec3 = attacker.n(partialTick).e(headLookAngle);
        return MovingObjectPositionBlock.a(vec3, EnumDirection.a(headLookAngle), BlockPosition.a(vec3));
    }

    public float a(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (player.au()) {
                return 0.0f;
            }
            return player.ha() ? this.e : this.c;
        }
        return this.c * this.h;
    }

    public float b(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            return player.ha() ? this.f : this.d;
        }
        return this.d * this.h;
    }

    public boolean a(EntityLiving attacker, Vec3D location) {
        return this.a(attacker, location::g, 0.0);
    }

    public boolean a(EntityLiving attacker, AxisAlignedBB boundingBox, double extraBuffer) {
        return this.a(attacker, boundingBox::e, extraBuffer);
    }

    private boolean a(EntityLiving attacker, ToDoubleFunction<Vec3D> distanceFunction, double extraBuffer) {
        double squareRoot = Math.sqrt(distanceFunction.applyAsDouble(attacker.bV()));
        double d2 = (double)(this.a(attacker) - this.g) - extraBuffer;
        double d1 = (double)(this.b(attacker) + this.g) + extraBuffer;
        return squareRoot >= d2 && squareRoot <= d1;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{AttackRange.class, "minRange;maxRange;minCreativeRange;maxCreativeRange;hitboxMargin;mobFactor", "c", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AttackRange.class, "minRange;maxRange;minCreativeRange;maxCreativeRange;hitboxMargin;mobFactor", "c", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AttackRange.class, "minRange;maxRange;minCreativeRange;maxCreativeRange;hitboxMargin;mobFactor", "c", "d", "e", "f", "g", "h"}, this, o2);
    }

    public float a() {
        return this.c;
    }

    public float b() {
        return this.d;
    }

    public float c() {
        return this.e;
    }

    public float d() {
        return this.f;
    }

    public float e() {
        return this.g;
    }

    public float f() {
        return this.h;
    }
}

