/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.apache.commons.lang3.math.Fraction;
import org.jspecify.annotations.Nullable;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents a = new BundleContents(List.of());
    public static final Codec<BundleContents> b = ItemStack.b.listOf().flatXmap(BundleContents::a, bundleContents -> DataResult.success(bundleContents.g));
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> c = ItemStack.j.a(ByteBufCodecs.a()).a(ByteBufCodecs::increaseDepth).a(BundleContents::new, contents -> contents.g);
    private static final Fraction e = Fraction.getFraction((int)1, (int)16);
    private static final int f = -1;
    public static final int d = -1;
    final List<ItemStack> g;
    final Fraction h;
    final int i;

    BundleContents(List<ItemStack> items, Fraction weight, int selectedItem) {
        this.g = items;
        this.h = weight;
        this.i = selectedItem;
    }

    private static DataResult<BundleContents> a(List<ItemStack> items) {
        try {
            Fraction fraction = BundleContents.b(items);
            return DataResult.success((Object)new BundleContents(items, fraction, -1));
        }
        catch (ArithmeticException var2) {
            return DataResult.error(() -> "Excessive total bundle weight");
        }
    }

    public BundleContents(List<ItemStack> items) {
        this(items, BundleContents.b(items), -1);
    }

    private static Fraction b(List<ItemStack> content) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemStack : content) {
            fraction = fraction.add(BundleContents.b(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.N(), (int)1)));
        }
        return fraction;
    }

    static Fraction b(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.X);
        if (bundleContents != null) {
            return e.add(bundleContents.f());
        }
        List<TileEntityBeehive.c> list = stack.a(DataComponents.ay, Bees.c).a();
        return !list.isEmpty() ? Fraction.ONE : Fraction.getFraction((int)1, (int)stack.k());
    }

    public static boolean a(ItemStack stack) {
        return !stack.f() && stack.h().d();
    }

    public int getMaxAmountToAdd(ItemStack stack) {
        return net.minecraft.world.item.component.BundleContents$a.getMaxAmountToAdd(stack, this.h);
    }

    public int a() {
        int size = this.e();
        int i2 = size > 12 ? 11 : 12;
        int i1 = size % 4;
        int i22 = i1 == 0 ? 0 : 4 - i1;
        return Math.min(size, i2 - i22);
    }

    public ItemStack a(int index) {
        return this.g.get(index);
    }

    public Stream<ItemStack> b() {
        return this.g.stream().map(ItemStack::v);
    }

    public Iterable<ItemStack> c() {
        return this.g;
    }

    public Iterable<ItemStack> d() {
        return Lists.transform(this.g, ItemStack::v);
    }

    public int e() {
        return this.g.size();
    }

    public Fraction f() {
        return this.h;
    }

    public boolean g() {
        return this.g.isEmpty();
    }

    public int h() {
        return this.i;
    }

    public boolean i() {
        return this.i != -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof BundleContents)) return false;
        BundleContents bundleContents = (BundleContents)other;
        if (!this.h.equals((Object)bundleContents.h)) return false;
        if (!ItemStack.a(this.g, bundleContents.g)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.a(this.g);
    }

    public String toString() {
        return "BundleContents" + String.valueOf(this.g);
    }

    public static class a {
        private final List<ItemStack> a;
        private Fraction b;
        private int c;

        public a(BundleContents contents) {
            this.a = new ArrayList<ItemStack>(contents.g);
            this.b = contents.h;
            this.c = contents.i;
        }

        public a a() {
            this.a.clear();
            this.b = Fraction.ZERO;
            this.c = -1;
            return this;
        }

        private int b(ItemStack stack) {
            if (!stack.l()) {
                return -1;
            }
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                if (!ItemStack.c(this.a.get(i2), stack)) continue;
                return i2;
            }
            return -1;
        }

        public int c(ItemStack stack) {
            return net.minecraft.world.item.component.BundleContents$a.getMaxAmountToAdd(stack, this.b);
        }

        static int getMaxAmountToAdd(ItemStack stack, Fraction weight) {
            Fraction fraction = Fraction.ONE.subtract(weight);
            return Math.max(fraction.divideBy(BundleContents.b(stack)).intValue(), 0);
        }

        public int a(ItemStack stack) {
            if (!BundleContents.a(stack)) {
                return 0;
            }
            int min = Math.min(stack.N(), this.c(stack));
            if (min == 0) {
                return 0;
            }
            this.b = this.b.add(BundleContents.b(stack).multiplyBy(Fraction.getFraction((int)min, (int)1)));
            int i2 = this.b(stack);
            if (i2 != -1) {
                ItemStack itemStack = this.a.remove(i2);
                ItemStack itemStack1 = itemStack.c(itemStack.N() + min);
                stack.h(min);
                this.a.add(0, itemStack1);
            } else {
                this.a.add(0, stack.a(min));
            }
            return min;
        }

        public int a(Slot slot, EntityHuman player) {
            ItemStack item = slot.g();
            int maxAmountToAdd = this.c(item);
            return BundleContents.a(item) ? this.a(slot.b(item.N(), maxAmountToAdd, player)) : 0;
        }

        public void a(int selectedItem) {
            this.c = this.c != selectedItem && !this.b(selectedItem) ? selectedItem : -1;
        }

        private boolean b(int index) {
            return index < 0 || index >= this.a.size();
        }

        public @Nullable ItemStack b() {
            if (this.a.isEmpty()) {
                return null;
            }
            int i2 = this.b(this.c) ? 0 : this.c;
            ItemStack itemStack = this.a.remove(i2).v();
            this.b = this.b.subtract(BundleContents.b(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.N(), (int)1)));
            this.a(-1);
            return itemStack;
        }

        public Fraction c() {
            return this.b;
        }

        public BundleContents d() {
            return new BundleContents(List.copyOf(this.a), this.b, this.c);
        }
    }
}

