/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;

public final class ChargedProjectiles
implements TooltipProvider {
    public static final ChargedProjectiles a = new ChargedProjectiles(List.of());
    public static final Codec<ChargedProjectiles> b = ItemStack.b.listOf().xmap(ChargedProjectiles::new, chargedProjectiles -> chargedProjectiles.d);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChargedProjectiles> c = ItemStack.j.a(ByteBufCodecs.a()).a(ByteBufCodecs::increaseDepth).a(ChargedProjectiles::new, chargedProjectiles -> chargedProjectiles.d);
    private final List<ItemStack> d;

    private ChargedProjectiles(List<ItemStack> items) {
        this.d = items;
    }

    public static ChargedProjectiles a(ItemStack stack) {
        return new ChargedProjectiles(List.of(stack.v()));
    }

    public static ChargedProjectiles a(List<ItemStack> stack) {
        return new ChargedProjectiles(List.copyOf(Lists.transform(stack, ItemStack::v)));
    }

    public boolean a(Item item) {
        for (ItemStack itemStack : this.d) {
            if (!itemStack.a(item)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> a() {
        return Lists.transform(this.d, ItemStack::v);
    }

    public boolean b() {
        return this.d.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ChargedProjectiles)) return false;
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)other;
        if (!ItemStack.a(this.d, chargedProjectiles.d)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.a(this.d);
    }

    public String toString() {
        return "ChargedProjectiles[items=" + String.valueOf(this.d) + "]";
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        ItemStack itemStack = null;
        int i2 = 0;
        for (ItemStack itemStack1 : this.d) {
            if (itemStack == null) {
                itemStack = itemStack1;
                i2 = 1;
                continue;
            }
            if (ItemStack.a(itemStack, itemStack1)) {
                ++i2;
                continue;
            }
            ChargedProjectiles.a(context, tooltipAdder, itemStack, i2);
            itemStack = itemStack1;
            i2 = 1;
        }
        if (itemStack != null) {
            ChargedProjectiles.a(context, tooltipAdder, itemStack, i2);
        }
    }

    private static void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, ItemStack stack, int count) {
        if (count == 1) {
            tooltipAdder.accept(IChatBaseComponent.a("item.minecraft.crossbow.projectile.single", stack.K()));
        } else {
            tooltipAdder.accept(IChatBaseComponent.a("item.minecraft.crossbow.projectile.multiple", count, stack.K()));
        }
        TooltipDisplay tooltipDisplay = stack.a(DataComponents.t, TooltipDisplay.c);
        stack.a(context, tooltipDisplay, null, TooltipFlag.a, component -> tooltipAdder.accept(IChatBaseComponent.b("  ").b((IChatBaseComponent)component).a(EnumChatFormat.h)));
    }
}

