/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class Consumable
extends Record {
    private final float d;
    private final ItemUseAnimation e;
    private final Holder<SoundEffect> f;
    private final boolean g;
    private final List<ConsumeEffect> h;
    public static final float a = 1.6f;
    private static final int i = 4;
    private static final float j = 0.21875f;
    public static final Codec<Consumable> b = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.u.optionalFieldOf("consume_seconds", (Object)Float.valueOf(1.6f)).forGetter(Consumable::c), (App)ItemUseAnimation.m.optionalFieldOf("animation", (Object)ItemUseAnimation.b).forGetter(Consumable::d), (App)SoundEffect.b.optionalFieldOf("sound", SoundEffects.lR).forGetter(Consumable::e), (App)Codec.BOOL.optionalFieldOf("has_consume_particles", (Object)true).forGetter(Consumable::f), (App)ConsumeEffect.d.listOf().optionalFieldOf("on_consume_effects", List.of()).forGetter(Consumable::g)).apply((Applicative)instance, Consumable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Consumable> c = StreamCodec.a(ByteBufCodecs.l, Consumable::c, ItemUseAnimation.n, Consumable::d, SoundEffect.d, Consumable::e, ByteBufCodecs.b, Consumable::f, ConsumeEffect.e.a(ByteBufCodecs.a()), Consumable::g, Consumable::new);

    public Consumable(float consumeSeconds, ItemUseAnimation animation, Holder<SoundEffect> sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
        this.d = consumeSeconds;
        this.e = animation;
        this.f = sound;
        this.g = hasConsumeParticles;
        this.h = onConsumeEffects;
    }

    public EnumInteractionResult a(EntityLiving entity, ItemStack stack, EnumHand hand) {
        boolean flag;
        if (!this.a(entity, stack)) {
            return EnumInteractionResult.d;
        }
        boolean bl = flag = this.a() > 0;
        if (flag) {
            entity.c(hand);
            return EnumInteractionResult.c;
        }
        ItemStack itemStack = this.a(entity.ao(), entity, stack);
        return EnumInteractionResult.c.a(itemStack);
    }

    public ItemStack a(World level, EntityLiving entity, ItemStack stack) {
        RandomSource random = entity.ep();
        this.a(random, entity, stack, 16);
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.b(StatisticList.c.b(stack.h()));
            CriterionTriggers.A.a(serverPlayer, stack);
        }
        stack.a(ConsumableListener.class).forEach(consumableListener -> consumableListener.a(level, entity, stack, this));
        if (!level.B_()) {
            EntityPotionEffectEvent.Cause cause = stack.a(Items.sq) ? EntityPotionEffectEvent.Cause.MILK : (stack.a(Items.up) ? EntityPotionEffectEvent.Cause.POTION_DRINK : EntityPotionEffectEvent.Cause.FOOD);
            this.h.forEach(consumeEffect -> consumeEffect.apply(level, stack, entity, cause));
        }
        entity.c(this.e == ItemUseAnimation.c ? GameEvent.l : GameEvent.m);
        stack.a(1, entity);
        return stack;
    }

    public void cancelUsingItem(EntityPlayer player, ItemStack stack) {
        ObjectArrayList packets = new ObjectArrayList();
        stack.a(ConsumableListener.class).forEach(arg_0 -> Consumable.lambda$cancelUsingItem$3(player, stack, (List)packets, arg_0));
        player.A().s().aj().sendActiveEffects(player, ((List)packets)::add);
        player.g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)packets));
    }

    public boolean a(EntityLiving entity, ItemStack stack) {
        EntityHuman player;
        FoodInfo foodProperties = stack.a(DataComponents.y);
        return foodProperties == null || !(entity instanceof EntityHuman) || (player = (EntityHuman)entity).u(foodProperties.c());
    }

    public int a() {
        return (int)(this.d * 20.0f);
    }

    public void a(RandomSource random, EntityLiving entity, ItemStack stack, int amount) {
        SoundEffect soundEffect;
        float f5;
        float f2 = random.h() ? 0.5f : 1.0f;
        float f1 = random.a(1.0f, 0.2f);
        float f22 = 0.5f;
        float f3 = MathHelper.b(random, 0.9f, 1.0f);
        float f4 = this.e == ItemUseAnimation.c ? 0.5f : f2;
        float f6 = f5 = this.e == ItemUseAnimation.c ? f3 : f1;
        if (this.g) {
            entity.b(stack, amount);
        }
        if (entity instanceof b) {
            b overrideConsumeSound = (b)((Object)entity);
            soundEffect = overrideConsumeSound.j(stack);
        } else {
            soundEffect = this.f.a();
        }
        SoundEffect soundEvent = soundEffect;
        entity.a(soundEvent, f4, f5);
    }

    public boolean a(int remainingUseDuration) {
        int i1;
        int i2 = this.a() - remainingUseDuration;
        boolean flag = i2 > (i1 = (int)((float)this.a() * 0.21875f));
        return flag && remainingUseDuration % 4 == 0;
    }

    public static a b() {
        return new a();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Consumable.class, "consumeSeconds;animation;sound;hasConsumeParticles;onConsumeEffects", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Consumable.class, "consumeSeconds;animation;sound;hasConsumeParticles;onConsumeEffects", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Consumable.class, "consumeSeconds;animation;sound;hasConsumeParticles;onConsumeEffects", "d", "e", "f", "g", "h"}, this, o2);
    }

    public float c() {
        return this.d;
    }

    public ItemUseAnimation d() {
        return this.e;
    }

    public Holder<SoundEffect> e() {
        return this.f;
    }

    public boolean f() {
        return this.g;
    }

    public List<ConsumeEffect> g() {
        return this.h;
    }

    private static /* synthetic */ void lambda$cancelUsingItem$3(EntityPlayer player, ItemStack stack, List packets, ConsumableListener listener) {
        listener.cancelUsingItem(player, stack, packets);
    }

    public static interface b {
        public SoundEffect j(ItemStack var1);
    }

    public static class a {
        private float a = 1.6f;
        private ItemUseAnimation b = ItemUseAnimation.b;
        private Holder<SoundEffect> c = SoundEffects.lR;
        private boolean d = true;
        private final List<ConsumeEffect> e = new ArrayList<ConsumeEffect>();

        a() {
        }

        public a a(float consumeSeconds) {
            this.a = consumeSeconds;
            return this;
        }

        public a a(ItemUseAnimation animation) {
            this.b = animation;
            return this;
        }

        public a a(Holder<SoundEffect> sound) {
            this.c = sound;
            return this;
        }

        public a b(Holder<SoundEffect> consumptionSound) {
            return this.a(new PlaySoundConsumeEffect(consumptionSound));
        }

        public a a(boolean hasConsumeParticles) {
            this.d = hasConsumeParticles;
            return this;
        }

        public a a(ConsumeEffect effect) {
            this.e.add(effect);
            return this;
        }

        public Consumable a() {
            return new Consumable(this.a, this.b, this.c, this.d, this.e);
        }
    }
}

