/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriConsumer;
import org.jspecify.annotations.Nullable;

public final class ItemAttributeModifiers
extends Record {
    private final List<c> e;
    public static final ItemAttributeModifiers a = new ItemAttributeModifiers(List.of());
    public static final Codec<ItemAttributeModifiers> b = net.minecraft.world.item.component.ItemAttributeModifiers$c.a.listOf().xmap(ItemAttributeModifiers::new, ItemAttributeModifiers::b);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> c = StreamCodec.a(net.minecraft.world.item.component.ItemAttributeModifiers$c.b.a(ByteBufCodecs.a()), ItemAttributeModifiers::b, ItemAttributeModifiers::new);
    public static final DecimalFormat d = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public ItemAttributeModifiers(List<c> modifiers) {
        this.e = modifiers;
    }

    public static a a() {
        return new a();
    }

    public ItemAttributeModifiers a(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.e.size() + 1));
        for (c entry : this.e) {
            if (entry.a(attribute, modifier.a())) continue;
            builder.add((Object)entry);
        }
        builder.add((Object)new c(attribute, modifier, slot));
        return new ItemAttributeModifiers((List<c>)builder.build());
    }

    public void a(EquipmentSlotGroup slot, TriConsumer<Holder<AttributeBase>, AttributeModifier, b> action) {
        for (c entry : this.e) {
            if (!entry.e.equals(slot)) continue;
            action.accept(entry.c, (Object)entry.d, (Object)entry.f);
        }
    }

    public void a(EquipmentSlotGroup slotGroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        for (c entry : this.e) {
            if (!entry.e.equals(slotGroup)) continue;
            action.accept(entry.c, entry.d);
        }
    }

    public void a(EnumItemSlot slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> action) {
        for (c entry : this.e) {
            if (!entry.e.b(slot)) continue;
            action.accept(entry.c, entry.d);
        }
    }

    public double a(Holder<AttributeBase> attribute, double baseValue, EnumItemSlot slot) {
        double d2 = baseValue;
        for (c entry : this.e) {
            if (!entry.e.b(slot) || entry.c != attribute) continue;
            double amount = entry.d.b();
            d2 += (switch (entry.d.c()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.a -> amount;
                case AttributeModifier.Operation.b -> amount * baseValue;
                case AttributeModifier.Operation.c -> amount * d2;
            });
        }
        return d2;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemAttributeModifiers.class, "modifiers", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemAttributeModifiers.class, "modifiers", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemAttributeModifiers.class, "modifiers", "e"}, this, o2);
    }

    public List<c> b() {
        return this.e;
    }

    public static class a {
        private final ImmutableList.Builder<c> a = ImmutableList.builder();

        a() {
        }

        public a a(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
            this.a.add((Object)new c(attribute, modifier, slot));
            return this;
        }

        public a a(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot, b display) {
            this.a.add((Object)new c(attribute, modifier, slot, display));
            return this;
        }

        public ItemAttributeModifiers a() {
            return new ItemAttributeModifiers((List<c>)this.a.build());
        }
    }

    public static final class c
    extends Record {
        private final Holder<AttributeBase> c;
        private final AttributeModifier d;
        private final EquipmentSlotGroup e;
        private final b f;
        public static final Codec<c> a = RecordCodecBuilder.create(instance -> instance.group((App)AttributeBase.a.fieldOf("type").forGetter(c::a), (App)AttributeModifier.a.forGetter(c::b), (App)EquipmentSlotGroup.m.optionalFieldOf("slot", (Object)EquipmentSlotGroup.a).forGetter(c::c), (App)net.minecraft.world.item.component.ItemAttributeModifiers$b.a.optionalFieldOf("display", (Object)b.a.c).forGetter(c::d)).apply((Applicative)instance, c::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, c> b = StreamCodec.a(AttributeBase.b, c::a, AttributeModifier.c, c::b, EquipmentSlotGroup.n, c::c, net.minecraft.world.item.component.ItemAttributeModifiers$b.b, c::d, c::new);

        public c(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
            this(attribute, modifier, slot, net.minecraft.world.item.component.ItemAttributeModifiers$b.a());
        }

        public c(Holder<AttributeBase> attribute, AttributeModifier modifier, EquipmentSlotGroup slot, b display) {
            this.c = attribute;
            this.d = modifier;
            this.e = slot;
            this.f = display;
        }

        public boolean a(Holder<AttributeBase> attribute, MinecraftKey id) {
            return attribute.equals(this.c) && this.d.a(id);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "attribute;modifier;slot;display", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "attribute;modifier;slot;display", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "attribute;modifier;slot;display", "c", "d", "e", "f"}, this, o2);
        }

        public Holder<AttributeBase> a() {
            return this.c;
        }

        public AttributeModifier b() {
            return this.d;
        }

        public EquipmentSlotGroup c() {
            return this.e;
        }

        public b d() {
            return this.f;
        }
    }

    public static interface net.minecraft.world.item.component.ItemAttributeModifiers$b {
        public static final Codec<net.minecraft.world.item.component.ItemAttributeModifiers$b> a = d.d.dispatch("type", net.minecraft.world.item.component.ItemAttributeModifiers$b::c, type -> type.i);
        public static final StreamCodec<RegistryFriendlyByteBuf, net.minecraft.world.item.component.ItemAttributeModifiers$b> b = d.f.a().b(net.minecraft.world.item.component.ItemAttributeModifiers$b::c, d::b);

        public static net.minecraft.world.item.component.ItemAttributeModifiers$b a() {
            return a.c;
        }

        public static net.minecraft.world.item.component.ItemAttributeModifiers$b b() {
            return b.c;
        }

        public static net.minecraft.world.item.component.ItemAttributeModifiers$b a(IChatBaseComponent component) {
            return new c(component);
        }

        public d c();

        public void a(Consumer<IChatBaseComponent> var1, @Nullable EntityHuman var2, Holder<AttributeBase> var3, AttributeModifier var4);

        public record a() implements net.minecraft.world.item.component.ItemAttributeModifiers$b
        {
            static final a c = new a();
            static final MapCodec<a> d = MapCodec.unit((Object)c);
            static final StreamCodec<RegistryFriendlyByteBuf, a> e = StreamCodec.a(c);

            @Override
            public d c() {
                return net.minecraft.world.item.component.ItemAttributeModifiers$b$d.a;
            }

            @Override
            public void a(Consumer<IChatBaseComponent> output, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
                double amount = modifier.b();
                boolean flag = false;
                if (player != null) {
                    if (modifier.a(Item.h)) {
                        amount += player.j(GenericAttributes.d);
                        flag = true;
                    } else if (modifier.a(Item.i)) {
                        amount += player.j(GenericAttributes.f);
                        flag = true;
                    }
                }
                double d2 = modifier.c() == AttributeModifier.Operation.b || modifier.c() == AttributeModifier.Operation.c ? amount * 100.0 : (attribute.a(GenericAttributes.r) ? amount * 10.0 : amount);
                if (flag) {
                    output.accept(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + modifier.c().a(), new Object[]{d.format(d2), IChatBaseComponent.c(attribute.a().c())})).a(EnumChatFormat.c));
                } else if (amount > 0.0) {
                    output.accept(IChatBaseComponent.a("attribute.modifier.plus." + modifier.c().a(), new Object[]{d.format(d2), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(true)));
                } else if (amount < 0.0) {
                    output.accept(IChatBaseComponent.a("attribute.modifier.take." + modifier.c().a(), new Object[]{d.format(-d2), IChatBaseComponent.c(attribute.a().c())}).a(attribute.a().b(false)));
                }
            }
        }

        public record b() implements net.minecraft.world.item.component.ItemAttributeModifiers$b
        {
            static final b c = new b();
            static final MapCodec<b> d = MapCodec.unit((Object)c);
            static final StreamCodec<RegistryFriendlyByteBuf, b> e = StreamCodec.a(c);

            @Override
            public d c() {
                return net.minecraft.world.item.component.ItemAttributeModifiers$b$d.b;
            }

            @Override
            public void a(Consumer<IChatBaseComponent> output, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
            }
        }

        public record c(IChatBaseComponent c) implements net.minecraft.world.item.component.ItemAttributeModifiers$b
        {
            private final IChatBaseComponent c;
            static final MapCodec<c> d = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.a.fieldOf("value").forGetter(c::d)).apply((Applicative)instance, c::new));
            static final StreamCodec<RegistryFriendlyByteBuf, c> e = StreamCodec.a(ComponentSerialization.b, c::d, c::new);

            @Override
            public d c() {
                return net.minecraft.world.item.component.ItemAttributeModifiers$b$d.c;
            }

            @Override
            public void a(Consumer<IChatBaseComponent> output, @Nullable EntityHuman player, Holder<AttributeBase> attribute, AttributeModifier modifier) {
                output.accept(this.c);
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "component", "c"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "component", "c"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "component", "c"}, this, o2);
            }

            public IChatBaseComponent d() {
                return this.c;
            }
        }

        public static final class d
        extends Enum<d>
        implements INamable {
            public static final /* enum */ d a = new d("default", 0, net.minecraft.world.item.component.ItemAttributeModifiers$b$a.d, net.minecraft.world.item.component.ItemAttributeModifiers$b$a.e);
            public static final /* enum */ d b = new d("hidden", 1, net.minecraft.world.item.component.ItemAttributeModifiers$b$b.d, net.minecraft.world.item.component.ItemAttributeModifiers$b$b.e);
            public static final /* enum */ d c = new d("override", 2, net.minecraft.world.item.component.ItemAttributeModifiers$b$c.d, net.minecraft.world.item.component.ItemAttributeModifiers$b$c.e);
            static final Codec<d> d;
            private static final IntFunction<d> e;
            static final StreamCodec<ByteBuf, d> f;
            private final String g;
            private final int h;
            final MapCodec<? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> i;
            private final StreamCodec<RegistryFriendlyByteBuf, ? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> j;
            private static final /* synthetic */ d[] k;

            public static d[] values() {
                return (d[])k.clone();
            }

            public static d valueOf(String name) {
                return Enum.valueOf(d.class, name);
            }

            private d(String name, int id, MapCodec<? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> codec, StreamCodec<RegistryFriendlyByteBuf, ? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> streamCodec) {
                this.g = name;
                this.h = id;
                this.i = codec;
                this.j = streamCodec;
            }

            @Override
            public String c() {
                return this.g;
            }

            private int a() {
                return this.h;
            }

            private StreamCodec<RegistryFriendlyByteBuf, ? extends net.minecraft.world.item.component.ItemAttributeModifiers$b> b() {
                return this.j;
            }

            private static /* synthetic */ d[] d() {
                return new d[]{a, b, c};
            }

            static {
                k = net.minecraft.world.item.component.ItemAttributeModifiers$b$d.d();
                d = INamable.a(d::values);
                e = ByIdMap.a(d::a, net.minecraft.world.item.component.ItemAttributeModifiers$b$d.values(), ByIdMap.a.a);
                f = ByteBufCodecs.a(e, d::a);
            }
        }
    }
}

