/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class KineticWeapon
extends Record {
    private final int d;
    private final int e;
    private final Optional<a> f;
    private final Optional<a> g;
    private final Optional<a> h;
    private final float i;
    private final float j;
    private final Optional<Holder<SoundEffect>> k;
    private final Optional<Holder<SoundEffect>> l;
    public static final int a = 10;
    public static final Codec<KineticWeapon> b = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.q.optionalFieldOf("contact_cooldown_ticks", (Object)10).forGetter(KineticWeapon::b), (App)ExtraCodecs.q.optionalFieldOf("delay_ticks", (Object)0).forGetter(KineticWeapon::c), (App)net.minecraft.world.item.component.KineticWeapon$a.a.optionalFieldOf("dismount_conditions").forGetter(KineticWeapon::d), (App)net.minecraft.world.item.component.KineticWeapon$a.a.optionalFieldOf("knockback_conditions").forGetter(KineticWeapon::e), (App)net.minecraft.world.item.component.KineticWeapon$a.a.optionalFieldOf("damage_conditions").forGetter(KineticWeapon::f), (App)Codec.FLOAT.optionalFieldOf("forward_movement", (Object)Float.valueOf(0.0f)).forGetter(KineticWeapon::g), (App)Codec.FLOAT.optionalFieldOf("damage_multiplier", (Object)Float.valueOf(1.0f)).forGetter(KineticWeapon::h), (App)SoundEffect.b.optionalFieldOf("sound").forGetter(KineticWeapon::i), (App)SoundEffect.b.optionalFieldOf("hit_sound").forGetter(KineticWeapon::j)).apply((Applicative)instance, KineticWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KineticWeapon> c = StreamCodec.a(ByteBufCodecs.h, KineticWeapon::b, ByteBufCodecs.h, KineticWeapon::c, net.minecraft.world.item.component.KineticWeapon$a.b.a(ByteBufCodecs::a), KineticWeapon::d, net.minecraft.world.item.component.KineticWeapon$a.b.a(ByteBufCodecs::a), KineticWeapon::e, net.minecraft.world.item.component.KineticWeapon$a.b.a(ByteBufCodecs::a), KineticWeapon::f, ByteBufCodecs.l, KineticWeapon::g, ByteBufCodecs.l, KineticWeapon::h, SoundEffect.d.a(ByteBufCodecs::a), KineticWeapon::i, SoundEffect.d.a(ByteBufCodecs::a), KineticWeapon::j, KineticWeapon::new);

    public KineticWeapon(int contactCooldownTicks, int delayTicks, Optional<a> dismountConditions, Optional<a> knockbackConditions, Optional<a> damageConditions, float forwardMovement, float damageMultiplier, Optional<Holder<SoundEffect>> sound, Optional<Holder<SoundEffect>> hitSound) {
        this.d = contactCooldownTicks;
        this.e = delayTicks;
        this.f = dismountConditions;
        this.g = knockbackConditions;
        this.h = damageConditions;
        this.i = forwardMovement;
        this.j = damageMultiplier;
        this.k = sound;
        this.l = hitSound;
    }

    public static Vec3D a(Entity entity) {
        if (!(entity instanceof EntityHuman) && entity.cq()) {
            entity = entity.du();
        }
        return entity.ah().c(20.0);
    }

    public void b(Entity entity) {
        this.k.ifPresent(holder -> entity.ao().a(entity, entity.dP(), entity.dR(), entity.dV(), (Holder<SoundEffect>)holder, entity.dB(), 1.0f, 1.0f));
    }

    public void c(Entity entity) {
        this.l.ifPresent(holder -> entity.ao().a(entity, (SoundEffect)holder.a(), entity.dB(), 1.0f, 1.0f));
    }

    public int a() {
        return this.e + this.h.map(a::a).orElse(0);
    }

    public void a(ItemStack stack, int remainingUseDuration, EntityLiving entity, EnumItemSlot slot) {
        int i2 = stack.a(entity) - remainingUseDuration;
        if (i2 >= this.e) {
            i2 -= this.e;
            Vec3D lookAngle = entity.cj();
            double d2 = lookAngle.b(KineticWeapon.a(entity));
            float f2 = entity instanceof EntityHuman ? 1.0f : 0.2f;
            AttackRange attackRange = entity.fz();
            double attributeBaseValue = entity.j(GenericAttributes.d);
            boolean flag = false;
            for (MovingObjectPositionEntity entityHitResult : ProjectileHelper.a((Entity)entity, attackRange, entity2 -> PiercingWeapon.a((Entity)entity, entity2), RayTrace.BlockCollisionOption.a).map(blockHitResult -> List.of(), collection -> collection)) {
                boolean flag4;
                boolean flag1;
                Entity entity1 = entityHitResult.a();
                if (entity1 instanceof EntityComplexPart) {
                    EntityComplexPart enderDragonPart = (EntityComplexPart)entity1;
                    entity1 = enderDragonPart.a;
                }
                if (flag1 = entity.b(entity1, this.d)) continue;
                entity.E(entity1);
                double d1 = lookAngle.b(KineticWeapon.a(entity1));
                double max = Math.max(0.0, d2 - d1);
                boolean flag2 = this.f.isPresent() && this.f.get().a(i2, d2, max, f2);
                boolean flag3 = this.g.isPresent() && this.g.get().a(i2, d2, max, f2);
                boolean bl = flag4 = this.h.isPresent() && this.h.get().a(i2, d2, max, f2);
                if (!flag2 && !flag3 && !flag4) continue;
                float f1 = (float)attributeBaseValue + (float)MathHelper.c(max * (double)this.j);
                flag |= entity.a(slot, entity1, f1, flag4, flag3, flag2);
            }
            if (flag) {
                entity.ao().a((Entity)entity, (byte)2);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    CriterionTriggers.H.a(serverPlayer, entity.c((Entity entity2) -> entity2 instanceof EntityLiving));
                }
            }
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{KineticWeapon.class, "contactCooldownTicks;delayTicks;dismountConditions;knockbackConditions;damageConditions;forwardMovement;damageMultiplier;sound;hitSound", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{KineticWeapon.class, "contactCooldownTicks;delayTicks;dismountConditions;knockbackConditions;damageConditions;forwardMovement;damageMultiplier;sound;hitSound", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{KineticWeapon.class, "contactCooldownTicks;delayTicks;dismountConditions;knockbackConditions;damageConditions;forwardMovement;damageMultiplier;sound;hitSound", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this, o2);
    }

    public int b() {
        return this.d;
    }

    public int c() {
        return this.e;
    }

    public Optional<a> d() {
        return this.f;
    }

    public Optional<a> e() {
        return this.g;
    }

    public Optional<a> f() {
        return this.h;
    }

    public float g() {
        return this.i;
    }

    public float h() {
        return this.j;
    }

    public Optional<Holder<SoundEffect>> i() {
        return this.k;
    }

    public Optional<Holder<SoundEffect>> j() {
        return this.l;
    }

    public static final class a
    extends Record {
        private final int c;
        private final float d;
        private final float e;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.q.fieldOf("max_duration_ticks").forGetter(a::a), (App)Codec.FLOAT.optionalFieldOf("min_speed", (Object)Float.valueOf(0.0f)).forGetter(a::b), (App)Codec.FLOAT.optionalFieldOf("min_relative_speed", (Object)Float.valueOf(0.0f)).forGetter(a::c)).apply((Applicative)instance, a::new));
        public static final StreamCodec<ByteBuf, a> b = StreamCodec.a(ByteBufCodecs.h, a::a, ByteBufCodecs.l, a::b, ByteBufCodecs.l, a::c, a::new);

        public a(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
            this.c = maxDurationTicks;
            this.d = minSpeed;
            this.e = minRelativeSpeed;
        }

        public boolean a(int durationTicks, double speed, double relativeSpeed, double speedMultiplier) {
            return durationTicks <= this.c && speed >= (double)this.d * speedMultiplier && relativeSpeed >= (double)this.e * speedMultiplier;
        }

        public static Optional<a> a(int maxDurationTicks, float minSpeed) {
            return Optional.of(new a(maxDurationTicks, minSpeed, 0.0f));
        }

        public static Optional<a> b(int maxDurationTicks, float minRelativeSpeed) {
            return Optional.of(new a(maxDurationTicks, 0.0f, minRelativeSpeed));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "maxDurationTicks;minSpeed;minRelativeSpeed", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "maxDurationTicks;minSpeed;minRelativeSpeed", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "maxDurationTicks;minSpeed;minRelativeSpeed", "c", "d", "e"}, this, o2);
        }

        public int a() {
            return this.c;
        }

        public float b() {
            return this.d;
        }

        public float c() {
            return this.e;
        }
    }
}

