/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public final class PiercingWeapon
extends Record {
    private final boolean c;
    private final boolean d;
    private final Optional<Holder<SoundEffect>> e;
    private final Optional<Holder<SoundEffect>> f;
    public static final Codec<PiercingWeapon> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::a), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::b), (App)SoundEffect.b.optionalFieldOf("sound").forGetter(PiercingWeapon::c), (App)SoundEffect.b.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::d)).apply((Applicative)instance, PiercingWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PiercingWeapon> b = StreamCodec.a(ByteBufCodecs.b, PiercingWeapon::a, ByteBufCodecs.b, PiercingWeapon::b, SoundEffect.d.a(ByteBufCodecs::a), PiercingWeapon::c, SoundEffect.d.a(ByteBufCodecs::a), PiercingWeapon::d, PiercingWeapon::new);

    public PiercingWeapon(boolean dealsKnockback, boolean dismounts, Optional<Holder<SoundEffect>> sound, Optional<Holder<SoundEffect>> hitSound) {
        this.c = dealsKnockback;
        this.d = dismounts;
        this.e = sound;
        this.f = hitSound;
    }

    public void a(Entity entity) {
        this.e.ifPresent(holder -> entity.ao().a(entity, entity.dP(), entity.dR(), entity.dV(), (Holder<SoundEffect>)holder, entity.dB(), 1.0f, 1.0f));
    }

    public void b(Entity entity) {
        this.f.ifPresent(holder -> entity.ao().a(null, entity.dP(), entity.dR(), entity.dV(), (Holder<SoundEffect>)holder, entity.dB(), 1.0f, 1.0f));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean a(Entity entity, Entity target) {
        if (target.cU()) return false;
        if (!target.cb()) return false;
        if (target instanceof Interaction) return true;
        if (!target.bW()) return false;
        if (target instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)target;
            if (entity instanceof EntityHuman) {
                EntityHuman player1 = (EntityHuman)entity;
                if (!player1.a(player)) return false;
            }
        }
        if (entity.A(target)) return false;
        return true;
    }

    public void a(EntityLiving entity, EnumItemSlot slot) {
        float f2 = (float)entity.i(GenericAttributes.d);
        AttackRange attackRange = entity.fz();
        boolean flag = false;
        for (MovingObjectPositionEntity entityHitResult : ProjectileHelper.a((Entity)entity, attackRange, entity1 -> PiercingWeapon.a((Entity)entity, entity1), RayTrace.BlockCollisionOption.a).map(blockHitResult -> List.of(), collection -> collection)) {
            flag |= entity.a(slot, entityHitResult.a(), f2, true, this.c, this.d);
        }
        entity.fO();
        entity.fi();
        if (flag) {
            this.b(entity);
        }
        this.a(entity);
        entity.a(EnumHand.a, false);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PiercingWeapon.class, "dealsKnockback;dismounts;sound;hitSound", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PiercingWeapon.class, "dealsKnockback;dismounts;sound;hitSound", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PiercingWeapon.class, "dealsKnockback;dismounts;sound;hitSound", "c", "d", "e", "f"}, this, o2);
    }

    public boolean a() {
        return this.c;
    }

    public boolean b() {
        return this.d;
    }

    public Optional<Holder<SoundEffect>> c() {
        return this.e;
    }

    public Optional<Holder<SoundEffect>> d() {
        return this.f;
    }
}

