/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public final class TypedEntityData<IdType>
implements TooltipProvider {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "id";
    final IdType c;
    final NBTTagCompound d;

    public static <T> Codec<TypedEntityData<T>> a(final Codec<T> idCodec) {
        return new Codec<TypedEntityData<T>>(){

            public <V> DataResult<Pair<TypedEntityData<T>, V>> decode(DynamicOps<V> ops, V input) {
                return CustomData.b.decode(ops, input).flatMap(pair -> {
                    NBTTagCompound compoundTag = ((NBTTagCompound)pair.getFirst()).l();
                    NBTBase tag = compoundTag.r(TypedEntityData.b);
                    return tag == null ? DataResult.error(() -> "Expected 'id' field in " + String.valueOf(input)) : idCodec.parse(1.a(ops), (Object)tag).map(object1 -> Pair.of(new TypedEntityData<Object>(object1, compoundTag), (Object)pair.getSecond()));
                });
            }

            public <V> DataResult<V> a(TypedEntityData<T> input, DynamicOps<V> ops, V prefix) {
                return idCodec.encodeStart(1.a(ops), input.c).flatMap(tag -> {
                    NBTTagCompound compoundTag = input.d.l();
                    compoundTag.a(TypedEntityData.b, (NBTBase)tag);
                    return CustomData.b.encode((Object)compoundTag, ops, prefix);
                });
            }

            private static <T> DynamicOps<NBTBase> a(DynamicOps<T> ops) {
                Object object;
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    object = registryOps.a(DynamicOpsNBT.a);
                } else {
                    object = DynamicOpsNBT.a;
                }
                return object;
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, TypedEntityData<T>> a(StreamCodec<B, T> idCodec) {
        return StreamCodec.a(idCodec, TypedEntityData::a, ByteBufCodecs.s, TypedEntityData::d, TypedEntityData::new);
    }

    TypedEntityData(IdType type, NBTTagCompound tag) {
        this.c = type;
        this.d = TypedEntityData.a(tag);
    }

    public static <IdType> TypedEntityData<IdType> decode(Codec<IdType> idTypeCodec, NBTTagCompound tag) {
        return (TypedEntityData)((Pair)TypedEntityData.a(idTypeCodec).decode((DynamicOps)DynamicOpsNBT.a, (Object)tag).result().orElseThrow()).getFirst();
    }

    public static TypedEntityData<EntityTypes<?>> decodeEntity(NBTTagCompound tag) {
        return TypedEntityData.decode(EntityTypes.a, tag);
    }

    public static TypedEntityData<TileEntityTypes<?>> decodeBlockEntity(NBTTagCompound tag) {
        return TypedEntityData.decode(BuiltInRegistries.k.q(), tag);
    }

    public NBTTagCompound copyTagWithEntityId() {
        NBTTagCompound tag = this.d.l();
        tag.a(b, EntityTypes.a((EntityTypes)this.c).toString());
        return tag;
    }

    public NBTTagCompound copyTagWithBlockEntityId() {
        NBTTagCompound tag = this.d.l();
        tag.a(b, TileEntityTypes.a((TileEntityTypes)this.c).toString());
        return tag;
    }

    public static <T> TypedEntityData<T> a(T type, NBTTagCompound tag) {
        return new TypedEntityData<T>(type, tag);
    }

    private static NBTTagCompound a(NBTTagCompound tag) {
        if (tag.b(b)) {
            NBTTagCompound compoundTag = tag.l();
            compoundTag.r(b);
            return compoundTag;
        }
        return tag;
    }

    public IdType a() {
        return this.c;
    }

    public boolean a(String key) {
        return this.d.b(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof TypedEntityData)) return false;
        TypedEntityData typedEntityData = (TypedEntityData)other;
        if (this.c != typedEntityData.c) return false;
        if (!this.d.equals(typedEntityData.d)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.c.hashCode() + this.d.hashCode();
    }

    public String toString() {
        return String.valueOf(this.c) + " " + String.valueOf(this.d);
    }

    public void a(Entity entity) {
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(entity.es(), a);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, entity.eo());
            entity.d(tagValueOutput);
            NBTTagCompound compoundTag = tagValueOutput.b();
            UUID uuid = entity.cY();
            compoundTag.a(this.b());
            entity.d(TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)entity.eo(), compoundTag));
            entity.a(uuid);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean a(TileEntity blockEntity, HolderLookup.a registries) {
        scopedCollector = new ProblemReporter.j(blockEntity.v(), TypedEntityData.a);
        try {
            tagValueOutput = TagValueOutput.a(scopedCollector, registries);
            blockEntity.f(tagValueOutput);
            compoundTag = tagValueOutput.b();
            compoundTag1 = compoundTag.l();
            compoundTag.a(this.b());
            if (compoundTag.equals(compoundTag1)) ** GOTO lbl23
            try {
                blockEntity.c(TagValueInput.a((ProblemReporter)scopedCollector, registries, compoundTag));
                blockEntity.e();
                var8_9 = true;
                return var8_9;
            }
            catch (Exception var11) {
                TypedEntityData.a.warn("Failed to apply custom data to block entity at {}", (Object)blockEntity.aD_(), (Object)var11);
                try {
                    blockEntity.c(TagValueInput.a(scopedCollector.a((ProblemReporter.f)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/String;, e(), ()Ljava/lang/String;)()), registries, compoundTag1));
                }
                catch (Exception var10) {
                    TypedEntityData.a.warn("Failed to rollback block entity at {} after failure", (Object)blockEntity.aD_(), (Object)var10);
                }
lbl23:
                // 3 sources

                exception = false;
            }
        }
        finally {
            scopedCollector.close();
        }
        return exception;
    }

    private NBTTagCompound d() {
        return this.d;
    }

    @Deprecated
    public NBTTagCompound b() {
        return this.d;
    }

    public NBTTagCompound c() {
        return this.d.l();
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        if (this.c.getClass() == EntityTypes.class) {
            EntityTypes entityType = (EntityTypes)this.c;
            if (context.c() && !entityType.isTypeAllowedInPeaceful()) {
                tooltipAdder.accept(IChatBaseComponent.c("item.spawn_egg.peaceful").a(EnumChatFormat.m));
            }
        }
    }

    private static /* synthetic */ String e() {
        return "(rollback)";
    }
}

