/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BookContent;
import net.minecraft.world.item.component.TooltipProvider;
import org.jspecify.annotations.Nullable;

public final class WrittenBookContent
extends Record
implements BookContent<IChatBaseComponent, WrittenBookContent>,
TooltipProvider {
    private final Filterable<String> k;
    private final String l;
    private final int m;
    private final List<Filterable<IChatBaseComponent>> n;
    private final boolean o;
    public static final WrittenBookContent a = new WrittenBookContent(Filterable.a(""), "", 0, List.of(), true);
    public static final int b = Short.MAX_VALUE;
    public static final int c = 16;
    public static final int d = 32;
    public static final int e = 3;
    public static final int f = 2;
    public static final Codec<IChatBaseComponent> g = ComponentSerialization.a(Short.MAX_VALUE);
    public static final Codec<List<Filterable<IChatBaseComponent>>> h = WrittenBookContent.a(g);
    public static final Codec<WrittenBookContent> i = RecordCodecBuilder.create(instance -> instance.group((App)Filterable.a(Codec.string((int)0, (int)32)).fieldOf("title").forGetter(WrittenBookContent::d), (App)Codec.STRING.fieldOf("author").forGetter(WrittenBookContent::e), (App)ExtraCodecs.a(0, 3).optionalFieldOf("generation", (Object)0).forGetter(WrittenBookContent::f), (App)h.optionalFieldOf("pages", List.of()).forGetter(WrittenBookContent::a), (App)Codec.BOOL.optionalFieldOf("resolved", (Object)false).forGetter(WrittenBookContent::g)).apply((Applicative)instance, WrittenBookContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WrittenBookContent> j = StreamCodec.a(Filterable.a(ByteBufCodecs.b(32)), WrittenBookContent::d, ByteBufCodecs.p, WrittenBookContent::e, ByteBufCodecs.h, WrittenBookContent::f, Filterable.a(ComponentSerialization.b).a(ByteBufCodecs.a()), WrittenBookContent::a, ByteBufCodecs.b, WrittenBookContent::g, WrittenBookContent::new);

    public WrittenBookContent(Filterable<String> title, String author, int generation, List<Filterable<IChatBaseComponent>> pages, boolean resolved) {
        if (generation < 0 || generation > 3) {
            throw new IllegalArgumentException("Generation was " + generation + ", but must be between 0 and 3");
        }
        this.k = title;
        this.l = author;
        this.m = generation;
        this.n = pages;
        this.o = resolved;
    }

    private static Codec<Filterable<IChatBaseComponent>> b(Codec<IChatBaseComponent> codec) {
        return Filterable.a(codec);
    }

    public static Codec<List<Filterable<IChatBaseComponent>>> a(Codec<IChatBaseComponent> codec) {
        return WrittenBookContent.b(codec).listOf();
    }

    public @Nullable WrittenBookContent b() {
        return this.m >= 2 ? null : new WrittenBookContent(this.k, this.l, this.m + 1, this.n, this.o);
    }

    public static boolean a(ItemStack stack, CommandListenerWrapper source, @Nullable EntityHuman player) {
        WrittenBookContent writtenBookContent = stack.a(DataComponents.ac);
        if (GlobalConfiguration.get().itemValidation.resolveSelectorsInBooks && writtenBookContent != null && !writtenBookContent.g()) {
            WrittenBookContent writtenBookContent1 = writtenBookContent.a(source, player);
            if (writtenBookContent1 != null) {
                stack.b(DataComponents.ac, writtenBookContent1);
                return true;
            }
            stack.b(DataComponents.ac, writtenBookContent.c());
        }
        return false;
    }

    public @Nullable WrittenBookContent a(CommandListenerWrapper source, @Nullable EntityHuman player) {
        if (this.o) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.n.size());
        for (Filterable<IChatBaseComponent> filterable : this.n) {
            Optional<Filterable<IChatBaseComponent>> optional = WrittenBookContent.a(source, player, filterable);
            if (optional.isEmpty()) {
                return null;
            }
            builder.add(optional.get());
        }
        return new WrittenBookContent(this.k, this.l, this.m, (List<Filterable<IChatBaseComponent>>)builder.build(), true);
    }

    public WrittenBookContent c() {
        return new WrittenBookContent(this.k, this.l, this.m, this.n, true);
    }

    private static Optional<Filterable<IChatBaseComponent>> a(CommandListenerWrapper source, @Nullable EntityHuman player, Filterable<IChatBaseComponent> pages) {
        return pages.b((T component) -> {
            try {
                IChatMutableComponent component1 = ChatComponentUtils.a(source, component, (Entity)player, 0);
                return WrittenBookContent.a(component1, source.v()) ? Optional.empty() : Optional.of(component1);
            }
            catch (Exception var4) {
                return Optional.of(component);
            }
        });
    }

    private static boolean a(IChatBaseComponent page, HolderLookup.a registryAccess) {
        DataResult dataResult = ComponentSerialization.a.encodeStart(registryAccess.a(JsonOps.INSTANCE), (Object)page);
        return dataResult.isSuccess() && ChatDeserializer.a((JsonElement)dataResult.getOrThrow(), Short.MAX_VALUE);
    }

    public List<IChatBaseComponent> a(boolean filtered) {
        return Lists.transform(this.n, filterable -> (IChatBaseComponent)filterable.a(filtered));
    }

    public WrittenBookContent b(List<Filterable<IChatBaseComponent>> newPages) {
        return new WrittenBookContent(this.k, this.l, this.m, newPages, false);
    }

    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        if (!UtilColor.h(this.l)) {
            tooltipAdder.accept(IChatBaseComponent.a("book.byAuthor", new Object[]{this.l}).a(EnumChatFormat.h));
        }
        tooltipAdder.accept(IChatBaseComponent.c("book.generation." + this.m).a(EnumChatFormat.h));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WrittenBookContent.class, "title;author;generation;pages;resolved", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WrittenBookContent.class, "title;author;generation;pages;resolved", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WrittenBookContent.class, "title;author;generation;pages;resolved", "k", "l", "m", "n", "o"}, this, o2);
    }

    public Filterable<String> d() {
        return this.k;
    }

    public String e() {
        return this.l;
    }

    public int f() {
        return this.m;
    }

    @Override
    public List<Filterable<IChatBaseComponent>> a() {
        return this.n;
    }

    public boolean g() {
        return this.o;
    }
}

