/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.consume_effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class TeleportRandomlyConsumeEffect
extends Record
implements ConsumeEffect {
    private final float c;
    private static final float f = 16.0f;
    public static final MapCodec<TeleportRandomlyConsumeEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.v.optionalFieldOf("diameter", (Object)Float.valueOf(16.0f)).forGetter(TeleportRandomlyConsumeEffect::b)).apply((Applicative)instance, TeleportRandomlyConsumeEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TeleportRandomlyConsumeEffect> b = StreamCodec.a(ByteBufCodecs.l, TeleportRandomlyConsumeEffect::b, TeleportRandomlyConsumeEffect::new);

    public TeleportRandomlyConsumeEffect() {
        this(16.0f);
    }

    public TeleportRandomlyConsumeEffect(float diameter) {
        this.c = diameter;
    }

    public ConsumeEffect.a<TeleportRandomlyConsumeEffect> a() {
        return ConsumeEffect.a.d;
    }

    @Override
    public boolean a(World level, ItemStack stack, EntityLiving entity) {
        boolean flag = false;
        for (int i2 = 0; i2 < 16; ++i2) {
            SoundCategory soundSource;
            SoundEffect soundEvent;
            double d2 = entity.dP() + (entity.ep().j() - 0.5) * (double)this.c;
            double d1 = MathHelper.a(entity.dR() + (entity.ep().j() - 0.5) * (double)this.c, (double)level.K_(), (double)(level.K_() + ((WorldServer)level).o() - 1));
            double d22 = entity.dV() + (entity.ep().j() - 0.5) * (double)this.c;
            if (entity.cq()) {
                entity.cf();
            }
            Vec3D vec3 = entity.dI();
            Optional<Boolean> status = entity.randomTeleport(d2, d1, d22, true, PlayerTeleportEvent.TeleportCause.CONSUMABLE_EFFECT);
            if (status.isEmpty()) break;
            if (!status.get().booleanValue()) continue;
            level.a(GameEvent.R, vec3, GameEvent.a.a(entity));
            if (entity instanceof EntityFox) {
                soundEvent = SoundEffects.ld;
                soundSource = SoundCategory.g;
            } else {
                soundEvent = SoundEffects.fI;
                soundSource = SoundCategory.h;
            }
            level.a(null, entity.dP(), entity.dR(), entity.dV(), soundEvent, soundSource);
            entity.l();
            flag = true;
            break;
        }
        if (flag && entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            player.hr();
        }
        return flag;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TeleportRandomlyConsumeEffect.class, "diameter", "c"}, this, o2);
    }

    public float b() {
        return this.c;
    }
}

