/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import io.papermc.paper.inventory.recipe.ItemOrExact;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements AutoRecipeStackManager.a<ItemOrExact>,
Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeItemStack> a = ByteBufCodecs.c(Registries.R).a(RecipeItemStack::new, ingredient -> ingredient.e);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<RecipeItemStack>> b = ByteBufCodecs.c(Registries.R).a(items -> items.b() == 0 ? Optional.empty() : Optional.of(new RecipeItemStack((HolderSet<Item>)items)), optional -> optional.map(ingredient -> ingredient.e).orElse(HolderSet.a(new Holder[0])));
    public static final Codec<HolderSet<Item>> c = HolderSetCodec.a(Registries.R, Item.e, false);
    public static final Codec<RecipeItemStack> d = ExtraCodecs.c(c).xmap(RecipeItemStack::new, ingredient -> ingredient.e);
    private final HolderSet<Item> e;
    @Nullable
    private Set<ItemStack> itemStacks;

    public boolean isExact() {
        return this.itemStacks != null;
    }

    @Nullable
    public Set<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public static RecipeItemStack ofStacks(List<ItemStack> stacks) {
        RecipeItemStack recipe = RecipeItemStack.a(stacks.stream().map(ItemStack::h));
        recipe.itemStacks = ItemStackLinkedSet.a();
        recipe.itemStacks.addAll(stacks);
        recipe.itemStacks = Collections.unmodifiableSet(recipe.itemStacks);
        return recipe;
    }

    private RecipeItemStack(HolderSet<Item> values) {
        values.d().ifRight(list -> {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (list.contains(Items.a.e())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.e = values;
    }

    public static boolean a(Optional<RecipeItemStack> ingredient, ItemStack stack) {
        return ingredient.map(ingredient1 -> ingredient1.a(stack)).orElseGet(stack::f);
    }

    @Deprecated
    public Stream<Holder<Item>> a() {
        return this.e.a();
    }

    public boolean b() {
        return this.e.b() == 0;
    }

    public boolean a(ItemStack stack) {
        if (this.isExact()) {
            return this.itemStacks.contains(stack);
        }
        return stack.a(this.e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acceptsItem(ItemOrExact itemOrExact) {
        ItemOrExact itemOrExact2 = itemOrExact;
        Objects.requireNonNull(itemOrExact2);
        ItemOrExact itemOrExact3 = itemOrExact2;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemOrExact.Item.class, ItemOrExact.Exact.class}, (Object)itemOrExact3, n2)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ItemOrExact.Item item = (ItemOrExact.Item)itemOrExact3;
                try {
                    Holder<Item> holder;
                    Holder<Item> item2 = holder = item.item();
                    if (this.isExact()) return false;
                    if (!this.e.a(item2)) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        ItemOrExact.Exact exact = (ItemOrExact.Exact)itemOrExact3;
        {
            ItemStack itemStack;
            ItemStack exact2 = itemStack = exact.stack();
            if (!this.isExact()) return false;
            if (!this.itemStacks.contains(exact2)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof RecipeItemStack)) return false;
        RecipeItemStack ingredient = (RecipeItemStack)other;
        if (!Objects.equals(this.e, ingredient.e)) return false;
        if (!Objects.equals(this.itemStacks, ingredient.itemStacks)) return false;
        return true;
    }

    public static RecipeItemStack a(IMaterial item) {
        return new RecipeItemStack(HolderSet.a(item.h().e()));
    }

    public static RecipeItemStack a(IMaterial ... items) {
        return RecipeItemStack.a(Arrays.stream(items));
    }

    public static RecipeItemStack a(Stream<? extends IMaterial> items) {
        return new RecipeItemStack(HolderSet.a(items.map(item -> item.h().e()).toList()));
    }

    public static RecipeItemStack a(HolderSet<Item> items) {
        return new RecipeItemStack(items);
    }

    public SlotDisplay c() {
        if (this.isExact()) {
            return new SlotDisplay.b(this.itemStacks().stream().map(SlotDisplay.f::new).toList());
        }
        return (SlotDisplay)((Object)this.e.d().map(SlotDisplay.h::new, list -> new SlotDisplay.b(list.stream().map(RecipeItemStack::b).toList())));
    }

    public static SlotDisplay a(Optional<RecipeItemStack> ingredient) {
        return ingredient.map(RecipeItemStack::c).orElse(SlotDisplay.c.c);
    }

    private static SlotDisplay b(Holder<Item> item) {
        SlotDisplay.d slotDisplay = new SlotDisplay.d(item);
        ItemStack craftingRemainder = item.a().i();
        if (!craftingRemainder.f()) {
            SlotDisplay.f slotDisplay1 = new SlotDisplay.f(craftingRemainder);
            return new SlotDisplay.j(slotDisplay, slotDisplay1);
        }
        return slotDisplay;
    }
}

