/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;

public class RecipeMap {
    public static final RecipeMap a = new RecipeMap((Multimap<Recipes<?>, RecipeHolder<?>>)ImmutableMultimap.of(), Map.of());
    public final Multimap<Recipes<?>, RecipeHolder<?>> b;
    public final Map<ResourceKey<IRecipe<?>>, RecipeHolder<?>> c;

    private RecipeMap(Multimap<Recipes<?>, RecipeHolder<?>> byType, Map<ResourceKey<IRecipe<?>>, RecipeHolder<?>> byKey) {
        this.b = byType;
        this.c = byKey;
    }

    public static RecipeMap a(Iterable<RecipeHolder<?>> recipes) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        for (RecipeHolder<?> recipeHolder : recipes) {
            builder.put(recipeHolder.b().b(), recipeHolder);
            builder1.put(recipeHolder.a(), recipeHolder);
        }
        return new RecipeMap((Multimap<Recipes<?>, RecipeHolder<?>>)LinkedHashMultimap.create((Multimap)builder.build()), Maps.newLinkedHashMap((Map)builder1.build()));
    }

    public void addRecipe(RecipeHolder<?> holder) {
        Collection recipes = this.b.get(holder.b().b());
        if (this.c.containsKey(holder.a())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(holder.a()));
        }
        recipes.add(holder);
        this.c.put(holder.a(), holder);
    }

    public <T extends RecipeInput> boolean removeRecipe(ResourceKey<IRecipe<T>> mcKey) {
        RecipeHolder<?> remove = this.c.remove(mcKey);
        if (remove == null) {
            return false;
        }
        Collection recipes = this.a(remove.b().b());
        return recipes.remove(remove);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> a(Recipes<T> type) {
        return this.b.get(type);
    }

    public Collection<RecipeHolder<?>> a() {
        return this.c.values();
    }

    public @Nullable RecipeHolder<?> a(ResourceKey<IRecipe<?>> key) {
        return this.c.get(key);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Stream<RecipeHolder<T>> a(Recipes<T> type, I input, World level) {
        return input.b() ? Stream.empty() : this.a(type).stream().filter(recipeHolder -> recipeHolder.b().a((RecipeInput)input, level));
    }
}

