/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class ShapedRecipePattern {
    private static final int d = 3;
    public static final char a = ' ';
    public static final MapCodec<ShapedRecipePattern> b = net.minecraft.world.item.crafting.ShapedRecipePattern$a.a.flatXmap(ShapedRecipePattern::a, pattern -> pattern.h.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> c = StreamCodec.a(ByteBufCodecs.h, (C shapedRecipePattern) -> shapedRecipePattern.e, ByteBufCodecs.h, (C shapedRecipePattern) -> shapedRecipePattern.f, RecipeItemStack.b.a(ByteBufCodecs.a()), (C shapedRecipePattern) -> shapedRecipePattern.g, ShapedRecipePattern::a);
    private final int e;
    private final int f;
    private final List<Optional<RecipeItemStack>> g;
    private final Optional<a> h;
    private final int i;
    private final boolean j;

    public ShapedRecipePattern(int width, int height, List<Optional<RecipeItemStack>> ingredients, Optional<a> data) {
        this.e = width;
        this.f = height;
        this.g = ingredients;
        this.h = data;
        this.i = (int)ingredients.stream().flatMap(Optional::stream).count();
        this.j = SystemUtils.a(width, height, ingredients);
    }

    private static ShapedRecipePattern a(Integer width, Integer height, List<Optional<RecipeItemStack>> ingredients) {
        return new ShapedRecipePattern(width, height, ingredients, Optional.empty());
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, String ... pattern) {
        return ShapedRecipePattern.a(key, List.of(pattern));
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, List<String> pattern) {
        a data = new a(key, pattern);
        return (ShapedRecipePattern)ShapedRecipePattern.a(data).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> a(a data) {
        String[] strings = ShapedRecipePattern.a(data.c);
        int len = strings[0].length();
        int i2 = strings.length;
        ArrayList<Optional<RecipeItemStack>> list = new ArrayList<Optional<RecipeItemStack>>(len * i2);
        CharArraySet set = new CharArraySet(data.b.keySet());
        for (String string : strings) {
            for (int i1 = 0; i1 < string.length(); ++i1) {
                Optional<Object> optional;
                char c2 = string.charAt(i1);
                if (c2 == ' ') {
                    optional = Optional.empty();
                } else {
                    RecipeItemStack ingredient = data.b.get(Character.valueOf(c2));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c2 + "' but it's not defined in the key");
                    }
                    optional = Optional.of(ingredient);
                }
                set.remove(c2);
                list.add(optional);
            }
        }
        return !set.isEmpty() ? DataResult.error(() -> ShapedRecipePattern.a((CharSet)set)) : DataResult.success((Object)new ShapedRecipePattern(len, i2, list, Optional.of(data)));
    }

    @VisibleForTesting
    static String[] a(List<String> pattern) {
        int i2 = Integer.MAX_VALUE;
        int i1 = 0;
        int i22 = 0;
        int i3 = 0;
        for (int i4 = 0; i4 < pattern.size(); ++i4) {
            String string = pattern.get(i4);
            i2 = Math.min(i2, ShapedRecipePattern.a(string));
            int i5 = ShapedRecipePattern.b(string);
            i1 = Math.max(i1, i5);
            if (i5 < 0) {
                if (i22 == i4) {
                    ++i22;
                }
                ++i3;
                continue;
            }
            i3 = 0;
        }
        if (pattern.size() == i3) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - i3 - i22];
        for (int i6 = 0; i6 < strings.length; ++i6) {
            strings[i6] = pattern.get(i6 + i22).substring(i2, i1 + 1);
        }
        return strings;
    }

    private static int a(String row) {
        int i2;
        for (i2 = 0; i2 < row.length() && row.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private static int b(String row) {
        int i2;
        for (i2 = row.length() - 1; i2 >= 0 && row.charAt(i2) == ' '; --i2) {
        }
        return i2;
    }

    public boolean a(CraftingInput input) {
        if (input.e() != this.i) {
            return false;
        }
        if (input.f() == this.e && input.g() == this.f) {
            if (!this.j && this.a(input, true)) {
                return true;
            }
            if (this.a(input, false)) {
                return true;
            }
        }
        return false;
    }

    private boolean a(CraftingInput input, boolean symmetrical) {
        for (int i2 = 0; i2 < this.f; ++i2) {
            for (int i1 = 0; i1 < this.e; ++i1) {
                ItemStack item;
                Optional<RecipeItemStack> optional = symmetrical ? this.g.get(this.e - i1 - 1 + i2 * this.e) : this.g.get(i1 + i2 * this.e);
                if (RecipeItemStack.a(optional, item = input.a(i1, i2))) continue;
                return false;
            }
        }
        return true;
    }

    public int a() {
        return this.e;
    }

    public int b() {
        return this.f;
    }

    public List<Optional<RecipeItemStack>> c() {
        return this.g;
    }

    private static /* synthetic */ String a(CharSet set) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(set);
    }

    public static final class a
    extends Record {
        private final Map<Character, RecipeItemStack> b;
        private final List<String> c;
        private static final Codec<List<String>> d = Codec.STRING.listOf().comapFlatMap(patternEntry -> {
            if (patternEntry.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (patternEntry.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int len = ((String)patternEntry.getFirst()).length();
            for (String string : patternEntry) {
                if (string.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (len == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)patternEntry);
        }, Function.identity());
        private static final Codec<Character> e = Codec.STRING.comapFlatMap(symbol -> {
            if (symbol.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + symbol + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(symbol) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(symbol.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.b(e, RecipeItemStack.d).fieldOf("key").forGetter(data -> data.b), (App)d.fieldOf("pattern").forGetter(data -> data.c)).apply((Applicative)instance, a::new));

        public a(Map<Character, RecipeItemStack> key, List<String> pattern) {
            this.b = key;
            this.c = pattern;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this, o2);
        }

        public Map<Character, RecipeItemStack> a() {
            return this.b;
        }

        public List<String> b() {
            return this.c;
        }
    }
}

