/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.jspecify.annotations.Nullable;

public class ShapedRecipes
implements RecipeCrafting {
    final ShapedRecipePattern d;
    final ItemStack e;
    final String f;
    final CraftingBookCategory g;
    final boolean h;
    private @Nullable PlacementInfo i;

    public ShapedRecipes(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        this.f = group;
        this.g = category;
        this.d = pattern;
        this.e = result;
        this.h = showNotification;
    }

    public ShapedRecipes(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result) {
        this(group, category, pattern, result, true);
    }

    @Override
    public RecipeSerializer<? extends ShapedRecipes> a() {
        return RecipeSerializer.a;
    }

    @Override
    public String j() {
        return this.f;
    }

    @Override
    public CraftingBookCategory c() {
        return this.g;
    }

    @VisibleForTesting
    public List<Optional<RecipeItemStack>> f() {
        return this.d.c();
    }

    @Override
    public PlacementInfo aq_() {
        if (this.i == null) {
            this.i = PlacementInfo.a(this.d.c());
        }
        return this.i;
    }

    @Override
    public boolean i() {
        return this.h;
    }

    @Override
    public boolean a(CraftingInput input, World level) {
        return this.d.a(input);
    }

    @Override
    public ItemStack a(CraftingInput input, HolderLookup.a registries) {
        return this.e.v();
    }

    public int k() {
        return this.d.a();
    }

    public int l() {
        return this.d.b();
    }

    @Override
    public List<RecipeDisplay> g() {
        return List.of(new ShapedCraftingRecipeDisplay(this.d.a(), this.d.b(), this.d.c().stream().map(optional -> optional.map(RecipeItemStack::c).orElse(SlotDisplay.c.c)).toList(), new SlotDisplay.f(this.e), new SlotDisplay.d(Items.fu)));
    }

    public ShapedRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.e);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, result, this);
        recipe.setGroup(this.f);
        recipe.setCategory(CraftRecipe.getCategory(this.c()));
        block0 : switch (this.d.b()) {
            case 1: {
                switch (this.d.a()) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.d.a()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.d.a()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c2 = 'a';
        for (Optional<RecipeItemStack> list : this.d.c()) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != RecipeChoice.empty()) {
                recipe.setIngredient(c2, choice);
            }
            c2 = (char)(c2 + 1);
        }
        return recipe;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipes> {
        public static final MapCodec<ShapedRecipes> w = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedRecipe -> shapedRecipe.f), (App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(shapedRecipe -> shapedRecipe.g), (App)ShapedRecipePattern.b.forGetter(shapedRecipe -> shapedRecipe.d), (App)ItemStack.d.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.e), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(shapedRecipe -> shapedRecipe.h)).apply((Applicative)instance, ShapedRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> x = StreamCodec.a(Serializer::a, Serializer::a);

        @Override
        public MapCodec<ShapedRecipes> a() {
            return w;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedRecipes> b() {
            return x;
        }

        private static ShapedRecipes a(RegistryFriendlyByteBuf buffer) {
            String utf = buffer.p();
            CraftingBookCategory craftingBookCategory = buffer.b(CraftingBookCategory.class);
            ShapedRecipePattern shapedRecipePattern = (ShapedRecipePattern)ShapedRecipePattern.c.decode(buffer);
            ItemStack itemStack = (ItemStack)ItemStack.j.decode(buffer);
            boolean _boolean = buffer.readBoolean();
            return new ShapedRecipes(utf, craftingBookCategory, shapedRecipePattern, itemStack, _boolean);
        }

        private static void a(RegistryFriendlyByteBuf buffer, ShapedRecipes recipe) {
            buffer.a(recipe.f);
            buffer.a(recipe.g);
            ShapedRecipePattern.c.encode(buffer, recipe.d);
            ItemStack.j.encode(buffer, recipe.e);
            buffer.a(recipe.h);
        }
    }
}

