/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.jspecify.annotations.Nullable;

public class ShapelessRecipes
implements RecipeCrafting {
    final String d;
    final CraftingBookCategory e;
    final ItemStack f;
    final List<RecipeItemStack> g;
    private @Nullable PlacementInfo h;

    public ShapelessRecipes(String group, CraftingBookCategory category, ItemStack result, List<RecipeItemStack> ingredients) {
        this.d = group;
        this.e = category;
        this.f = result;
        this.g = ingredients;
    }

    public ShapelessRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.f);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(id, result, this);
        recipe.setGroup(this.d);
        recipe.setCategory(CraftRecipe.getCategory(this.c()));
        for (RecipeItemStack list : this.g) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<ShapelessRecipes> a() {
        return RecipeSerializer.b;
    }

    @Override
    public String j() {
        return this.d;
    }

    @Override
    public CraftingBookCategory c() {
        return this.e;
    }

    @Override
    public PlacementInfo aq_() {
        if (this.h == null) {
            this.h = PlacementInfo.b(this.g);
        }
        return this.h;
    }

    @Override
    public boolean a(CraftingInput input, World level) {
        if (input.e() != this.g.size()) {
            return false;
        }
        if (input.a() == 1 && this.g.size() == 1) {
            return this.g.getFirst().a(input.a(0));
        }
        input.c().initializeExtras(this, input);
        boolean canCraft = input.c().a(this, null);
        input.c().resetExtras();
        return canCraft;
    }

    @Override
    public ItemStack a(CraftingInput input, HolderLookup.a registries) {
        return this.f.v();
    }

    @Override
    public List<RecipeDisplay> g() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.g.stream().map(RecipeItemStack::c).toList(), new SlotDisplay.f(this.f), new SlotDisplay.d(Items.fu)));
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final MapCodec<ShapelessRecipes> x = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.d), (App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(recipe -> recipe.e), (App)ItemStack.d.fieldOf("result").forGetter(recipe -> recipe.f), (App)RecipeItemStack.d.listOf(1, 9).fieldOf("ingredients").forGetter(recipe -> recipe.g)).apply((Applicative)instance, ShapelessRecipes::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> w = StreamCodec.a(ByteBufCodecs.p, recipe -> recipe.d, CraftingBookCategory.g, recipe -> recipe.e, ItemStack.j, recipe -> recipe.f, RecipeItemStack.a.a(ByteBufCodecs.a()), recipe -> recipe.g, ShapelessRecipes::new);

        @Override
        public MapCodec<ShapelessRecipes> a() {
            return x;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessRecipes> b() {
            return w;
        }
    }
}

