/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableFloat;

public record Enchantment(IChatBaseComponent e, c f, HolderSet<Enchantment> g, DataComponentMap h) {
    private final IChatBaseComponent e;
    private final c f;
    private final HolderSet<Enchantment> g;
    private final DataComponentMap h;
    public static final int a = 255;
    public static final Codec<Enchantment> b = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.a.fieldOf("description").forGetter(Enchantment::f), (App)net.minecraft.world.item.enchantment.Enchantment$c.a.forGetter(Enchantment::g), (App)RegistryCodecs.a(Registries.bf).optionalFieldOf("exclusive_set", HolderSet.a(new Holder[0])).forGetter(Enchantment::h), (App)EnchantmentEffectComponents.b.optionalFieldOf("effects", (Object)DataComponentMap.a).forGetter(Enchantment::i)).apply((Applicative)instance, Enchantment::new));
    public static final Codec<Holder<Enchantment>> c = RegistryFixedCodec.a(Registries.bf);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Enchantment>> d = ByteBufCodecs.b(Registries.bf);

    public static b a(int cost) {
        return new b(cost, 0);
    }

    public static b a(int base, int perLevel) {
        return new b(base, perLevel);
    }

    public static c a(HolderSet<Item> supportedItems, HolderSet<Item> primaryItems, int weight, int maxLevel, b minCost, b maxCost, int anvilCost, EquipmentSlotGroup ... slots) {
        return new c(supportedItems, Optional.of(primaryItems), weight, maxLevel, minCost, maxCost, anvilCost, List.of(slots));
    }

    public static c a(HolderSet<Item> supportedItems, int weight, int maxLevel, b minCost, b maxCost, int anvilCost, EquipmentSlotGroup ... slots) {
        return new c(supportedItems, Optional.empty(), weight, maxLevel, minCost, maxCost, anvilCost, List.of(slots));
    }

    public Map<EnumItemSlot, ItemStack> a(EntityLiving entity) {
        EnumMap map = Maps.newEnumMap(EnumItemSlot.class);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot;
            if (!this.a(equipmentSlot) || (itemBySlot = entity.a(equipmentSlot)).f()) continue;
            map.put(equipmentSlot, itemBySlot);
        }
        return map;
    }

    public HolderSet<Item> a() {
        return this.f.a();
    }

    public boolean a(EnumItemSlot slot) {
        return this.f.h().stream().anyMatch(equipmentSlotGroup -> equipmentSlotGroup.b(slot));
    }

    public boolean a(ItemStack stack) {
        return this.b(stack) && (this.f.c.isEmpty() || stack.a(this.f.c.get()));
    }

    public boolean b(ItemStack item) {
        return item.a(this.f.b);
    }

    public int b() {
        return this.f.c();
    }

    public int c() {
        return this.f.g();
    }

    public int d() {
        return 1;
    }

    public int e() {
        return this.f.d();
    }

    public int b(int level) {
        return this.f.e().a(level);
    }

    public int c(int level) {
        return this.f.f().a(level);
    }

    @Override
    public String toString() {
        return "Enchantment " + this.e.getString();
    }

    public static boolean a(Holder<Enchantment> first, Holder<Enchantment> second) {
        return !first.equals(second) && !first.a().g.a(second) && !second.a().g.a(first);
    }

    public static IChatBaseComponent a(Holder<Enchantment> enchantment, int level) {
        IChatMutableComponent mutableComponent = enchantment.a().e.f();
        mutableComponent = enchantment.a(EnchantmentTags.o) ? ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.m)) : ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.h));
        if (level != 1 || enchantment.a().e() != 1) {
            mutableComponent.b(CommonComponents.x).b(IChatBaseComponent.c("enchantment.level." + level));
        }
        return mutableComponent;
    }

    public boolean c(ItemStack stack) {
        return this.f.a().a(stack.i());
    }

    public <T> List<T> a(DataComponentType<List<T>> component) {
        return this.h.a(component, List.of());
    }

    public boolean a(WorldServer level, int enchantmentLevel, Entity entity, DamageSource damageSource) {
        LootTableInfo lootContext = Enchantment.b(level, enchantmentLevel, entity, damageSource);
        for (ConditionalEffect conditionalEffect : this.a(EnchantmentEffectComponents.d)) {
            if (!conditionalEffect.a(lootContext)) continue;
            return true;
        }
        return false;
    }

    public void a(WorldServer level, int enchantmentLevel, ItemStack stack, Entity entity, DamageSource damageSource, MutableFloat damageProtection) {
        LootTableInfo lootContext = Enchantment.b(level, enchantmentLevel, entity, damageSource);
        for (ConditionalEffect conditionalEffect : this.a(EnchantmentEffectComponents.c)) {
            if (!conditionalEffect.a(lootContext)) continue;
            damageProtection.setValue(((EnchantmentValueEffect)conditionalEffect.a()).a(enchantmentLevel, entity.ep(), damageProtection.floatValue()));
        }
    }

    public void a(WorldServer level, int enchantmentLevel, ItemStack tool, MutableFloat durabilityChange) {
        this.a(EnchantmentEffectComponents.l, level, enchantmentLevel, tool, durabilityChange);
    }

    public void b(WorldServer level, int enchantmentLevel, ItemStack tool, MutableFloat ammoCount) {
        this.a(EnchantmentEffectComponents.q, level, enchantmentLevel, tool, ammoCount);
    }

    public void c(WorldServer level, int enchantmentLevel, ItemStack tool, MutableFloat piercingCount) {
        this.a(EnchantmentEffectComponents.r, level, enchantmentLevel, tool, piercingCount);
    }

    public void d(WorldServer level, int enchantmentLevel, ItemStack tool, MutableFloat blockExperience) {
        this.a(EnchantmentEffectComponents.y, level, enchantmentLevel, tool, blockExperience);
    }

    public void a(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat mobExperience) {
        this.a(EnchantmentEffectComponents.z, level, enchantmentLevel, tool, entity, mobExperience);
    }

    public void e(WorldServer level, int enchantmentLevel, ItemStack tool, MutableFloat durabilityToRepairFromXp) {
        this.a(EnchantmentEffectComponents.A, level, enchantmentLevel, tool, durabilityToRepairFromXp);
    }

    public void b(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat tridentReturnToOwnerAcceleration) {
        this.a(EnchantmentEffectComponents.v, level, enchantmentLevel, tool, entity, tridentReturnToOwnerAcceleration);
    }

    public void a(RandomSource random, int enchantmentLevel, MutableFloat value) {
        this.a(EnchantmentEffectComponents.G, random, enchantmentLevel, value);
    }

    public void c(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat fishingTimeReduction) {
        this.a(EnchantmentEffectComponents.w, level, enchantmentLevel, tool, entity, fishingTimeReduction);
    }

    public void d(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat fishingLuckBonus) {
        this.a(EnchantmentEffectComponents.x, level, enchantmentLevel, tool, entity, fishingLuckBonus);
    }

    public void b(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, DamageSource damageSource, MutableFloat damage) {
        this.a(EnchantmentEffectComponents.e, level, enchantmentLevel, tool, entity, damageSource, damage);
    }

    public void c(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, DamageSource damageSource, MutableFloat fallBasedDamage) {
        this.a(EnchantmentEffectComponents.f, level, enchantmentLevel, tool, entity, damageSource, fallBasedDamage);
    }

    public void d(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, DamageSource damageSource, MutableFloat knockback) {
        this.a(EnchantmentEffectComponents.g, level, enchantmentLevel, tool, entity, damageSource, knockback);
    }

    public void e(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, DamageSource damageSource, MutableFloat armorEffectiveness) {
        this.a(EnchantmentEffectComponents.h, level, enchantmentLevel, tool, entity, damageSource, armorEffectiveness);
    }

    public void a(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, EnchantmentTarget target, Entity entity, DamageSource damageSource) {
        for (TargetedConditionalEffect targetedConditionalEffect : this.a(EnchantmentEffectComponents.i)) {
            if (target != targetedConditionalEffect.a()) continue;
            Enchantment.a(targetedConditionalEffect, level, enchantmentLevel, item, entity, damageSource);
        }
    }

    public static void a(TargetedConditionalEffect<EnchantmentEntityEffect> effect, WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, DamageSource damageSource) {
        if (effect.a(Enchantment.b(level, enchantmentLevel, entity, damageSource))) {
            Entity entity1;
            switch (effect.b()) {
                default: {
                    throw new MatchException(null, null);
                }
                case a: {
                    Entity entity2 = damageSource.d();
                    break;
                }
                case b: {
                    Entity entity2 = damageSource.c();
                    break;
                }
                case c: {
                    Entity entity2 = entity1 = entity;
                }
            }
            if (entity1 != null) {
                effect.c().a(level, enchantmentLevel, item, entity1, entity1.dI());
            }
        }
    }

    public void a(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity) {
        Enchantment.a(this.a(EnchantmentEffectComponents.j), Enchantment.a(level, enchantmentLevel, entity, entity.dI()), (T enchantmentEntityEffect) -> enchantmentEntityEffect.a(level, enchantmentLevel, item, entity, entity.dI()));
    }

    public void e(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat projectileCount) {
        this.a(EnchantmentEffectComponents.u, level, enchantmentLevel, tool, entity, projectileCount);
    }

    public void f(WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat projectileSpread) {
        this.a(EnchantmentEffectComponents.t, level, enchantmentLevel, tool, entity, projectileSpread);
    }

    public void b(RandomSource random, int enchantmentLevel, MutableFloat value) {
        this.a(EnchantmentEffectComponents.B, random, enchantmentLevel, value);
    }

    public void a(DataComponentType<EnchantmentValueEffect> component, RandomSource random, int enchantmentLevel, MutableFloat value) {
        EnchantmentValueEffect enchantmentValueEffect = this.h.a(component);
        if (enchantmentValueEffect != null) {
            value.setValue(enchantmentValueEffect.a(enchantmentLevel, random, value.floatValue()));
        }
    }

    public void b(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity) {
        Enchantment.a(this.a(EnchantmentEffectComponents.p), Enchantment.a(level, enchantmentLevel, entity, entity.dI()), (T enchantmentEntityEffect) -> enchantmentEntityEffect.a(level, enchantmentLevel, item, entity, entity.dI()));
    }

    public void c(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity) {
        Enchantment.a(this.a(EnchantmentEffectComponents.s), Enchantment.a(level, enchantmentLevel, entity, entity.dI()), (T enchantmentEntityEffect) -> enchantmentEntityEffect.a(level, enchantmentLevel, item, entity, entity.dI()));
    }

    public void a(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3D pos, IBlockData state) {
        Enchantment.a(this.a(EnchantmentEffectComponents.k), Enchantment.a(level, enchantmentLevel, entity, pos, state), (T enchantmentEntityEffect) -> enchantmentEntityEffect.a(level, enchantmentLevel, item, entity, pos));
    }

    private void a(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> component, WorldServer level, int enchantmentLevel, ItemStack tool, MutableFloat value) {
        Enchantment.a(this.a(component), Enchantment.a(level, enchantmentLevel, tool), (T enchantmentValueEffect) -> value.setValue(enchantmentValueEffect.a(enchantmentLevel, level.G_(), value.floatValue())));
    }

    private void a(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> component, WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, MutableFloat value) {
        Enchantment.a(this.a(component), Enchantment.a(level, enchantmentLevel, entity, entity.dI()), (T enchantmentValueEffect) -> value.setValue(enchantmentValueEffect.a(enchantmentLevel, entity.ep(), value.floatValue())));
    }

    private void a(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> component, WorldServer level, int enchantmentLevel, ItemStack tool, Entity entity, DamageSource damageSource, MutableFloat value) {
        Enchantment.a(this.a(component), Enchantment.b(level, enchantmentLevel, entity, damageSource), (T enchantmentValueEffect) -> value.setValue(enchantmentValueEffect.a(enchantmentLevel, entity.ep(), value.floatValue())));
    }

    public static LootTableInfo b(WorldServer level, int enchantmentLevel, Entity entity, DamageSource damageSource) {
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.a, entity).a(LootContextParameters.m, enchantmentLevel).a(LootContextParameters.h, entity.dI()).a(LootContextParameters.e, damageSource).b(LootContextParameters.f, damageSource.d()).b(LootContextParameters.g, damageSource.c()).a(LootContextParameterSets.v);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer level, int enchantmentLevel, ItemStack tool) {
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.k, tool).a(LootContextParameters.m, enchantmentLevel).a(LootContextParameterSets.w);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer level, int enchantmentLevel, Entity entity, boolean enchantmentActive) {
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.a, entity).a(LootContextParameters.m, enchantmentLevel).a(LootContextParameters.h, entity.dI()).a(LootContextParameters.n, enchantmentActive).a(LootContextParameterSets.x);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer level, int enchantmentLevel, Entity entity, Vec3D origin) {
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.a, entity).a(LootContextParameters.m, enchantmentLevel).a(LootContextParameters.h, origin).a(LootContextParameterSets.y);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static LootTableInfo a(WorldServer level, int enchantmentLevel, Entity entity, Vec3D origin, IBlockData state) {
        LootParams lootParams = new LootParams.a(level).a(LootContextParameters.a, entity).a(LootContextParameters.m, enchantmentLevel).a(LootContextParameters.h, origin).a(LootContextParameters.i, state).a(LootContextParameterSets.z);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    private static <T> void a(List<ConditionalEffect<T>> effects, LootTableInfo context, Consumer<T> applier) {
        for (ConditionalEffect<T> conditionalEffect : effects) {
            if (!conditionalEffect.a(context)) continue;
            applier.accept(conditionalEffect.a());
        }
    }

    public void a(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, EntityLiving entity) {
        EnumItemSlot equipmentSlot = item.b();
        if (equipmentSlot != null) {
            Map<Enchantment, Set<EnchantmentLocationBasedEffect>> map = entity.c(equipmentSlot);
            if (!this.a(equipmentSlot)) {
                Set<EnchantmentLocationBasedEffect> set = map.remove(this);
                if (set != null) {
                    set.forEach(effect -> effect.a(item, entity, entity.dI(), enchantmentLevel));
                }
            } else {
                ObjectArraySet set = map.get(this);
                for (ConditionalEffect conditionalEffect : this.a(EnchantmentEffectComponents.o)) {
                    boolean flag;
                    EnchantmentLocationBasedEffect enchantmentLocationBasedEffect = (EnchantmentLocationBasedEffect)conditionalEffect.a();
                    boolean bl = flag = set != null && set.contains(enchantmentLocationBasedEffect);
                    if (conditionalEffect.a(Enchantment.a(level, enchantmentLevel, (Entity)entity, flag))) {
                        if (!flag) {
                            if (set == null) {
                                set = new ObjectArraySet();
                                map.put(this, (Set<EnchantmentLocationBasedEffect>)set);
                            }
                            set.add((EnchantmentLocationBasedEffect)enchantmentLocationBasedEffect);
                        }
                        enchantmentLocationBasedEffect.a(level, enchantmentLevel, item, entity, entity.dI(), !flag);
                        continue;
                    }
                    if (set == null || !set.remove(enchantmentLocationBasedEffect)) continue;
                    enchantmentLocationBasedEffect.a(item, entity, entity.dI(), enchantmentLevel);
                }
                if (set != null && set.isEmpty()) {
                    map.remove(this);
                }
            }
        }
    }

    public void a(int enchantmentLevel, EnchantedItemInUse item, EntityLiving entity) {
        Set<EnchantmentLocationBasedEffect> set;
        EnumItemSlot equipmentSlot = item.b();
        if (equipmentSlot != null && (set = entity.c(equipmentSlot).remove(this)) != null) {
            for (EnchantmentLocationBasedEffect enchantmentLocationBasedEffect : set) {
                enchantmentLocationBasedEffect.a(item, entity, entity.dI(), enchantmentLevel);
            }
        }
    }

    public static a a(c definition) {
        return new a(definition);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Enchantment.class, "description;definition;exclusiveSet;effects", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Enchantment.class, "description;definition;exclusiveSet;effects", "e", "f", "g", "h"}, this, o2);
    }

    public IChatBaseComponent f() {
        return this.e;
    }

    public c g() {
        return this.f;
    }

    public HolderSet<Enchantment> h() {
        return this.g;
    }

    public DataComponentMap i() {
        return this.h;
    }

    public static final class c
    extends Record {
        private final HolderSet<Item> b;
        private final Optional<HolderSet<Item>> c;
        private final int d;
        private final int e;
        private final b f;
        private final b g;
        private final int h;
        private final List<EquipmentSlotGroup> i;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.a(Registries.R).fieldOf("supported_items").forGetter(c::a), (App)RegistryCodecs.a(Registries.R).optionalFieldOf("primary_items").forGetter(c::b), (App)ExtraCodecs.a(1, 1024).fieldOf("weight").forGetter(c::c), (App)ExtraCodecs.a(1, 255).fieldOf("max_level").forGetter(c::d), (App)net.minecraft.world.item.enchantment.Enchantment$b.a.fieldOf("min_cost").forGetter(c::e), (App)net.minecraft.world.item.enchantment.Enchantment$b.a.fieldOf("max_cost").forGetter(c::f), (App)ExtraCodecs.q.fieldOf("anvil_cost").forGetter(c::g), (App)EquipmentSlotGroup.m.listOf().fieldOf("slots").forGetter(c::h)).apply((Applicative)instance, c::new));

        public c(HolderSet<Item> supportedItems, Optional<HolderSet<Item>> primaryItems, int weight, int maxLevel, b minCost, b maxCost, int anvilCost, List<EquipmentSlotGroup> slots) {
            this.b = supportedItems;
            this.c = primaryItems;
            this.d = weight;
            this.e = maxLevel;
            this.f = minCost;
            this.g = maxCost;
            this.h = anvilCost;
            this.i = slots;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "b", "c", "d", "e", "f", "g", "h", "i"}, this, o2);
        }

        public HolderSet<Item> a() {
            return this.b;
        }

        public Optional<HolderSet<Item>> b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public b e() {
            return this.f;
        }

        public b f() {
            return this.g;
        }

        public int g() {
            return this.h;
        }

        public List<EquipmentSlotGroup> h() {
            return this.i;
        }
    }

    public static final class b
    extends Record {
        private final int b;
        private final int c;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("base").forGetter(b::a), (App)Codec.INT.fieldOf("per_level_above_first").forGetter(b::b)).apply((Applicative)instance, b::new));

        public b(int base, int perLevelAboveFirst) {
            this.b = base;
            this.c = perLevelAboveFirst;
        }

        public int a(int level) {
            return this.b + this.c * (level - 1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "base;perLevelAboveFirst", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "base;perLevelAboveFirst", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "base;perLevelAboveFirst", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }

    public static class a {
        private final c a;
        private HolderSet<Enchantment> b = HolderSet.a(new Holder[0]);
        private final Map<DataComponentType<?>, List<?>> c = new HashMap();
        private final DataComponentMap.a d = DataComponentMap.a();

        public a(c definition) {
            this.a = definition;
        }

        public a a(HolderSet<Enchantment> exclusiveSet) {
            this.b = exclusiveSet;
            return this;
        }

        public <E> a a(DataComponentType<List<ConditionalEffect<E>>> component, E effect, LootItemCondition.a requirements) {
            this.b(component).add(new ConditionalEffect<E>(effect, Optional.of(requirements.build())));
            return this;
        }

        public <E> a a(DataComponentType<List<ConditionalEffect<E>>> component, E effect) {
            this.b(component).add(new ConditionalEffect<E>(effect, Optional.empty()));
            return this;
        }

        public <E> a a(DataComponentType<List<TargetedConditionalEffect<E>>> component, EnchantmentTarget enchanted, EnchantmentTarget affected, E effect, LootItemCondition.a requirements) {
            this.b(component).add(new TargetedConditionalEffect<E>(enchanted, affected, effect, Optional.of(requirements.build())));
            return this;
        }

        public <E> a a(DataComponentType<List<TargetedConditionalEffect<E>>> component, EnchantmentTarget enchanted, EnchantmentTarget affected, E effect) {
            this.b(component).add(new TargetedConditionalEffect<E>(enchanted, affected, effect, Optional.empty()));
            return this;
        }

        public a a(DataComponentType<List<EnchantmentAttributeEffect>> component, EnchantmentAttributeEffect effect) {
            this.b(component).add(effect);
            return this;
        }

        public <E> a b(DataComponentType<E> component, E value) {
            this.d.a(component, value);
            return this;
        }

        public a a(DataComponentType<Unit> component) {
            this.d.a(component, Unit.a);
            return this;
        }

        private <E> List<E> b(DataComponentType<List<E>> component) {
            return this.c.computeIfAbsent(component, dataComponentType -> {
                ArrayList list = new ArrayList();
                this.d.a(component, list);
                return list;
            });
        }

        public Enchantment a(MinecraftKey location) {
            return new Enchantment(IChatBaseComponent.c(SystemUtils.a("enchantment", location)), this.a, this.b, this.d.a());
        }
    }
}

