/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.phys.Vec3D;

public final class EnchantmentAttributeEffect
extends Record
implements EnchantmentLocationBasedEffect {
    private final MinecraftKey b;
    private final Holder<AttributeBase> d;
    private final LevelBasedValue e;
    private final AttributeModifier.Operation f;
    public static final MapCodec<EnchantmentAttributeEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.fieldOf("id").forGetter(EnchantmentAttributeEffect::b), (App)AttributeBase.a.fieldOf("attribute").forGetter(EnchantmentAttributeEffect::c), (App)LevelBasedValue.b.fieldOf("amount").forGetter(EnchantmentAttributeEffect::d), (App)AttributeModifier.Operation.f.fieldOf("operation").forGetter(EnchantmentAttributeEffect::e)).apply((Applicative)instance, EnchantmentAttributeEffect::new));

    public EnchantmentAttributeEffect(MinecraftKey id, Holder<AttributeBase> attribute, LevelBasedValue amount, AttributeModifier.Operation operation) {
        this.b = id;
        this.d = attribute;
        this.e = amount;
        this.f = operation;
    }

    private MinecraftKey a(INamable slot) {
        return this.b.g("/" + slot.c());
    }

    public AttributeModifier a(int enchantmentLevel, INamable slot) {
        return new AttributeModifier(this.a(slot), this.d().a(enchantmentLevel), this.e());
    }

    @Override
    public void a(WorldServer level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3D pos, boolean applyTransientEffects) {
        if (applyTransientEffects && entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.fw().a((Multimap<Holder<AttributeBase>, AttributeModifier>)this.a(enchantmentLevel, item.b()));
        }
    }

    @Override
    public void a(EnchantedItemInUse item, Entity entity, Vec3D pos, int enchantmentLevel) {
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.fw().b((Multimap<Holder<AttributeBase>, AttributeModifier>)this.a(enchantmentLevel, item.b()));
        }
    }

    private HashMultimap<Holder<AttributeBase>, AttributeModifier> a(int enchantmentLevel, EnumItemSlot slot) {
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put(this.d, (Object)this.a(enchantmentLevel, (INamable)slot));
        return hashMultimap;
    }

    public MapCodec<EnchantmentAttributeEffect> a() {
        return a;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnchantmentAttributeEffect.class, "id;attribute;amount;operation", "b", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnchantmentAttributeEffect.class, "id;attribute;amount;operation", "b", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnchantmentAttributeEffect.class, "id;attribute;amount;operation", "b", "d", "e", "f"}, this, o2);
    }

    public MinecraftKey b() {
        return this.b;
    }

    public Holder<AttributeBase> c() {
        return this.d;
    }

    public LevelBasedValue d() {
        return this.e;
    }

    public AttributeModifier.Operation e() {
        return this.f;
    }
}

