/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import io.papermc.paper.annotation.DoNotUse;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.command.CommandSender;
import org.bukkit.event.server.ServerCommandEvent;
import org.jspecify.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public abstract class CommandBlockListenerAbstract {
    private static final IChatBaseComponent a = IChatBaseComponent.b("@");
    private static final int b = -1;
    private long c = -1L;
    private boolean d = true;
    private int e;
    private boolean f = true;
    @Nullable IChatBaseComponent g;
    private String h = "";
    private @Nullable IChatBaseComponent i;

    protected abstract CommandSender getBukkitSender(CommandListenerWrapper var1);

    public abstract WorldServer getLevel();

    public int b() {
        return this.e;
    }

    public void a(int successCount) {
        this.e = successCount;
    }

    public IChatBaseComponent c() {
        return this.g == null ? CommonComponents.a : this.g;
    }

    public void a(ValueOutput output) {
        output.a("Command", this.h);
        output.a("SuccessCount", this.e);
        output.b("CustomName", ComponentSerialization.a, this.i);
        output.a("TrackOutput", this.f);
        if (this.f) {
            output.b("LastOutput", ComponentSerialization.a, this.g);
        }
        output.a("UpdateLastExecution", this.d);
        if (this.d && this.c != -1L) {
            output.a("LastExecution", this.c);
        }
    }

    public void a(ValueInput input) {
        this.h = input.a("Command", "");
        this.e = input.a("SuccessCount", 0);
        this.a(TileEntity.a(input, "CustomName"));
        this.f = input.a("TrackOutput", true);
        this.g = this.f ? TileEntity.a(input, "LastOutput") : null;
        this.d = input.a("UpdateLastExecution", true);
        this.c = this.d ? input.a("LastExecution", -1L) : -1L;
    }

    public void a(String command) {
        this.h = command;
        this.e = 0;
    }

    public String d() {
        return this.h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean b(WorldServer level) {
        if (level.au() == this.c) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.h)) {
            this.g = IChatBaseComponent.b("#itzlipofutzli");
            this.e = 1;
            return true;
        }
        this.e = 0;
        if (level.Y() && !UtilColor.b(this.h)) {
            try {
                this.g = null;
                try (CloseableCommandBlockSource closeableCommandBlockSource = this.c(level);){
                    ICommandListener commandSource = Objects.requireNonNullElse(closeableCommandBlockSource, ICommandListener.a);
                    CommandListenerWrapper commandSourceStack = this.a(level, commandSource).a((boolean success, int result) -> {
                        if (success) {
                            ++this.e;
                        }
                    });
                    ServerCommandEvent event = new ServerCommandEvent(commandSourceStack.getBukkitSender(), CommandDispatcher.a(this.h));
                    if (!event.callEvent()) {
                        boolean bl = true;
                        return bl;
                    }
                    level.s().aF().a(commandSourceStack, event.getCommand());
                }
            }
            catch (Throwable var7) {
                CrashReport crashReport = CrashReport.a(var7, "Executing command block");
                CrashReportSystemDetails crashReportCategory = crashReport.a("Command to be executed");
                crashReportCategory.a("Command", this::d);
                crashReportCategory.a("Name", () -> this.e().getString());
                throw new ReportedException(crashReport);
            }
        }
        if (this.d) {
            this.c = level.au();
            return true;
        }
        this.c = -1L;
        return true;
    }

    public CloseableCommandBlockSource c(WorldServer level) {
        return new CloseableCommandBlockSource(level, this.f);
    }

    public IChatBaseComponent e() {
        return this.i != null ? this.i : a;
    }

    public @Nullable IChatBaseComponent f() {
        return this.i;
    }

    public void a(@Nullable IChatBaseComponent customName) {
        this.i = customName;
    }

    public abstract void a(WorldServer var1);

    public void b(@Nullable IChatBaseComponent lastOutputMessage) {
        this.g = lastOutputMessage;
    }

    public void a(boolean shouldTrackOutput) {
        this.f = shouldTrackOutput;
    }

    public boolean g() {
        return this.f;
    }

    public abstract CommandListenerWrapper a(WorldServer var1, ICommandListener var2);

    public abstract boolean a();

    public class CloseableCommandBlockSource
    implements ICommandListener,
    AutoCloseable {
        private final WorldServer c;
        private static final DateTimeFormatter d = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
        private boolean e;
        private final boolean trackOutput;

        public CloseableCommandBlockSource(WorldServer level, boolean trackOutput) {
            this.c = level;
            this.trackOutput = trackOutput;
        }

        @DoNotUse
        @Deprecated
        public CloseableCommandBlockSource(WorldServer level) {
            this(level, true);
        }

        @Override
        public boolean x_() {
            return !this.e && this.c.U().a(GameRules.R) != false;
        }

        @Override
        public boolean y_() {
            return this.trackOutput && !this.e;
        }

        @Override
        public boolean c() {
            return !this.e && this.c.U().a(GameRules.g) != false;
        }

        @Override
        public void a(IChatBaseComponent message) {
            if (this.trackOutput && !this.e) {
                AsyncCatcher.catchOp("sendSystemMessage to a command block");
                CommandBlockListenerAbstract.this.g = IChatBaseComponent.b("[" + d.format(ZonedDateTime.now()) + "] ").b(message);
                CommandBlockListenerAbstract.this.a(this.c);
            }
        }

        @Override
        public void close() throws Exception {
            this.e = true;
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return CommandBlockListenerAbstract.this.getBukkitSender(wrapper);
        }
    }
}

