/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityProcessor;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    private static final Logger a = LogUtils.getLogger();
    public static final String b = "SpawnData";
    private static final int c = 1;
    private static final int d = 20;
    private static final int e = 200;
    private static final int f = 800;
    private static final int g = 4;
    private static final int h = 6;
    private static final int i = 16;
    private static final int j = 4;
    public int k = 20;
    public WeightedList<MobSpawnerData> l = WeightedList.a();
    public @Nullable MobSpawnerData m;
    private double n;
    private double o;
    public int p = 200;
    public int q = 800;
    public int r = 4;
    private @Nullable Entity s;
    public int t = 6;
    public int u = 16;
    public int v = 4;
    private int tickDelay = 0;

    public void a(EntityTypes<?> type, @Nullable World level, RandomSource random, BlockPosition pos) {
        this.a(level, random, pos).a().a("id", BuiltInRegistries.g.b(type).toString());
        this.l = WeightedList.a();
    }

    public boolean c(World level, BlockPosition pos) {
        return level.hasNearbyAlivePlayerThatAffectsSpawning((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, this.u);
    }

    public void a(World level, BlockPosition pos) {
        if (!this.c(level, pos)) {
            this.o = this.n;
        } else if (this.s != null) {
            RandomSource random = level.G_();
            double d2 = (double)pos.u() + random.j();
            double d1 = (double)pos.v() + random.j();
            double d22 = (double)pos.w() + random.j();
            level.a(Particles.ai, d2, d1, d22, 0.0, 0.0, 0.0);
            level.a(Particles.G, d2, d1, d22, 0.0, 0.0, 0.0);
            if (this.k > 0) {
                --this.k;
            }
            this.o = this.n;
            this.n = (this.n + (double)(1000.0f / ((float)this.k + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer level, BlockPosition pos) {
        if (this.r <= 0 || this.t <= 0) {
            return;
        }
        if (this.k > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = level.paperConfig().tickRates.mobSpawner;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.c(level, pos) && level.Z()) {
            if (this.k < -this.tickDelay) {
                this.d(level, pos);
            }
            if (this.k > 0) {
                this.k -= this.tickDelay;
            } else {
                boolean flag = false;
                RandomSource random = level.G_();
                MobSpawnerData nextSpawnData = this.a((World)level, random, pos);
                for (int i2 = 0; i2 < this.r; ++i2) {
                    try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this::toString, a);){
                        ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)level.J_(), nextSpawnData.a());
                        Optional<EntityTypes<?>> optional = EntityTypes.a(valueInput);
                        if (optional.isEmpty()) {
                            this.d(level, pos);
                            return;
                        }
                        Vec3D vec3 = valueInput.a("Pos", Vec3D.a).orElseGet(() -> new Vec3D((double)pos.u() + (random.j() - random.j()) * (double)this.v + 0.5, pos.v() + random.a(3) - 1, (double)pos.w() + (random.j() - random.j()) * (double)this.v + 0.5));
                        if (!level.b(optional.get().a(vec3.g, vec3.h, vec3.i))) continue;
                        BlockPosition blockPos = BlockPosition.a(vec3);
                        if (nextSpawnData.b().isPresent()) {
                            MobSpawnerData.a customSpawnRules;
                            if (!optional.get().f().d() && level.av() == EnumDifficulty.a || !(customSpawnRules = nextSpawnData.b().get()).a(blockPos, level)) continue;
                        } else if (!EntityPositionTypes.a(optional.get(), level, EntitySpawnReason.c, blockPos, level.G_())) continue;
                        PreSpawnerSpawnEvent event = new PreSpawnerSpawnEvent(CraftLocation.toBukkit(vec3, (World)level), CraftEntityType.minecraftToBukkit(optional.get()), CraftLocation.toBukkit((BaseBlockPosition)pos, (World)level));
                        if (!event.callEvent()) {
                            flag = true;
                            if (!event.shouldAbortSpawn()) continue;
                            break;
                        }
                        Entity entity = EntityTypes.a(valueInput, (World)level, EntitySpawnReason.c, entity1 -> {
                            entity1.b(vec3.g, vec3.h, vec3.i, entity1.ec(), entity1.ee());
                            return entity1;
                        });
                        if (entity == null) {
                            this.d(level, pos);
                            return;
                        }
                        int size = level.a(EntityTypeTest.b(entity.getClass()), new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1).g(this.v), IEntitySelector.f).size();
                        if (size >= this.t) {
                            this.d(level, pos);
                            return;
                        }
                        entity.b(entity.dP(), entity.dR(), entity.dV(), random.i() * 360.0f, 0.0f);
                        if (entity instanceof EntityInsentient) {
                            boolean flag1;
                            EntityInsentient mob = (EntityInsentient)entity;
                            if (nextSpawnData.b().isEmpty() && !mob.a((GeneratorAccess)level, EntitySpawnReason.c) || !mob.a((IWorldReader)level)) continue;
                            boolean bl = flag1 = nextSpawnData.a().i() == 1 && nextSpawnData.a().i("id").isPresent();
                            if (flag1) {
                                ((EntityInsentient)entity).a((WorldAccess)level, level.c(entity.dK()), EntitySpawnReason.c, null);
                            }
                            nextSpawnData.c().ifPresent(mob::a);
                            if (mob.ao().spigotConfig.nerfSpawnerMobs) {
                                mob.aware = false;
                            }
                        }
                        entity.spawnedViaMobSpawner = true;
                        entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                        flag = true;
                        if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) continue;
                        if (!level.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                            this.d(level, pos);
                            return;
                        }
                        level.c(2004, pos, 0);
                        level.a(entity, GameEvent.t, blockPos);
                        if (!(entity instanceof EntityInsentient)) continue;
                        ((EntityInsentient)entity).U();
                        continue;
                    }
                }
                if (flag) {
                    this.d(level, pos);
                }
                return;
            }
        }
    }

    public void d(World level, BlockPosition pos) {
        RandomSource randomSource = level.y;
        this.k = this.q <= this.p ? this.p : this.p + randomSource.a(this.q - this.p);
        this.l.a(randomSource).ifPresent(spawnData -> this.a(level, pos, (MobSpawnerData)spawnData));
        this.a(level, pos, 1);
    }

    public void a(@Nullable World level, BlockPosition pos, ValueInput input) {
        this.k = input.a("Paper.Delay", input.a("Delay", (short)20));
        input.a(b, MobSpawnerData.b).ifPresent(spawnData -> this.a(level, pos, (MobSpawnerData)spawnData));
        this.l = input.a("SpawnPotentials", MobSpawnerData.c).orElseGet(() -> WeightedList.a(this.m != null ? this.m : new MobSpawnerData()));
        this.p = input.a("Paper.MinSpawnDelay", input.a("MinSpawnDelay", 200));
        this.q = input.a("Paper.MaxSpawnDelay", input.a("MaxSpawnDelay", 800));
        this.r = input.a("SpawnCount", 4);
        this.t = input.a("MaxNearbyEntities", 6);
        this.u = input.a("RequiredPlayerRange", 16);
        this.v = input.a("SpawnRange", 4);
        this.s = null;
    }

    public void a(ValueOutput output) {
        if (this.k > Short.MAX_VALUE) {
            output.a("Paper.Delay", this.k);
        }
        output.a("Delay", (short)Math.min(Short.MAX_VALUE, this.k));
        if (this.p > Short.MAX_VALUE || this.q > Short.MAX_VALUE) {
            output.a("Paper.MinSpawnDelay", this.p);
            output.a("Paper.MaxSpawnDelay", this.q);
        }
        output.a("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.p));
        output.a("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.q));
        output.a("SpawnCount", (short)this.r);
        output.a("MaxNearbyEntities", (short)this.t);
        output.a("RequiredPlayerRange", (short)this.u);
        output.a("SpawnRange", (short)this.v);
        output.b(b, MobSpawnerData.b, this.m);
        output.a("SpawnPotentials", MobSpawnerData.c, this.l);
    }

    public @Nullable Entity b(World level, BlockPosition pos) {
        if (this.s == null) {
            NBTTagCompound entityToSpawn = this.a(level, level.G_(), pos).a();
            if (entityToSpawn.i("id").isEmpty()) {
                return null;
            }
            this.s = EntityTypes.a(entityToSpawn, level, EntitySpawnReason.c, EntityProcessor.a);
            if (entityToSpawn.i() != 1 || this.s instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.s;
    }

    public boolean a(World level, int id) {
        if (id == 1) {
            if (level.B_()) {
                this.k = this.p;
            }
            return true;
        }
        return false;
    }

    public void a(@Nullable World level, BlockPosition pos, MobSpawnerData nextSpawnData) {
        this.m = nextSpawnData;
    }

    private MobSpawnerData a(@Nullable World level, RandomSource random, BlockPosition pos) {
        if (this.m != null) {
            return this.m;
        }
        this.a(level, pos, this.l.a(random).orElseGet(MobSpawnerData::new));
        return this.m;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.n;
    }

    public double b() {
        return this.o;
    }
}

