/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.AbstractIterator;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.CursorPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class VoxelShapeSpliterator<T>
extends AbstractIterator<T> {
    private final AxisAlignedBB a;
    private final VoxelShapeCollision b;
    private final CursorPosition c;
    private final BlockPosition.MutableBlockPosition d;
    private final VoxelShape e;
    private final ICollisionAccess f;
    private final boolean g;
    private @Nullable IBlockAccess h;
    private long i;
    private final BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> j;

    public VoxelShapeSpliterator(ICollisionAccess collisionGetter, @Nullable Entity entity, AxisAlignedBB box, boolean onlySuffocatingBlocks, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultProvider) {
        this(collisionGetter, entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity), box, onlySuffocatingBlocks, resultProvider);
    }

    public VoxelShapeSpliterator(ICollisionAccess collisionGetter, VoxelShapeCollision context, AxisAlignedBB box, boolean onlySuffocatingBlocks, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultProvider) {
        this.b = context;
        this.d = new BlockPosition.MutableBlockPosition();
        this.e = VoxelShapes.a(box);
        this.f = collisionGetter;
        this.a = box;
        this.g = onlySuffocatingBlocks;
        this.j = resultProvider;
        int i2 = MathHelper.c(box.a - 1.0E-7) - 1;
        int i1 = MathHelper.c(box.d + 1.0E-7) + 1;
        int i22 = MathHelper.c(box.b - 1.0E-7) - 1;
        int i3 = MathHelper.c(box.e + 1.0E-7) + 1;
        int i4 = MathHelper.c(box.c - 1.0E-7) - 1;
        int i5 = MathHelper.c(box.f + 1.0E-7) + 1;
        this.c = new CursorPosition(i2, i22, i4, i1, i3, i5);
    }

    private @Nullable IBlockAccess a(int x2, int z2) {
        IBlockAccess chunkForCollisions;
        int sectionPosX = SectionPosition.a(x2);
        int sectionPosZ = SectionPosition.a(z2);
        long packedChunkPos = ChunkCoordIntPair.d(sectionPosX, sectionPosZ);
        if (this.h != null && this.i == packedChunkPos) {
            return this.h;
        }
        this.h = chunkForCollisions = this.f.c(sectionPosX, sectionPosZ);
        this.i = packedChunkPos;
        return chunkForCollisions;
    }

    protected T computeNext() {
        while (this.c.a()) {
            IBlockAccess chunk;
            int i2 = this.c.b();
            int i1 = this.c.c();
            int i22 = this.c.d();
            int nextType = this.c.e();
            if (nextType == 3 || (chunk = this.a(i2, i22)) == null) continue;
            this.d.d(i2, i1, i22);
            IBlockData blockState = chunk.a_(this.d);
            if (this.g && !blockState.j(chunk, this.d) || nextType == 1 && !blockState.i() || nextType == 2 && !blockState.a(Blocks.ca)) continue;
            VoxelShape collisionShape = this.b.a(blockState, this.f, this.d);
            if (collisionShape == VoxelShapes.b()) {
                if (!this.a.a(i2, i1, i22, (double)i2 + 1.0, (double)i1 + 1.0, (double)i22 + 1.0)) continue;
                return this.j.apply(this.d, collisionShape.a(this.d));
            }
            VoxelShape voxelShape = collisionShape.a(this.d);
            if (voxelShape.c() || !VoxelShapes.c(voxelShape, this.e, OperatorBoolean.i)) continue;
            return this.j.apply(this.d, voxelShape);
        }
        return (T)this.endOfData();
    }
}

