/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.dfl.DefaultEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.antixray.ChunkPacketBlockController;
import io.papermc.paper.antixray.ChunkPacketBlockControllerAntiXray;
import io.papermc.paper.configuration.WorldConfiguration;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotWorldConfig;

public abstract class World
implements GeneratorAccess,
AutoCloseable,
ChunkSystemLevel,
ChunkSystemEntityGetter {
    public static final Codec<ResourceKey<World>> g = ResourceKey.a(Registries.bE);
    public static final ResourceKey<World> h = ResourceKey.a(Registries.bE, MinecraftKey.b("overworld"));
    public static final ResourceKey<World> i = ResourceKey.a(Registries.bE, MinecraftKey.b("the_nether"));
    public static final ResourceKey<World> j = ResourceKey.a(Registries.bE, MinecraftKey.b("the_end"));
    public static final int k = 30000000;
    public static final int l = 512;
    public static final int m = 32;
    public static final int n = 15;
    public static final int o = 20000000;
    public static final int p = -20000000;
    public static final WeightedList<ExplosionParticleInfo> a = WeightedList.b().a(new ExplosionParticleInfo(Particles.af, 0.5f, 1.0f)).a(new ExplosionParticleInfo(Particles.ai, 1.0f, 1.0f)).a();
    public final List<TickingBlockEntity> q = Lists.newArrayList();
    protected final CollectingNeighborUpdater r;
    private final List<TickingBlockEntity> b = Lists.newArrayList();
    private boolean c;
    public final Thread d;
    private final boolean e;
    private int f;
    protected int s = RandomSource.a().f();
    protected final int t = 1013904223;
    protected float u;
    public float v;
    protected float w;
    public float x;
    public final RandomSource y = new ThreadUnsafeRandom(RandomSupport.a());
    @Deprecated
    private final RandomSource B = RandomSource.b();
    private final Holder<DimensionManager> C;
    public final WorldDataMutable z;
    private final boolean D;
    private final BiomeManager E;
    private final ResourceKey<World> F;
    private final IRegistryCustom G;
    private final DamageSources H;
    private final PalettedContainerFactory I;
    private long J;
    public final ChunkPacketBlockController chunkPacketBlockController;
    private final CraftWorld world;
    public @Nullable ChunkGenerator generator;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CraftBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CraftBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new LinkedHashMap<BlockPosition, TileEntity>();
    public @Nullable List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public int wakeupInactiveRemainingAnimals;
    public int wakeupInactiveRemainingFlying;
    public int wakeupInactiveRemainingMonsters;
    public int wakeupInactiveRemainingVillagers;
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    private final WorldConfiguration paperConfig;
    public static @Nullable BlockPosition lastPhysicsProblem;
    private int tileTickPosition;
    public final Map<ServerExplosion.CacheKey, Float> explosionDensityCache = new HashMap<ServerExplosion.CacheKey, Float>();
    public ArrayDeque<BlockRedstoneTorch.RedstoneUpdateInfo> redstoneUpdateInfos;
    private EntityLookup entityLookup;
    private final ConcurrentLong2ReferenceChainedHashTable<ChunkData> chunkData = new ConcurrentLong2ReferenceChainedHashTable();
    private static final Fluid AIR_FLUIDSTATE;
    private final int minY;
    private final int height;
    private final int maxY;
    private final int minSectionY;
    private final int maxSectionY;
    private final int sectionsCount;

    public WorldConfiguration paperConfig() {
        return this.paperConfig;
    }

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.getChunkIfLoaded(chunkX, chunkZ) != null;
    }

    private int getTicksPerSpawn(SpawnCategory spawnCategory) {
        int perWorld = this.paperConfig().entities.spawning.ticksPerSpawn.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory));
        if (perWorld >= 0) {
            return perWorld;
        }
        return this.getCraftServer().getTicksPerSpawns(spawnCategory);
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    @Override
    public final EntityLookup moonrise$getEntityLookup() {
        return this.entityLookup;
    }

    @Override
    public final void moonrise$setEntityLookup(EntityLookup entityLookup) {
        if (this.entityLookup != null && !(this.entityLookup instanceof DefaultEntityLookup)) {
            throw new IllegalStateException("Entity lookup already initialised");
        }
        this.entityLookup = entityLookup;
    }

    @Override
    public final <T extends net.minecraft.world.entity.Entity> List<T> a(Class<T> entityClass, AxisAlignedBB boundingBox, Predicate<? super T> predicate) {
        Profiler.a().f("getEntities");
        ArrayList ret = new ArrayList();
        this.moonrise$getEntityLookup().getEntities(entityClass, null, boundingBox, ret, predicate);
        return ret;
    }

    @Override
    public final List<net.minecraft.world.entity.Entity> moonrise$getHardCollidingEntities(net.minecraft.world.entity.Entity entity, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getHardCollidingEntities(entity, box, ret, predicate);
        return ret;
    }

    @Override
    public Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (Chunk)this.ac().a(chunkX, chunkZ, ChunkStatus.n, false);
    }

    @Override
    public IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        return this.ac().a(chunkX, chunkZ, ChunkStatus.c, false);
    }

    @Override
    public IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        return this.ac().a(chunkX, chunkZ, leastStatus, false);
    }

    @Override
    public void moonrise$midTickTasks() {
    }

    @Override
    public final ChunkData moonrise$getChunkData(long chunkKey) {
        return (ChunkData)this.chunkData.get(chunkKey);
    }

    @Override
    public final ChunkData moonrise$getChunkData(int chunkX, int chunkZ) {
        return (ChunkData)this.chunkData.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Override
    public final ChunkData moonrise$requestChunkData(long chunkKey) {
        return (ChunkData)this.chunkData.compute(chunkKey, (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                ChunkData ret = new ChunkData();
                ret.increaseRef();
                return ret;
            }
            valueInMap.increaseRef();
            return valueInMap;
        });
    }

    @Override
    public final ChunkData moonrise$releaseChunkData(long chunkKey) {
        return (ChunkData)this.chunkData.compute(chunkKey, (keyInMap, chunkData) -> chunkData.decreaseRef() == 0 ? null : chunkData);
    }

    @Override
    public boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        IChunkProvider chunkSource = this.ac();
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.b(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean b(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.moonrise$areChunksLoaded(minBlockX >> 4, minBlockZ >> 4, maxBlockX >> 4, maxBlockZ >> 4);
    }

    @Override
    public IChunkAccess a(int x2, int z2, ChunkStatus status) {
        return this.a(x2, z2, status, true);
    }

    @Override
    public BlockPosition a(HeightMap.Type types, BlockPosition blockPos) {
        return new BlockPosition(blockPos.u(), this.a(types, blockPos.u(), blockPos.w()), blockPos.w());
    }

    @Override
    public boolean f(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB boundingBox = entity.dj();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a(entity, boundingBox.c(-1.0E-7, -1.0E-7, -1.0E-7), (Predicate<? super net.minecraft.world.entity.Entity>)null);
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity otherEntity = entities.get(i2);
            if (otherEntity.au() || otherEntity.eh() || !otherEntity.W || otherEntity.A(entity)) continue;
            return false;
        }
        return true;
    }

    private static MovingObjectPositionBlock miss(RayTrace clipContext) {
        Vec3D to = clipContext.a();
        Vec3D from = clipContext.b();
        return MovingObjectPositionBlock.a(to, EnumDirection.a(from.g - to.g, from.h - to.h, from.i - to.i), BlockPosition.a(to.g, to.h, to.i));
    }

    private static MovingObjectPositionBlock fastClip(Vec3D from, Vec3D to, World level, RayTrace clipContext) {
        double adjX = 1.0E-7 * (from.g - to.g);
        double adjY = 1.0E-7 * (from.h - to.h);
        double adjZ = 1.0E-7 * (from.i - to.i);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return World.miss(clipContext);
        }
        double toXAdj = to.g - adjX;
        double toYAdj = to.h - adjY;
        double toZAdj = to.i - adjZ;
        double fromXAdj = from.g + adjX;
        double fromYAdj = from.h + adjY;
        double fromZAdj = from.i + adjZ;
        int currX = MathHelper.c(fromXAdj);
        int currY = MathHelper.c(fromYAdj);
        int currZ = MathHelper.c(fromZAdj);
        BlockPosition.MutableBlockPosition currPos = new BlockPosition.MutableBlockPosition();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - MathHelper.h(fromXAdj) : MathHelper.h(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - MathHelper.h(fromYAdj) : MathHelper.h(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - MathHelper.h(fromZAdj) : MathHelper.h(fromZAdj));
        ChunkSection[] lastChunk = null;
        DataPaletteBlock<IBlockData> lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = WorldUtil.getMinSection(level);
        while (true) {
            IBlockData blockState;
            currPos.d(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                int sectionY;
                if (chunkDiff != 0) {
                    lastChunk = level.d(newChunkX, newChunkZ).d();
                }
                lastSection = (sectionY = newChunkY - minSection) >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].h : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = lastSection.a(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).l()) {
                VoxelShape fluidCollision;
                MovingObjectPositionBlock fluidHit;
                Fluid fluidState;
                MovingObjectPositionBlock blockHit;
                VoxelShape blockCollision = clipContext.a(blockState, (IBlockAccess)level, (BlockPosition)currPos);
                MovingObjectPositionBlock movingObjectPositionBlock = blockHit = blockCollision.c() ? null : level.a(from, to, currPos, blockCollision, blockState);
                if (clipContext.d != RayTrace.FluidCollisionOption.a && (fluidState = blockState.y()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.a(fluidState, (IBlockAccess)level, (BlockPosition)currPos)).a(from, to, currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.g(blockHit.g()) <= from.g(fluidHit.g()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return World.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Override
    public MovingObjectPositionBlock a(RayTrace clipContext) {
        return World.fastClip(clipContext.b(), clipContext.a(), this, clipContext);
    }

    @Override
    public boolean i(net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, 8, (state, pos) -> state.j(this, (BlockPosition)pos));
    }

    private static VoxelShape inflateAABBToVoxel(AxisAlignedBB aabb, double x2, double y2, double z2) {
        return VoxelShapes.b(aabb.a - x2, aabb.b - y2, aabb.c - z2, aabb.d + x2, aabb.e + y2, aabb.f + z2);
    }

    @Override
    public Optional<Vec3D> a(net.minecraft.world.entity.Entity entity, VoxelShape boundsShape, Vec3D fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.c()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        AxisAlignedBB collectionVolume = boundsShape.a().c(expandByX, expandByY, expandByZ);
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, collectionVolume, voxels, aabbs, 4, null);
        WorldBorder worldBorder = this.w();
        if (worldBorder != null) {
            aabbs.removeIf(aabb -> !worldBorder.a((AxisAlignedBB)aabb));
            voxels.removeIf(shape -> !worldBorder.a(shape.a()));
        }
        int len = voxels.size();
        for (int i2 = 0; i2 < len; ++i2) {
            aabbs.addAll(((VoxelShape)voxels.get(i2)).e());
        }
        VoxelShape first = aabbs.isEmpty() ? VoxelShapes.a() : World.inflateAABBToVoxel((AxisAlignedBB)aabbs.get(0), expandByX, expandByY, expandByZ);
        VoxelShape[] rest = new VoxelShape[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i3 = 1; i3 < len2; ++i3) {
            rest[i3 - 1] = World.inflateAABBToVoxel((AxisAlignedBB)aabbs.get(i3), expandByX, expandByY, expandByZ);
        }
        VoxelShape joined = VoxelShapes.a(first, rest);
        VoxelShape freeSpace = VoxelShapes.b(boundsShape, joined, OperatorBoolean.e);
        return freeSpace.b(fromPosition);
    }

    @Override
    public Optional<BlockPosition> j(net.minecraft.world.entity.Entity entity, AxisAlignedBB aabb) {
        int minSection = WorldUtil.getMinSection(this);
        int minBlockX = MathHelper.c(aabb.a - 1.0E-7) - 1;
        int maxBlockX = MathHelper.c(aabb.d + 1.0E-7) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, MathHelper.c(aabb.b - 1.0E-7) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection(this) << 4) + 16, MathHelper.c(aabb.e + 1.0E-7) + 1);
        int minBlockZ = MathHelper.c(aabb.c - 1.0E-7) - 1;
        int maxBlockZ = MathHelper.c(aabb.f + 1.0E-7) + 1;
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        CollisionUtil.LazyEntityCollisionContext collisionShape = new CollisionUtil.LazyEntityCollisionContext(entity);
        BaseBlockPosition selected = null;
        double selectedDistance = Double.MAX_VALUE;
        Vec3D entityPos = entity.dI();
        if (minBlockY > maxBlockY) {
            return Optional.empty();
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        IChunkProvider chunkSource = this.ac();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                IChunkAccess chunk = chunkSource.a(currChunkX, currChunkZ, ChunkStatus.n, false);
                if (chunk == null) continue;
                ChunkSection[] sections = chunk.d();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    ChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).c()) continue;
                    boolean hasSpecial = section.moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.q(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.r(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                IBlockData blockData;
                                double distance;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.p(blockX);
                                int n2 = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (distance = mutablePos.b(entityPos)) > selectedDistance || distance == selectedDistance && selected.i(mutablePos) >= 0 || (blockData = blocks.a(localBlockIndex)).moonrise$emptyContextCollisionShape()) continue;
                                VoxelShape blockCollision = blockData.moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.i() || edgeCount == 2 && blockData.b() != Blocks.ca) || blockCollision == null && (blockCollision = blockData.b((IBlockAccess)this, (BlockPosition)mutablePos, collisionShape)).c()) continue;
                                AxisAlignedBB shiftedAABB = aabb.d(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AxisAlignedBB singleAABB = blockCollision.moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                                    selected = mutablePos.j();
                                    selectedDistance = distance;
                                    continue;
                                }
                                if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                                selected = mutablePos.j();
                                selectedDistance = distance;
                            }
                        }
                    }
                }
            }
        }
        return Optional.ofNullable(selected);
    }

    @Override
    public int K_() {
        return this.minY;
    }

    @Override
    public int L_() {
        return this.height;
    }

    @Override
    public int aw() {
        return this.maxY;
    }

    @Override
    public int ax() {
        return this.sectionsCount;
    }

    @Override
    public int ay() {
        return this.minSectionY;
    }

    @Override
    public int az() {
        return this.maxSectionY;
    }

    @Override
    public boolean d(int blockY) {
        return blockY >= this.minY && blockY <= this.maxY;
    }

    @Override
    public boolean y(BlockPosition pos) {
        return this.e(pos.v());
    }

    @Override
    public boolean e(int blockY) {
        return blockY < this.minY || blockY > this.maxY;
    }

    @Override
    public int f(int blockY) {
        return (blockY >> 4) - this.minSectionY;
    }

    @Override
    public int g(int sectionY) {
        return sectionY - this.minSectionY;
    }

    @Override
    public int h(int sectionIdx) {
        return sectionIdx + this.minSectionY;
    }

    @Override
    public abstract Holder<BiomeBase> a(int var1, int var2, int var3);

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2) {
        IChunkAccess chunk = this.a(x2 >> 2, z2 >> 2, ChunkStatus.f, false);
        return chunk != null ? chunk.getNoiseBiome(x2, y2, z2) : this.a(x2, y2, z2);
    }

    protected World(WorldDataMutable levelData, ResourceKey<World> dimension, IRegistryCustom registryAccess, Holder<DimensionManager> dimensionTypeRegistration, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates, @Nullable ChunkGenerator generator, @Nullable BiomeProvider biomeProvider, World.Environment environment, Function<SpigotWorldConfig, WorldConfiguration> paperWorldConfigCreator, Executor executor) {
        DimensionManager dimType = dimensionTypeRegistration.a();
        this.minY = dimType.h();
        this.height = dimType.i();
        this.maxY = this.minY + this.height - 1;
        this.minSectionY = this.minY >> 4;
        this.maxSectionY = this.maxY >> 4;
        this.sectionsCount = this.maxSectionY - this.minSectionY + 1;
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)levelData).d());
        this.paperConfig = paperWorldConfigCreator.apply(this.spigotConfig);
        this.generator = generator;
        this.world = new CraftWorld((WorldServer)this, generator, biomeProvider, environment);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getTicksPerSpawn(spawnCategory));
        }
        this.z = levelData;
        this.C = dimensionTypeRegistration;
        this.F = dimension;
        this.D = isClientSide;
        this.d = Thread.currentThread();
        this.E = new BiomeManager(this, biomeZoomSeed);
        this.e = isDebug;
        this.r = new CollectingNeighborUpdater(this, maxChainedNeighborUpdates);
        this.G = registryAccess;
        this.I = PalettedContainerFactory.a(registryAccess);
        this.H = new DamageSources(registryAccess);
        this.entityLookup = new DefaultEntityLookup(this);
        this.chunkPacketBlockController = this.paperConfig().anticheat.antiXray.enabled ? new ChunkPacketBlockControllerAntiXray(this, executor) : ChunkPacketBlockController.NO_OPERATION_INSTANCE;
    }

    public final boolean checkEntityCollision(IBlockData state, net.minecraft.world.entity.Entity source, VoxelShapeCollision collisionContext, BlockPosition position, boolean checkCanSee) {
        VoxelShape collisionShape = state.b((IBlockAccess)this, position, collisionContext);
        if (collisionShape.c()) {
            return true;
        }
        if ((collisionShape = collisionShape.a(position.u(), (double)position.v(), (double)position.w())).c()) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a_(null, collisionShape.a());
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = entities.get(i2);
            if (checkCanSee && source instanceof EntityPlayer && entity instanceof EntityPlayer && !((EntityPlayer)source).getBukkitEntity().canSee(((EntityPlayer)entity).getBukkitEntity()) || entity.eh() || !entity.W || !VoxelShapes.c(collisionShape, VoxelShapes.a(entity.dj()), OperatorBoolean.i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean B_() {
        return this.D;
    }

    @Override
    public @Nullable MinecraftServer s() {
        return null;
    }

    public MovingObjectPosition.EnumMovingObjectType clipDirect(Vec3D start, Vec3D end, VoxelShapeCollision context) {
        return this.a(new RayTrace(start, end, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, context)).d();
    }

    public boolean n(BlockPosition pos) {
        return pos.isInsideBuildHeightAndWorldBoundsHorizontal(this);
    }

    public boolean o(BlockPosition blockPos) {
        return !this.y(blockPos) && World.g(blockPos);
    }

    public static boolean p(BlockPosition pos) {
        return !World.b(pos.v()) && World.c(pos);
    }

    private static boolean c(BlockPosition pos) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000;
    }

    private static boolean g(BlockPosition blockPos) {
        int sectionPosX = SectionPosition.a(blockPos.u());
        int sectionPosZ = SectionPosition.a(blockPos.w());
        return ChunkCoordIntPair.c(sectionPosX, sectionPosZ);
    }

    private static boolean b(int y2) {
        return y2 < -20000000 || y2 >= 20000000;
    }

    public final Chunk q(BlockPosition pos) {
        return this.d(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public final Chunk d(int chunkX, int chunkZ) {
        ChunkProviderServer cps = ((WorldServer)this).p();
        Chunk ifLoaded = cps.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        return (Chunk)cps.a(chunkX, chunkZ, ChunkStatus.n, true);
    }

    @Override
    public final @Nullable IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return ((WorldServer)this).G.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public final @Nullable IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.y(pos)) {
            return Blocks.nY.m();
        }
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.a_(pos);
    }

    @Override
    public final @Nullable Fluid getFluidIfLoaded(BlockPosition pos) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
        return chunk == null ? null : chunk.b_(pos);
    }

    @Override
    public final boolean H(BlockPosition pos) {
        return this.getChunkIfLoaded(pos.u() >> 4, pos.w() >> 4) != null;
    }

    public final boolean isLoadedAndInBounds(BlockPosition pos) {
        return this.w().a(pos) && this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4) != null;
    }

    public @Nullable Chunk getChunkIfLoaded(int x2, int z2) {
        return ((WorldServer)this).p().getChunkAtIfLoadedImmediately(x2, z2);
    }

    public final @Nullable Chunk getChunkIfLoaded(BlockPosition pos) {
        return ((WorldServer)this).p().getChunkAtIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
    }

    public final @Nullable IBlockData getBlockStateIfLoadedAndInBounds(BlockPosition pos) {
        return this.w().a(pos) ? this.getBlockStateIfLoaded(pos) : null;
    }

    @Override
    public @Nullable IChunkAccess a(int x2, int z2, ChunkStatus chunkStatus, boolean requireChunk) {
        IChunkAccess chunk = this.ac().a(x2, z2, chunkStatus, requireChunk);
        if (chunk == null && requireChunk) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunk;
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, @Block.b int flags) {
        return this.a(pos, state, flags, 512);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, @Block.b int flags, int recursionLeft) {
        if (this.captureTreeGeneration) {
            IBlockData type = this.a_(pos);
            if (!type.isDestroyable()) {
                return false;
            }
            CraftBlockState blockstate = this.capturedBlockStates.get(pos);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, pos, flags);
                this.capturedBlockStates.put(pos.j(), blockstate);
            }
            blockstate.setData(state);
            blockstate.setFlags(flags);
            return true;
        }
        if (!this.o(pos)) {
            return false;
        }
        if (!this.B_() && this.ar()) {
            return false;
        }
        Chunk chunkAt = this.q(pos);
        Block block = state.b();
        boolean captured = false;
        if (this.captureBlockStates) {
            CraftBlockState snapshot;
            if (!this.capturedBlockStates.containsKey(pos)) {
                snapshot = (CraftBlockState)CraftBlock.at(this, pos).getState();
                this.capturedBlockStates.put(pos.j(), snapshot);
                captured = true;
            } else {
                snapshot = this.capturedBlockStates.get(pos);
            }
            snapshot.setFlags(flags);
        }
        IBlockData blockState = chunkAt.a(pos, state, flags);
        this.chunkPacketBlockController.onBlockChange(this, pos, state, blockState, flags, recursionLeft);
        if (blockState == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(pos);
            }
            return false;
        }
        IBlockData blockState1 = this.a_(pos);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(pos, chunkAt, blockState, state, blockState1, flags, recursionLeft);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = pos.j();
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition pos, Chunk chunkAt, IBlockData oldState, IBlockData newState, IBlockData currentState, @Block.b int flags, int recursionLeft) {
        IBlockData state = newState;
        IBlockData blockState = oldState;
        IBlockData blockState1 = currentState;
        if (blockState1 == state) {
            if (blockState != blockState1) {
                this.b(pos, blockState, blockState1);
            }
            if ((flags & 2) != 0 && (!this.B_() || (flags & 4) == 0) && (this.B_() || chunkAt == null || chunkAt.G() != null && chunkAt.G().a(FullChunkStatus.b))) {
                this.a(pos, blockState, state, flags);
            }
            if ((flags & 1) != 0) {
                this.a(pos, blockState.b());
                if (!this.B_() && state.q()) {
                    this.b(pos, newState.b());
                }
            }
            if ((flags & 0x10) == 0 && recursionLeft > 0) {
                int i2 = flags & 0xFFFFFFDE;
                blockState.b(this, pos, i2, recursionLeft - 1);
                boolean cancelledUpdates = false;
                if (((WorldServer)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)CraftBlockData.fromData(state));
                    boolean bl = cancelledUpdates = !event.callEvent();
                }
                if (!cancelledUpdates) {
                    state.a((GeneratorAccess)this, pos, i2, recursionLeft - 1);
                    state.b(this, pos, i2, recursionLeft - 1);
                }
            }
            this.a(pos, blockState, blockState1);
        }
    }

    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState) {
    }

    @Override
    public boolean a(BlockPosition pos, boolean movedByPiston) {
        Fluid fluidState = this.b_(pos);
        return this.a(pos, fluidState.g(), 3 | (movedByPiston ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition pos, boolean dropBlock, @Nullable net.minecraft.world.entity.Entity entity, int recursionLeft) {
        boolean flag;
        IBlockData blockState = this.a_(pos);
        if (blockState.l()) {
            return false;
        }
        Fluid fluidState = this.b_(pos);
        boolean playEffect = true;
        IBlockData effectType = blockState;
        int xp = blockState.b().getExpDrop(blockState, (WorldServer)this, pos, ItemStack.l, true);
        if (BlockDestroyEvent.getHandlerList().getRegisteredListeners().length > 0) {
            BlockDestroyEvent event = new BlockDestroyEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)fluidState.g().createCraftBlockData(), (BlockData)effectType.createCraftBlockData(), xp, dropBlock);
            if (!event.callEvent()) {
                return false;
            }
            effectType = ((CraftBlockData)event.getEffectBlock()).getState();
            playEffect = event.playEffect();
            dropBlock = event.willDrop();
            xp = event.getExpToDrop();
        }
        if (playEffect && !(blockState.b() instanceof BlockFireAbstract)) {
            this.c(2001, pos, Block.j(effectType));
        }
        if (dropBlock) {
            TileEntity blockEntity = blockState.x() ? this.c_(pos) : null;
            Block.dropResources(blockState, this, pos, blockEntity, entity, ItemStack.l, false);
            blockState.b().popExperience((WorldServer)this, pos, xp, entity);
        }
        if (flag = this.a(pos, fluidState.g(), 3, recursionLeft)) {
            this.a(GameEvent.f, pos, GameEvent.a.a(entity, blockState));
        }
        return flag;
    }

    public void b(BlockPosition pos, IBlockData state) {
    }

    public boolean c(BlockPosition pos, IBlockData state) {
        return this.a(pos, state, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, @Block.b int var4);

    public void b(BlockPosition pos, IBlockData oldState, IBlockData newState) {
    }

    public void a(BlockPosition pos, Block block, @Nullable Orientation orientation) {
    }

    public void a(BlockPosition pos, Block block, EnumDirection facing, @Nullable Orientation orientation) {
    }

    public void b(BlockPosition pos, Block block, @Nullable Orientation orientation) {
    }

    public void a(IBlockData state, BlockPosition pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) {
    }

    @Override
    public void a(EnumDirection direction, BlockPosition pos, BlockPosition neighborPos, IBlockData neighborState, @Block.b int flags, int recursionLeft) {
        this.r.a(direction, neighborState, pos, neighborPos, flags, recursionLeft);
    }

    @Override
    public int a(HeightMap.Type heightmapType, int x2, int z2) {
        int i2 = x2 >= -30000000 && z2 >= -30000000 && x2 < 30000000 && z2 < 30000000 ? (this.b(SectionPosition.a(x2), SectionPosition.a(z2)) ? this.d(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmapType, x2 & 0xF, z2 & 0xF) + 1 : this.K_()) : this.V() + 1;
        return i2;
    }

    @Override
    public LevelLightEngine C_() {
        return this.ac().r();
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (!this.o(pos)) {
            return Blocks.nY.m();
        }
        IChunkAccess chunk = this.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.n, true);
        return chunk.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (!this.o(pos)) {
            return FluidTypes.a.g();
        }
        Chunk chunkAt = this.q(pos);
        return chunkAt.b_(pos);
    }

    public boolean ag() {
        return !this.F_().d() && this.f < 4;
    }

    public boolean ah() {
        return !this.F_().d() && !this.ag();
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(entity, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, category, volume, pitch);
    }

    public abstract void a(@Nullable net.minecraft.world.entity.Entity var1, double var2, double var4, double var6, Holder<SoundEffect> var8, SoundCategory var9, float var10, float var11, long var12);

    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, SoundEffect sound, SoundCategory source, float volume, float pitch, long seed) {
        this.a(entity, x2, y2, z2, BuiltInRegistries.b.e(sound), source, volume, pitch, seed);
    }

    public abstract void a(@Nullable net.minecraft.world.entity.Entity var1, net.minecraft.world.entity.Entity var2, Holder<SoundEffect> var3, SoundCategory var4, float var5, float var6, long var7);

    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, SoundEffect sound, SoundCategory source) {
        this.a(entity, x2, y2, z2, sound, source, 1.0f, 1.0f);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, SoundEffect sound, SoundCategory source, float volume, float pitch) {
        this.a(entity, x2, y2, z2, sound, source, volume, pitch, this.B.g());
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory source, float volume, float pitch) {
        this.a(entity, x2, y2, z2, sound, source, volume, pitch, this.B.g());
    }

    public void a(@Nullable net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity sourceEntity, SoundEffect sound, SoundCategory source, float volume, float pitch) {
        this.a(entity, sourceEntity, BuiltInRegistries.b.e(sound), source, volume, pitch, this.B.g());
    }

    public void a(BlockPosition pos, SoundEffect sound, SoundCategory source, float volume, float pitch, boolean distanceDelay) {
        this.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, source, volume, pitch, distanceDelay);
    }

    public void a(net.minecraft.world.entity.Entity entity, SoundEffect sound, SoundCategory source, float volume, float pitch) {
    }

    public void a(double x2, double y2, double z2, SoundEffect sound, SoundCategory source, float volume, float pitch, boolean distanceDelay) {
    }

    public void a(SoundEffect sound, SoundCategory source, float volume, float pitch) {
    }

    @Override
    public void a(ParticleParam options, double x2, double y2, double z2, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void a(ParticleParam options, boolean overrideLimiter, boolean alwaysShow, double x2, double y2, double z2, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void b(ParticleParam options, double x2, double y2, double z2, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void a(ParticleParam options, boolean overrideLimiter, double x2, double y2, double z2, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void a(TickingBlockEntity ticker) {
        (this.c ? this.b : this.q).add(ticker);
    }

    public void ai() {
        this.c = true;
        if (!this.b.isEmpty()) {
            this.q.addAll(this.b);
            this.b.clear();
        }
        boolean runsNormally = this.y().i();
        int tickedEntities = 0;
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet();
        toRemove.add(null);
        this.tileTickPosition = 0;
        while (this.tileTickPosition < this.q.size()) {
            TickingBlockEntity tickingBlockEntity = this.q.get(this.tileTickPosition);
            if (tickingBlockEntity.b()) {
                toRemove.add((Object)tickingBlockEntity);
            } else if (runsNormally && this.r(tickingBlockEntity.c())) {
                tickingBlockEntity.a();
                if ((++tickedEntities & 7) == 0) {
                    this.moonrise$midTickTasks();
                }
            }
            ++this.tileTickPosition;
        }
        this.q.removeAll((Collection<?>)toRemove);
        this.c = false;
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(Consumer<T> action, T entity) {
        try {
            action.accept(entity);
        }
        catch (Throwable var6) {
            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.ao().getWorld().getName(), entity.dP(), entity.dR(), entity.dV());
            MinecraftServer.m.error(msg, var6);
            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, var6)));
            entity.discard(EntityRemoveEvent.Cause.DISCARD);
        }
        this.moonrise$midTickTasks();
    }

    @Override
    public boolean a(@Nullable net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        int flags;
        if (entity instanceof EntityArmorStand && !entity.ao().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return false;
        }
        int n2 = flags = entity == null ? 12 : 8;
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions(this, entity, box, null, flags, null);
    }

    public boolean h(net.minecraft.world.entity.Entity entity) {
        return true;
    }

    public boolean a(long chunkPos) {
        return true;
    }

    public boolean r(BlockPosition pos) {
        return this.a(ChunkCoordIntPair.a(pos));
    }

    public void a(@Nullable net.minecraft.world.entity.Entity source, double x2, double y2, double z2, float radius, a explosionInteraction) {
        this.a(source, Explosion.a(this, source), null, x2, y2, z2, radius, false, explosionInteraction, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity source, double x2, double y2, double z2, float radius, boolean fire, a explosionInteraction) {
        this.a(source, Explosion.a(this, source), null, x2, y2, z2, radius, fire, explosionInteraction, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, Vec3D pos, float radius, boolean fire, a explosionInteraction) {
        this.a(source, damageSource, damageCalculator, pos.a(), pos.b(), pos.c(), radius, fire, explosionInteraction, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public void a(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x2, double y2, double z2, float radius, boolean fire, a explosionInteraction) {
        this.a(source, damageSource, damageCalculator, x2, y2, z2, radius, fire, explosionInteraction, Particles.x, Particles.w, a, SoundEffects.lS);
    }

    public abstract void a(@Nullable net.minecraft.world.entity.Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, a var12, ParticleParam var13, ParticleParam var14, WeightedList<ExplosionParticleInfo> var15, Holder<SoundEffect> var16);

    public abstract String P();

    @Override
    public @Nullable TileEntity c_(BlockPosition pos) {
        TileEntity blockEntity;
        if (!this.capturedTileEntities.isEmpty() && (blockEntity = this.capturedTileEntities.get(pos)) != null) {
            return blockEntity;
        }
        if (!this.o(pos)) {
            return null;
        }
        return !this.B_() && !TickThread.isTickThread() ? null : this.q(pos).a(pos, Chunk.EnumTileEntityState.a);
    }

    public void b(TileEntity blockEntity) {
        BlockPosition blockPos = blockEntity.aD_();
        if (this.o(blockPos)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockPos.j(), blockEntity);
                return;
            }
            this.q(blockPos).b(blockEntity);
        }
    }

    public void s(BlockPosition pos) {
        if (this.o(pos)) {
            this.q(pos).c(pos);
        }
    }

    public boolean t(BlockPosition pos) {
        return this.o(pos) && this.ac().b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity, EnumDirection direction) {
        if (!this.o(pos)) {
            return false;
        }
        IChunkAccess chunk = this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()), ChunkStatus.n, false);
        return chunk != null && chunk.a_(pos).a((IBlockAccess)this, pos, entity, direction);
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return this.a(pos, entity, EnumDirection.b);
    }

    public void aj() {
        this.f = (int)(15.0f - this.c().a(EnvironmentAttributes.z).floatValue());
    }

    public void b(boolean spawnSettings) {
        this.ac().b(spawnSettings);
    }

    public abstract void a(WorldData.a var1);

    public abstract WorldData.a C();

    public WorldData.a b(WorldData.a respawnData) {
        WorldBorder worldBorder = this.w();
        if (!worldBorder.a(respawnData.b())) {
            BlockPosition heightmapPos = this.a(HeightMap.Type.e, BlockPosition.a(worldBorder.h(), 0.0, worldBorder.i()));
            return WorldData.a.a(respawnData.a(), heightmapPos, respawnData.d(), respawnData.e());
        }
        return respawnData;
    }

    protected void ak() {
        if (this.z.h()) {
            this.v = 1.0f;
            if (this.z.f()) {
                this.x = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ac().close();
    }

    @Override
    public @Nullable IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.n, false);
    }

    @Override
    public List<net.minecraft.world.entity.Entity> a(@Nullable net.minecraft.world.entity.Entity entity, AxisAlignedBB boundingBox, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.a().f("getEntities");
        ArrayList list = Lists.newArrayList();
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getEntities(entity, boundingBox, ret, predicate);
        PlatformHooks.get().addToGetEntities(this, entity, boundingBox, predicate, ret);
        return ret;
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AxisAlignedBB bounds, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(entityTypeTest, bounds, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AxisAlignedBB bounds, Predicate<? super T> predicate, List<? super T> output) {
        this.a(entityTypeTest, bounds, predicate, output, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AxisAlignedBB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        Profiler.a().f("getEntities");
        if (entityTypeTest instanceof EntityTypes) {
            EntityTypes byType = (EntityTypes)entityTypeTest;
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (entityTypeTest == null) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        Class<net.minecraft.world.entity.Entity> base = entityTypeTest.a();
        Predicate<net.minecraft.world.entity.Entity> modifiedPredicate = predicate == null ? obj -> entityTypeTest.a((net.minecraft.world.entity.Entity)obj) != null : obj -> {
            net.minecraft.world.entity.Entity casted = (net.minecraft.world.entity.Entity)entityTypeTest.a((net.minecraft.world.entity.Entity)obj);
            if (casted == null) {
                return false;
            }
            return predicate.test(casted);
        };
        if (base == null || base == net.minecraft.world.entity.Entity.class) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (maxCount != Integer.MAX_VALUE) {
            this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate, maxCount);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate);
        PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
    }

    public Entity[] getChunkEntities(int chunkX, int chunkZ) {
        ChunkEntitySlices slices = ((WorldServer)this).moonrise$getEntityLookup().getChunk(chunkX, chunkZ);
        if (slices == null) {
            return new Entity[0];
        }
        ArrayList<CraftEntity> ret = new ArrayList<CraftEntity>();
        for (net.minecraft.world.entity.Entity entity : slices.getAllEntities()) {
            CraftEntity bukkit = entity.getBukkitEntity();
            if (bukkit == null || !bukkit.isValid()) continue;
            ret.add(bukkit);
        }
        return ret.toArray(new Entity[0]);
    }

    public <T extends net.minecraft.world.entity.Entity> boolean b(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AxisAlignedBB bounds, Predicate<? super T> predicate) {
        Profiler.a().f("hasEntities");
        MutableBoolean mutableBoolean = new MutableBoolean();
        this.M().a(entityTypeTest, bounds, (U value) -> {
            if (predicate.test(value)) {
                mutableBoolean.setTrue();
                return AbortableIterationConsumer.a.b;
            }
            if (value instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)value;
                for (EntityComplexPart enderDragonPart : enderDragon.gM()) {
                    net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)entityTypeTest.a(enderDragonPart);
                    if (entity == null || !predicate.test(entity)) continue;
                    mutableBoolean.setTrue();
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
        return mutableBoolean.isTrue();
    }

    public List<net.minecraft.world.entity.Entity> k(net.minecraft.world.entity.Entity entity, AxisAlignedBB boundingBox) {
        return this.a(entity, boundingBox, IEntitySelector.a(entity));
    }

    public abstract @Nullable net.minecraft.world.entity.Entity a(int var1);

    public @Nullable net.minecraft.world.entity.Entity d(UUID uuid) {
        return this.M().a(uuid);
    }

    public @Nullable net.minecraft.world.entity.Entity a(UUID id) {
        return this.d(id);
    }

    public @Nullable EntityHuman b(UUID id) {
        return this.c(id);
    }

    public abstract Collection<EntityComplexPart> v();

    public void u(BlockPosition pos) {
        if (this.H(pos)) {
            this.q(pos).i();
        }
    }

    public void a(TileEntity entity) {
    }

    public long al() {
        return this.z.c();
    }

    public boolean a(net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        return true;
    }

    public void a(net.minecraft.world.entity.Entity entity, byte state) {
    }

    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
    }

    public void a(BlockPosition pos, Block block, int eventId, int eventParam) {
        this.a_(pos).a(this, pos, eventId, eventParam);
    }

    @Override
    public WorldData D_() {
        return this.z;
    }

    public abstract TickRateManager y();

    public float a(float partialTick) {
        return MathHelper.h(partialTick, this.w, this.x) * this.c(partialTick);
    }

    public void b(float level) {
        float f2;
        this.w = f2 = MathHelper.a(level, 0.0f, 1.0f);
        this.x = f2;
    }

    public float c(float partialTick) {
        return MathHelper.h(partialTick, this.u, this.v);
    }

    public void d(float level) {
        float f2;
        this.u = f2 = MathHelper.a(level, 0.0f, 1.0f);
        this.v = f2;
    }

    public boolean am() {
        return this.F_().e() && !this.F_().f() && this.aq() != j;
    }

    public boolean an() {
        return this.am() && (double)this.a(1.0f) > 0.9;
    }

    public boolean ao() {
        return this.am() && (double)this.c(1.0f) > 0.2;
    }

    public boolean v(BlockPosition pos) {
        return this.w(pos) == BiomeBase.Precipitation.b;
    }

    public BiomeBase.Precipitation w(BlockPosition pos) {
        if (!this.ao()) {
            return BiomeBase.Precipitation.a;
        }
        if (!this.k(pos)) {
            return BiomeBase.Precipitation.a;
        }
        if (this.a(HeightMap.Type.e, pos).v() > pos.v()) {
            return BiomeBase.Precipitation.a;
        }
        BiomeBase biome = this.z(pos).a();
        return biome.a(pos, this.V());
    }

    public abstract @Nullable WorldMap a(MapId var1);

    public void b(int id, BlockPosition pos, int data) {
    }

    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashReportCategory = report.a("Affected level", 1);
        crashReportCategory.a("All players", () -> {
            List<? extends EntityHuman> list = this.E();
            return list.size() + " total; " + list.stream().map(EntityHuman::ht).collect(Collectors.joining(", "));
        });
        crashReportCategory.a("Chunk stats", this.ac()::e);
        crashReportCategory.a("Level dimension", () -> this.aq().a().toString());
        try {
            this.z.a(crashReportCategory, this);
        }
        catch (Throwable var4) {
            crashReportCategory.a("Level Data Unobtainable", var4);
        }
        return crashReportCategory;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double x2, double y2, double z2, double xSpeed, double ySpeed, double zSpeed, List<FireworkExplosion> explosions) {
    }

    public abstract Scoreboard ab();

    public void b(BlockPosition pos, Block block) {
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction);
            if (!this.H(blockPos)) continue;
            IBlockData blockState = this.a_(blockPos);
            if (blockState.a(Blocks.hP)) {
                this.a(blockState, blockPos, block, null, false);
                continue;
            }
            if (!blockState.d(this, blockPos) || !(blockState = this.a_(blockPos = blockPos.a(direction))).a(Blocks.hP)) continue;
            this.a(blockState, blockPos, block, null, false);
        }
    }

    @Override
    public int E_() {
        return this.f;
    }

    public void c(int timeFlash) {
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager F_() {
        return this.C.a();
    }

    public Holder<DimensionManager> ap() {
        return this.C;
    }

    public ResourceKey<World> aq() {
        return this.F;
    }

    @Override
    public RandomSource G_() {
        return this.y;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> predicate) {
        return predicate.test(this.b_(pos));
    }

    public abstract RecipeAccess aa();

    public BlockPosition a(int x2, int y2, int z2, int yMask) {
        this.s = this.s * 3 + 1013904223;
        int i2 = this.s >> 2;
        return new BlockPosition(x2 + (i2 & 0xF), y2 + (i2 >> 16 & yMask), z2 + (i2 >> 8 & 0xF));
    }

    public boolean z() {
        return false;
    }

    @Override
    public BiomeManager H_() {
        return this.E;
    }

    public final boolean ar() {
        return this.e;
    }

    public abstract LevelEntityGetter<net.minecraft.world.entity.Entity> M();

    @Override
    public long I_() {
        return this.J++;
    }

    @Override
    public IRegistryCustom J_() {
        return this.G;
    }

    public DamageSources as() {
        return this.H;
    }

    public abstract EnvironmentAttributeSystem c();

    public abstract PotionBrewer R();

    public abstract FuelValues S();

    public int x(BlockPosition pos) {
        return 0;
    }

    public PalettedContainerFactory at() {
        return this.I;
    }

    public WireHandler getWireHandler() {
        return null;
    }

    public final int getEntityCount() {
        return this.moonrise$getEntityLookup().getEntityCount();
    }

    static {
        AIR_FLUIDSTATE = FluidTypes.a.g();
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("none");
        public static final /* enum */ a b = new a("block");
        public static final /* enum */ a c = new a("mob");
        public static final /* enum */ a d = new a("tnt");
        public static final /* enum */ a e = new a("trigger");
        public static final /* enum */ a STANDARD = new a("standard");
        public static final Codec<a> f;
        private final String g;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String id) {
            this.g = id;
        }

        @Override
        public String c() {
            return this.g;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d, e, STANDARD};
        }

        static {
            h = net.minecraft.world.level.World$a.a();
            f = INamable.a(a::values);
        }
    }
}

