/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.level.DryFoliageColor;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.jspecify.annotations.Nullable;

public final class BiomeBase {
    public static final Codec<BiomeBase> a = RecordCodecBuilder.create(instance -> instance.group((App)ClimateSettings.a.forGetter(biome -> biome.i), (App)EnvironmentAttributeMap.d.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.a).forGetter(biome -> biome.l), (App)BiomeFog.a.fieldOf("effects").forGetter(biome -> biome.m), (App)BiomeSettingsGeneration.b.forGetter(biome -> biome.j), (App)BiomeSettingsMobs.c.forGetter(biome -> biome.k)).apply((Applicative)instance, BiomeBase::new));
    public static final Codec<BiomeBase> b = RecordCodecBuilder.create(instance -> instance.group((App)ClimateSettings.a.forGetter(biome -> biome.i), (App)EnvironmentAttributeMap.c.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.a).forGetter(biome -> biome.l), (App)BiomeFog.a.fieldOf("effects").forGetter(biome -> biome.m)).apply((Applicative)instance, (climateSettings, attributes, specialEffects) -> new BiomeBase((ClimateSettings)climateSettings, (EnvironmentAttributeMap)attributes, (BiomeFog)specialEffects, BiomeSettingsGeneration.a, BiomeSettingsMobs.b)));
    public static final Codec<Holder<BiomeBase>> c = RegistryFileCodec.a(Registries.aS, a);
    public static final Codec<HolderSet<BiomeBase>> d = RegistryCodecs.a(Registries.aS, a);
    private static final NoiseGenerator3 f = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(1234L)), (List<Integer>)ImmutableList.of((Object)0));
    static final NoiseGenerator3 g = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(3456L)), (List<Integer>)ImmutableList.of((Object)-2, (Object)-1, (Object)0));
    @Deprecated(forRemoval=true)
    public static final NoiseGenerator3 e = new NoiseGenerator3((RandomSource)new SeededRandom(new LegacyRandomSource(2345L)), (List<Integer>)ImmutableList.of((Object)0));
    private static final int h = 1024;
    public final ClimateSettings i;
    private final BiomeSettingsGeneration j;
    private final BiomeSettingsMobs k;
    private final EnvironmentAttributeMap l;
    private final BiomeFog m;
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> n = ThreadLocal.withInitial(() -> {
        Long2FloatLinkedOpenHashMap map = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int newSize) {
            }
        };
        map.defaultReturnValue(Float.NaN);
        return map;
    });

    BiomeBase(ClimateSettings climateSettings, EnvironmentAttributeMap attributes, BiomeFog specialEffects, BiomeSettingsGeneration generationSettings, BiomeSettingsMobs mobSettings) {
        this.i = climateSettings;
        this.j = generationSettings;
        this.k = mobSettings;
        this.l = attributes;
        this.m = specialEffects;
    }

    public BiomeSettingsMobs a() {
        return this.k;
    }

    public boolean b() {
        return this.i.a();
    }

    public Precipitation a(BlockPosition pos, int seaLevel) {
        if (!this.b()) {
            return Precipitation.a;
        }
        return this.b(pos, seaLevel) ? Precipitation.c : Precipitation.b;
    }

    private float e(BlockPosition pos, int seaLevel) {
        float f2 = this.i.d.a(pos, this.f());
        int i2 = seaLevel + 17;
        if (pos.v() > i2) {
            float f1 = (float)(f.a((float)pos.u() / 8.0f, (float)pos.w() / 8.0f, false) * 8.0);
            return f2 - (f1 + (float)pos.v() - (float)i2) * 0.05f / 40.0f;
        }
        return f2;
    }

    @Deprecated
    public float f(BlockPosition pos, int seaLevel) {
        return this.e(pos, seaLevel);
    }

    public boolean a(IWorldReader level, BlockPosition pos) {
        return this.a(level, pos, true);
    }

    public boolean a(IWorldReader level, BlockPosition water, boolean mustBeAtEdge) {
        if (this.c(water, level.V())) {
            return false;
        }
        if (level.d(water.v()) && level.a(EnumSkyBlock.b, water) < 10) {
            IBlockData blockState = level.a_(water);
            Fluid fluidState = level.b_(water);
            if (fluidState.a() == FluidTypes.c && blockState.b() instanceof BlockFluids) {
                boolean flag;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = flag = level.F(water.h()) && level.F(water.i()) && level.F(water.f()) && level.F(water.g());
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(BlockPosition pos, int seaLevel) {
        return !this.c(pos, seaLevel);
    }

    public boolean c(BlockPosition pos, int seaLevel) {
        return this.f(pos, seaLevel) >= 0.15f;
    }

    public boolean d(BlockPosition pos, int seaLevel) {
        return this.f(pos, seaLevel) > 0.1f;
    }

    public boolean b(IWorldReader level, BlockPosition pos) {
        IBlockData blockState;
        if (this.a(pos, level.V()) != Precipitation.c) {
            return false;
        }
        return level.d(pos.v()) && level.a(EnumSkyBlock.b, pos) < 10 && ((blockState = level.a_(pos)).l() || blockState.a(Blocks.ep)) && Blocks.ep.m().a(level, pos);
    }

    public BiomeSettingsGeneration c() {
        return this.j;
    }

    public int a(double posX, double posZ) {
        int baseGrassColor = this.j();
        return this.m.e().a(posX, posZ, baseGrassColor);
    }

    private int j() {
        Optional<Integer> optional = this.m.d();
        return optional.isPresent() ? optional.get().intValue() : this.k();
    }

    private int k() {
        double d2 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double d1 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return GrassColor.a(d2, d1);
    }

    public int d() {
        return this.m.b().orElseGet(this::l);
    }

    private int l() {
        double d2 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double d1 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return FoliageColor.a(d2, d1);
    }

    public int e() {
        return this.m.c().orElseGet(this::m);
    }

    private int m() {
        double d2 = MathHelper.a(this.i.c, 0.0f, 1.0f);
        double d1 = MathHelper.a(this.i.e, 0.0f, 1.0f);
        return DryFoliageColor.a(d2, d1);
    }

    public float f() {
        return this.i.c;
    }

    public EnvironmentAttributeMap g() {
        return this.l;
    }

    public BiomeFog h() {
        return this.m;
    }

    public int i() {
        return this.m.a();
    }

    public static final class ClimateSettings
    extends Record {
        private final boolean b;
        private final float c;
        private final TemperatureModifier d;
        private final float e;
        public static final MapCodec<ClimateSettings> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(settings -> settings.b), (App)Codec.FLOAT.fieldOf("temperature").forGetter(settings -> Float.valueOf(settings.c)), (App)TemperatureModifier.c.optionalFieldOf("temperature_modifier", (Object)TemperatureModifier.a).forGetter(settings -> settings.d), (App)Codec.FLOAT.fieldOf("downfall").forGetter(settings -> Float.valueOf(settings.e))).apply((Applicative)instance, ClimateSettings::new));

        public ClimateSettings(boolean hasPrecipitation, float temperature, TemperatureModifier temperatureModifier, float downfall) {
            this.b = hasPrecipitation;
            this.c = temperature;
            this.d = temperatureModifier;
            this.e = downfall;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClimateSettings.class, "hasPrecipitation;temperature;temperatureModifier;downfall", "b", "c", "d", "e"}, this, o2);
        }

        public boolean a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public TemperatureModifier c() {
            return this.d;
        }

        public float d() {
            return this.e;
        }
    }

    public static final class Precipitation
    extends Enum<Precipitation>
    implements INamable {
        public static final /* enum */ Precipitation a = new Precipitation("none");
        public static final /* enum */ Precipitation b = new Precipitation("rain");
        public static final /* enum */ Precipitation c = new Precipitation("snow");
        public static final Codec<Precipitation> d;
        private final String e;
        private static final /* synthetic */ Precipitation[] f;

        public static Precipitation[] values() {
            return (Precipitation[])f.clone();
        }

        public static Precipitation valueOf(String name) {
            return Enum.valueOf(Precipitation.class, name);
        }

        private Precipitation(String name) {
            this.e = name;
        }

        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ Precipitation[] a() {
            return new Precipitation[]{a, b, c};
        }

        static {
            f = Precipitation.a();
            d = INamable.a(Precipitation::values);
        }
    }

    public static abstract sealed class TemperatureModifier
    extends Enum<TemperatureModifier>
    implements INamable {
        public static final /* enum */ TemperatureModifier a = new TemperatureModifier("none"){

            @Override
            public float a(BlockPosition pos, float temperature) {
                return temperature;
            }
        };
        public static final /* enum */ TemperatureModifier b = new TemperatureModifier("frozen"){

            @Override
            public float a(BlockPosition pos, float temperature) {
                double value1;
                double value;
                double d2 = g.a((double)pos.u() * 0.05, (double)pos.w() * 0.05, false) * 7.0;
                double d1 = d2 + (value = BiomeBase.e.a((double)pos.u() * 0.2, (double)pos.w() * 0.2, false));
                if (d1 < 0.3 && (value1 = BiomeBase.e.a((double)pos.u() * 0.09, (double)pos.w() * 0.09, false)) < 0.8) {
                    return 0.2f;
                }
                return temperature;
            }
        };
        private final String d;
        public static final Codec<TemperatureModifier> c;
        private static final /* synthetic */ TemperatureModifier[] e;

        public static TemperatureModifier[] values() {
            return (TemperatureModifier[])e.clone();
        }

        public static TemperatureModifier valueOf(String name) {
            return Enum.valueOf(TemperatureModifier.class, name);
        }

        public abstract float a(BlockPosition var1, float var2);

        private TemperatureModifier(String name) {
            this.d = name;
        }

        public String a() {
            return this.d;
        }

        @Override
        public String c() {
            return this.d;
        }

        private static /* synthetic */ TemperatureModifier[] b() {
            return new TemperatureModifier[]{a, b};
        }

        static {
            e = TemperatureModifier.b();
            c = INamable.a(TemperatureModifier::values);
        }
    }

    public static class a {
        private boolean a = true;
        private @Nullable Float b;
        private TemperatureModifier c = TemperatureModifier.a;
        private @Nullable Float d;
        private final EnvironmentAttributeMap.a e = EnvironmentAttributeMap.a();
        private @Nullable BiomeFog f;
        private @Nullable BiomeSettingsMobs g;
        private @Nullable BiomeSettingsGeneration h;

        public a a(boolean hasPrecipitation) {
            this.a = hasPrecipitation;
            return this;
        }

        public a a(float temperature) {
            this.b = Float.valueOf(temperature);
            return this;
        }

        public a b(float downfall) {
            this.d = Float.valueOf(downfall);
            return this;
        }

        public a a(EnvironmentAttributeMap attributes) {
            this.e.a(attributes);
            return this;
        }

        public a a(EnvironmentAttributeMap.a builder) {
            return this.a(builder.a());
        }

        public <Value> a a(EnvironmentAttribute<Value> attribute, Value value) {
            this.e.a(attribute, value);
            return this;
        }

        public <Value, Parameter> a a(EnvironmentAttribute<Value> attribute, AttributeModifier<Value, Parameter> modifier, Parameter parameter) {
            this.e.a(attribute, modifier, parameter);
            return this;
        }

        public a a(BiomeFog effects) {
            this.f = effects;
            return this;
        }

        public a a(BiomeSettingsMobs mobSpawnSettings) {
            this.g = mobSpawnSettings;
            return this;
        }

        public a a(BiomeSettingsGeneration generationSettings) {
            this.h = generationSettings;
            return this;
        }

        public a a(TemperatureModifier temperatureSettings) {
            this.c = temperatureSettings;
            return this;
        }

        public BiomeBase a() {
            if (this.b != null && this.d != null && this.f != null && this.g != null && this.h != null) {
                return new BiomeBase(new ClimateSettings(this.a, this.b.floatValue(), this.c, this.d.floatValue()), this.e.a(), this.f, this.h, this.g);
            }
            throw new IllegalStateException("You are missing parameters to build a proper biome\n" + String.valueOf(this));
        }

        public String toString() {
            return "BiomeBuilder{\nhasPrecipitation=" + this.a + ",\ntemperature=" + this.b + ",\ntemperatureModifier=" + String.valueOf(this.c) + ",\ndownfall=" + this.d + ",\nspecialEffects=" + String.valueOf(this.f) + ",\nmobSpawnSettings=" + String.valueOf(this.g) + ",\ngenerationSettings=" + String.valueOf(this.h) + ",\n}";
        }
    }
}

