/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.hash.Hashing;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.BiomeBase;

public class BiomeManager {
    public static final int a = QuartPos.a(8);
    private static final int b = 2;
    private static final int c = 4;
    private static final int d = 3;
    private final Provider e;
    private final long f;

    public BiomeManager(Provider noiseBiomeSource, long biomeZoomSeed) {
        this.e = noiseBiomeSource;
        this.f = biomeZoomSeed;
    }

    public static long a(long seed) {
        return Hashing.sha256().hashLong(seed).asLong();
    }

    public BiomeManager a(Provider newSource) {
        return new BiomeManager(newSource, this.f);
    }

    public Holder<BiomeBase> a(BlockPosition pos) {
        int i2 = pos.u() - 2;
        int i1 = pos.v() - 2;
        int i22 = pos.w() - 2;
        int i3 = i2 >> 2;
        int i4 = i1 >> 2;
        int i5 = i22 >> 2;
        double d2 = (double)(i2 & 3) / 4.0;
        double d1 = (double)(i1 & 3) / 4.0;
        double d22 = (double)(i22 & 3) / 4.0;
        int i6 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        for (int i7 = 0; i7 < 8; ++i7) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int i10;
            boolean flag1;
            int i9;
            boolean flag = (i7 & 4) == 0;
            int i8 = flag ? i3 : i3 + 1;
            double fiddledDistance = BiomeManager.a(this.f, i8, i9 = (flag1 = (i7 & 2) == 0) ? i4 : i4 + 1, i10 = (flag2 = (i7 & 1) == 0) ? i5 : i5 + 1, d4 = flag ? d2 : d2 - 1.0, d5 = flag1 ? d1 : d1 - 1.0, d6 = flag2 ? d22 : d22 - 1.0);
            if (!(d3 > fiddledDistance)) continue;
            i6 = i7;
            d3 = fiddledDistance;
        }
        int i7x = (i6 & 4) == 0 ? i3 : i3 + 1;
        int i11 = (i6 & 2) == 0 ? i4 : i4 + 1;
        int i12 = (i6 & 1) == 0 ? i5 : i5 + 1;
        return this.e.getNoiseBiome(i7x, i11, i12);
    }

    public Holder<BiomeBase> a(double x2, double y2, double z2) {
        int quartPosCoord = QuartPos.a(MathHelper.c(x2));
        int quartPosCoord1 = QuartPos.a(MathHelper.c(y2));
        int quartPosCoord2 = QuartPos.a(MathHelper.c(z2));
        return this.a(quartPosCoord, quartPosCoord1, quartPosCoord2);
    }

    public Holder<BiomeBase> b(BlockPosition pos) {
        int quartPosX = QuartPos.a(pos.u());
        int quartPosY = QuartPos.a(pos.v());
        int quartPosZ = QuartPos.a(pos.w());
        return this.a(quartPosX, quartPosY, quartPosZ);
    }

    public Holder<BiomeBase> a(int x2, int y2, int z2) {
        return this.e.getNoiseBiome(x2, y2, z2);
    }

    private static double a(long seed, int x2, int y2, int z2, double xNoise, double yNoise, double zNoise) {
        long l2 = LinearCongruentialGenerator.a(seed, x2);
        l2 = LinearCongruentialGenerator.a(l2, y2);
        l2 = LinearCongruentialGenerator.a(l2, z2);
        l2 = LinearCongruentialGenerator.a(l2, x2);
        l2 = LinearCongruentialGenerator.a(l2, y2);
        l2 = LinearCongruentialGenerator.a(l2, z2);
        double fiddle = BiomeManager.b(l2);
        l2 = LinearCongruentialGenerator.a(l2, seed);
        double fiddle1 = BiomeManager.b(l2);
        l2 = LinearCongruentialGenerator.a(l2, seed);
        double fiddle2 = BiomeManager.b(l2);
        return MathHelper.n(zNoise + fiddle2) + MathHelper.n(yNoise + fiddle1) + MathHelper.n(xNoise + fiddle);
    }

    private static double b(long seed) {
        return (double)((seed >> 24 & 0x3FFL) - 512L) * 8.7890625E-4;
    }

    public static interface Provider {
        public Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3);
    }
}

