/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import org.jspecify.annotations.Nullable;

public class WorldChunkManagerHell
extends WorldChunkManager
implements BiomeManager.Provider {
    public static final MapCodec<WorldChunkManagerHell> b = BiomeBase.c.fieldOf("biome").xmap(WorldChunkManagerHell::new, fixed -> fixed.c).stable();
    private final Holder<BiomeBase> c;

    public WorldChunkManagerHell(Holder<BiomeBase> biome) {
        this.c = biome;
    }

    @Override
    protected Stream<Holder<BiomeBase>> b() {
        return Stream.of(this.c);
    }

    @Override
    protected MapCodec<? extends WorldChunkManager> a() {
        return b;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2, Climate.Sampler sampler) {
        return this.c;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2) {
        return this.c;
    }

    @Override
    public @Nullable Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, int increment, Predicate<Holder<BiomeBase>> biomePredicate, RandomSource random, boolean findClosest, Climate.Sampler sampler) {
        if (biomePredicate.test(this.c)) {
            return findClosest ? Pair.of((Object)new BlockPosition(x2, y2, z2), this.c) : Pair.of((Object)new BlockPosition(x2 - radius + random.a(radius * 2 + 1), y2, z2 - radius + random.a(radius * 2 + 1)), this.c);
        }
        return null;
    }

    @Override
    public @Nullable Pair<BlockPosition, Holder<BiomeBase>> a(BlockPosition pos, int radius, int horizontalStep, int verticalStep, Predicate<Holder<BiomeBase>> biomePredicate, Climate.Sampler sampler, IWorldReader level) {
        return biomePredicate.test(this.c) ? Pair.of((Object)pos.h(MathHelper.a(pos.v(), level.K_() + 1, level.aw() + 1)), this.c) : null;
    }

    @Override
    public Set<Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Climate.Sampler sampler) {
        return Sets.newHashSet(Set.of(this.c));
    }
}

