/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.jspecify.annotations.Nullable;

public class BlockButtonAbstract
extends BlockAttachable {
    public static final MapCodec<BlockButtonAbstract> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(buttonBlock -> buttonBlock.d), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(buttonBlock -> buttonBlock.e), BlockButtonAbstract.x()).apply((Applicative)instance, BlockButtonAbstract::new));
    public static final BlockStateBoolean b = BlockProperties.A;
    private final BlockSetType d;
    private final int e;
    private final Function<IBlockData, VoxelShape> g;

    public MapCodec<BlockButtonAbstract> a() {
        return a;
    }

    protected BlockButtonAbstract(BlockSetType type, int ticksToStayPressed, BlockBase.Info properties) {
        super(properties.a(type.g()));
        this.d = type;
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(BlockFacingHorizontal.f, EnumDirection.c)).b(b, false)).b(BlockAttachable.c, BlockPropertyAttachPosition.b));
        this.e = ticksToStayPressed;
        this.g = this.b();
    }

    private Function<IBlockData, VoxelShape> b() {
        VoxelShape voxelShape = Block.a(14.0);
        VoxelShape voxelShape1 = Block.a(12.0);
        Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> map = VoxelShapes.e(Block.b(6.0, 4.0, 8.0, 16.0));
        return this.a((IBlockData blockState) -> VoxelShapes.a((VoxelShape)((Map)map.get(blockState.c(BlockAttachable.c))).get(blockState.c(BlockFacingHorizontal.f)), blockState.c(b) != false ? voxelShape : voxelShape1, OperatorBoolean.e));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.g.apply(state);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (state.c(b).booleanValue()) {
            return EnumInteractionResult.c;
        }
        boolean powered = state.c(b);
        CraftBlock block = CraftBlock.at(level, pos);
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)block, old, current);
        level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return EnumInteractionResult.a;
        }
        this.a(state, level, pos, player);
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g() && !state.c(b).booleanValue()) {
            this.a(state, (World)level, pos, (EntityHuman)null);
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    public void a(IBlockData state, World level, BlockPosition pos, @Nullable EntityHuman player) {
        level.a(pos, (IBlockData)state.b(b, true), 3);
        this.d(state, level, pos);
        level.a(pos, (Block)this, this.e);
        this.a(player, (GeneratorAccess)level, pos, true);
        level.a((net.minecraft.world.entity.Entity)player, GameEvent.a, pos);
    }

    protected void a(@Nullable EntityHuman player, GeneratorAccess level, BlockPosition pos, boolean hitByArrow) {
        level.a((net.minecraft.world.entity.Entity)(hitByArrow ? player : null), pos, this.a(hitByArrow), SoundCategory.e);
    }

    protected SoundEffect a(boolean isOn) {
        return isOn ? this.d.o() : this.d.n();
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (!movedByPiston && state.c(b).booleanValue()) {
            this.d(state, level, pos);
        }
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return state.c(b) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return state.c(b) != false && BlockButtonAbstract.n(state) == side ? 15 : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            this.c(state, level, pos);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.B_() && this.d.e() && !state.c(b).booleanValue()) {
            this.c(state, level, pos);
        }
    }

    protected void c(IBlockData state, World level, BlockPosition pos) {
        EntityArrow abstractArrow = this.d.e() ? (EntityArrow)level.a(EntityArrow.class, state.f(level, pos).a().a(pos)).stream().findFirst().orElse(null) : null;
        boolean flag = abstractArrow != null;
        boolean poweredValue = state.c(b);
        if (poweredValue != flag && flag) {
            CraftBlock block = CraftBlock.at(level, pos);
            EntityInteractEvent event = new EntityInteractEvent((Entity)abstractArrow.getBukkitEntity(), (org.bukkit.block.Block)block);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (flag != poweredValue) {
            boolean powered = poweredValue;
            CraftBlock block = CraftBlock.at(level, pos);
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)block, old, current);
            level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            level.a(pos, (IBlockData)state.b(b, flag), 3);
            this.d(state, level, pos);
            this.a(null, (GeneratorAccess)level, pos, flag);
            level.a((net.minecraft.world.entity.Entity)abstractArrow, flag ? GameEvent.a : GameEvent.e, pos);
        }
        if (flag) {
            level.a(new BlockPosition(pos), (Block)this, this.e);
        }
    }

    private void d(IBlockData state, World level, BlockPosition pos) {
        EnumDirection opposite;
        Orientation orientation = ExperimentalRedstoneUtils.a(level, opposite, (opposite = BlockButtonAbstract.n(state).g()).o().d() ? EnumDirection.b : state.c(BlockFacingHorizontal.f));
        level.a(pos, (Block)this, orientation);
        level.a(pos.a(opposite), (Block)this, orientation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.f, b, BlockAttachable.c);
    }
}

