/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.jspecify.annotations.Nullable;

public class BlockCampfire
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<BlockCampfire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawn_particles").forGetter(campfireBlock -> campfireBlock.i), (App)Codec.intRange((int)0, (int)1000).fieldOf("fire_damage").forGetter(campfireBlock -> campfireBlock.D), BlockCampfire.x()).apply((Applicative)instance, BlockCampfire::new));
    public static final BlockStateBoolean b = BlockProperties.u;
    public static final BlockStateBoolean c = BlockProperties.D;
    public static final BlockStateBoolean d = BlockProperties.I;
    public static final BlockStateEnum<EnumDirection> e = BlockProperties.T;
    private static final VoxelShape f = Block.b(16.0, 0.0, 7.0);
    private static final VoxelShape g = Block.b(4.0, 0.0, 16.0);
    private static final int h = 5;
    private final boolean i;
    private final int D;

    public MapCodec<BlockCampfire> a() {
        return a;
    }

    public BlockCampfire(boolean spawnParticles, int fireDamage, BlockBase.Info properties) {
        super(properties);
        this.i = spawnParticles;
        this.D = fireDamage;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, true)).b(c, false)).b(d, false)).b(e, EnumDirection.c));
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityCampfire) {
            TileEntityCampfire campfireBlockEntity = (TileEntityCampfire)tileEntity;
            ItemStack itemInHand = player.b(hand);
            if (level.aa().a(RecipePropertySet.h).a(itemInHand)) {
                WorldServer serverLevel;
                if (level instanceof WorldServer && campfireBlockEntity.a(serverLevel = (WorldServer)level, player, itemInHand)) {
                    player.a(StatisticList.ax);
                    return EnumInteractionResult.b;
                }
                return EnumInteractionResult.c;
            }
        }
        return EnumInteractionResult.f;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (state.c(b).booleanValue() && entity instanceof EntityLiving) {
            entity.a(level.as().b().eventBlockDamager(level, pos), (float)this.D);
        }
        super.a(state, level, pos, entity, effectApplier, pastEdges);
    }

    @Override
    public @Nullable IBlockData a(BlockActionContext context) {
        BlockPosition clickedPos;
        World level = context.q();
        boolean flag = level.b_(clickedPos = context.a()).a() == FluidTypes.c;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(d, flag)).b(c, this.p(level.a_(clickedPos.e())))).b(b, !flag)).b(e, context.g());
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return direction == EnumDirection.a ? (IBlockData)state.b(c, this.p(neighborState)) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    private boolean p(IBlockData state) {
        return state.a(Blocks.jb);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return f;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            if (random.a(10) == 0) {
                level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.ej, SoundCategory.e, 0.5f + random.i(), random.i() * 0.7f + 0.6f, false);
            }
            if (this.i && random.a(5) == 0) {
                for (int i2 = 0; i2 < random.a(1) + 1; ++i2) {
                    level.a(Particles.ac, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, (double)(random.i() / 2.0f), 5.0E-5, random.i() / 2.0f);
                }
            }
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, GeneratorAccess level, BlockPosition pos, IBlockData state) {
        if (level.B_()) {
            for (int i2 = 0; i2 < 20; ++i2) {
                BlockCampfire.a((World)level, pos, state.c(c), true);
            }
        }
        level.a(entity, GameEvent.c, pos);
    }

    @Override
    public boolean a(GeneratorAccess level, BlockPosition pos, IBlockData state, Fluid fluidState) {
        if (!state.c(BlockProperties.I).booleanValue() && fluidState.a() == FluidTypes.c) {
            boolean litValue = state.c(b);
            if (litValue) {
                if (!level.B_()) {
                    level.a(null, pos, SoundEffects.lT, SoundCategory.e, 1.0f, 1.0f);
                }
                BlockCampfire.a(null, level, pos, state);
            }
            level.a(pos, (IBlockData)((IBlockData)state.b(d, true)).b(b, false), 3);
            level.a(pos, fluidState.a(), fluidState.a().a(level));
            return true;
        }
        return false;
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        BlockPosition blockPos = hit.b();
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (projectile.cp() && projectile.c(serverLevel, blockPos) && !state.c(b).booleanValue() && !state.c(d).booleanValue()) {
                if (CraftEventFactory.callBlockIgniteEvent(level, blockPos, projectile).isCancelled()) {
                    return;
                }
                level.a(blockPos, (IBlockData)state.b(BlockProperties.u, true), 11);
            }
        }
    }

    public static void a(World level, BlockPosition pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        RandomSource random = level.G_();
        ParticleType simpleParticleType = isSignalFire ? Particles.ay : Particles.ax;
        level.a(simpleParticleType, true, (double)pos.u() + 0.5 + random.j() / 3.0 * (double)(random.h() ? 1 : -1), (double)pos.v() + random.j() + random.j(), (double)pos.w() + 0.5 + random.j() / 3.0 * (double)(random.h() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            level.a(Particles.ai, (double)pos.u() + 0.5 + random.j() / 4.0 * (double)(random.h() ? 1 : -1), (double)pos.v() + 0.4, (double)pos.w() + 0.5 + random.j() / 4.0 * (double)(random.h() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean a(World level, BlockPosition pos) {
        for (int i2 = 1; i2 <= 5; ++i2) {
            BlockPosition blockPos = pos.c(i2);
            IBlockData blockState = level.a_(blockPos);
            if (BlockCampfire.h(blockState)) {
                return true;
            }
            boolean flag = VoxelShapes.c(g, blockState.b((IBlockAccess)level, pos, VoxelShapeCollision.a()), OperatorBoolean.i);
            if (!flag) continue;
            IBlockData blockState1 = level.a_(blockPos.e());
            return BlockCampfire.h(blockState1);
        }
        return false;
    }

    public static boolean h(IBlockData state) {
        return state.b(b) && state.a(TagsBlock.bh) && state.c(b) != false;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(e, rotation.a(state.c(e)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(e)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityCampfire(pos, state);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (state.c(b).booleanValue()) {
                CraftingManager.a cachedCheck = CraftingManager.a(Recipes.e);
                return BlockCampfire.a(blockEntityType, TileEntityTypes.H, (World level1, BlockPosition pos, IBlockData state1, ? super E blockEntity) -> TileEntityCampfire.a(serverLevel, pos, state1, blockEntity, cachedCheck));
            }
            return BlockCampfire.a(blockEntityType, TileEntityTypes.H, TileEntityCampfire::a);
        }
        return state.c(b) != false ? BlockCampfire.a(blockEntityType, TileEntityTypes.H, TileEntityCampfire::b) : null;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    public static boolean i(IBlockData state) {
        return state.a(TagsBlock.bh, (BlockBase.BlockData blockStateBase) -> blockStateBase.b(d) && blockStateBase.b(b)) && state.c(d) == false && state.c(b) == false;
    }
}

