/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockChest
extends BlockChestAbstract<TileEntityChest>
implements IBlockWaterlogged {
    public static final MapCodec<BlockChest> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.b.q().fieldOf("open_sound").forGetter(BlockChest::r), (App)BuiltInRegistries.b.q().fieldOf("close_sound").forGetter(BlockChest::s), BlockChest.x()).apply((Applicative)instance, (soundEvent, soundEvent1, properties) -> new BlockChest(() -> TileEntityTypes.b, (SoundEffect)soundEvent, (SoundEffect)soundEvent1, (BlockBase.Info)properties)));
    public static final BlockStateEnum<EnumDirection> c = BlockFacingHorizontal.f;
    public static final BlockStateEnum<BlockPropertyChestType> d = BlockProperties.bh;
    public static final BlockStateBoolean e = BlockProperties.I;
    public static final int f = 1;
    private static final VoxelShape g = Block.b(14.0, 0.0, 14.0);
    private static final Map<EnumDirection, VoxelShape> h = VoxelShapes.c(Block.a(14.0, 0.0, 14.0, 0.0, 15.0));
    private final SoundEffect i;
    private final SoundEffect D;
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>> R = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> a(TileEntityChest first, TileEntityChest second) {
            return Optional.of(new InventoryLargeChest(first, second));
        }

        @Override
        public Optional<IInventory> a(TileEntityChest single) {
            return Optional.of(single);
        }

        public Optional<IInventory> a() {
            return Optional.empty();
        }
    };
    public static DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>> S = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>>(){

        @Override
        public Optional<ITileInventory> a(final TileEntityChest first, final TileEntityChest second) {
            final InventoryLargeChest container = new InventoryLargeChest(first, second);
            return Optional.of(DoubleInventory.wrap(new ITileInventory(){

                @Override
                public @Nullable Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman player) {
                    if (first.b(player) && second.b(player)) {
                        first.f_(playerInventory.j);
                        second.f_(playerInventory.j);
                        return ContainerChest.b(containerId, playerInventory, container);
                    }
                    EnumDirection connectedDirection = BlockChest.n(first.o());
                    Vec3D center = first.aD_().b();
                    Vec3D vec3 = center.b((double)connectedDirection.j() / 2.0, 0.0, (double)connectedDirection.l() / 2.0);
                    TileEntityContainer.a(vec3, player, this.R_());
                    return null;
                }

                @Override
                public IChatBaseComponent R_() {
                    if (first.i_()) {
                        return first.R_();
                    }
                    return second.i_() ? second.R_() : IChatBaseComponent.c("container.chestDouble");
                }
            }, container));
        }

        @Override
        public Optional<ITileInventory> a(TileEntityChest single) {
            return Optional.of(single);
        }

        public Optional<ITileInventory> a() {
            return Optional.empty();
        }
    };

    @Override
    public MapCodec<? extends BlockChest> a() {
        return b;
    }

    protected BlockChest(Supplier<TileEntityTypes<? extends TileEntityChest>> blockEntityType, SoundEffect openSound, SoundEffect closeSound, BlockBase.Info properties) {
        super(properties, blockEntityType);
        this.i = openSound;
        this.D = closeSound;
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(c, EnumDirection.c)).b(d, BlockPropertyChestType.a)).b(e, false));
    }

    public static DoubleBlockFinder.BlockType h(IBlockData state) {
        BlockPropertyChestType chestType = state.c(d);
        if (chestType == BlockPropertyChestType.a) {
            return DoubleBlockFinder.BlockType.a;
        }
        return chestType == BlockPropertyChestType.c ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if (this.i(neighborState) && direction.o().d()) {
            BlockPropertyChestType chestType = neighborState.c(d);
            if (state.c(d) == BlockPropertyChestType.a && chestType != BlockPropertyChestType.a && state.c(c) == neighborState.c(c) && BlockChest.n(neighborState) == direction.g()) {
                return (IBlockData)state.b(d, chestType.a());
            }
        } else if (BlockChest.n(state) == direction) {
            return (IBlockData)state.b(d, BlockPropertyChestType.a);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public boolean i(IBlockData state) {
        return state.a(this);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return switch (state.c(d)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyChestType.a -> g;
            case BlockPropertyChestType.b, BlockPropertyChestType.c -> h.get(BlockChest.n(state));
        };
    }

    public static EnumDirection n(IBlockData state) {
        EnumDirection direction = state.c(c);
        return state.c(d) == BlockPropertyChestType.b ? direction.h() : direction.i();
    }

    public static BlockPosition b(BlockPosition pos, IBlockData state) {
        EnumDirection connectedDirection = BlockChest.n(state);
        return pos.a(connectedDirection);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        EnumDirection direction;
        BlockPropertyChestType chestType = BlockPropertyChestType.a;
        EnumDirection opposite = context.g().g();
        Fluid fluidState = context.q().b_(context.a());
        boolean isSecondaryUseActive = context.h();
        EnumDirection clickedFace = context.k();
        if (clickedFace.o().d() && isSecondaryUseActive && (direction = this.b(context.q(), context.a(), clickedFace.g())) != null && direction.o() != clickedFace.o()) {
            opposite = direction;
            BlockPropertyChestType blockPropertyChestType = chestType = direction.i() == clickedFace.g() ? BlockPropertyChestType.c : BlockPropertyChestType.b;
        }
        if (chestType == BlockPropertyChestType.a && !isSecondaryUseActive) {
            chestType = this.a(context.q(), context.a(), opposite);
        }
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, opposite)).b(d, chestType)).b(e, fluidState.a() == FluidTypes.c);
    }

    protected BlockPropertyChestType a(World level, BlockPosition pos, EnumDirection direction) {
        if (direction == this.b(level, pos, direction.h())) {
            return BlockPropertyChestType.b;
        }
        return direction == this.b(level, pos, direction.i()) ? BlockPropertyChestType.c : BlockPropertyChestType.a;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    private @Nullable EnumDirection b(World level, BlockPosition pos, EnumDirection direction) {
        IBlockData blockState = level.a_(pos.a(direction));
        return this.i(blockState) && blockState.c(d) == BlockPropertyChestType.a ? blockState.c(c) : null;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            ITileInventory menuProvider = this.a(state, level, pos);
            if (menuProvider != null && player.a(menuProvider).isPresent()) {
                player.b(this.d());
                PiglinAI.a(serverLevel, player, true);
            }
        }
        return EnumInteractionResult.a;
    }

    protected Statistic<MinecraftKey> d() {
        return StatisticList.i.b(StatisticList.aq);
    }

    public TileEntityTypes<? extends TileEntityChest> q() {
        return this.a.get();
    }

    public static @Nullable IInventory a(BlockChest chest, IBlockData state, World level, BlockPosition pos, boolean override) {
        return chest.a(state, level, pos, override).apply(R).orElse(null);
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData state, World level, BlockPosition pos, boolean override) {
        BiPredicate<GeneratorAccess, BlockPosition> biPredicate = override ? (levelAccessor, blockPos) -> false : BlockChest::a;
        return DoubleBlockFinder.a(this.a.get(), BlockChest::h, BlockChest::n, c, state, level, pos, biPredicate);
    }

    @Override
    public @Nullable ITileInventory a(IBlockData state, World level, BlockPosition pos) {
        return this.getMenuProvider(state, level, pos, false);
    }

    public @Nullable ITileInventory getMenuProvider(IBlockData state, World level, BlockPosition pos, boolean ignoreObstructions) {
        return this.a(state, level, pos, ignoreObstructions).apply(S).orElse(null);
    }

    public static DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction> a(final LidBlockEntity lid) {
        return new DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction a(TileEntityChest first, TileEntityChest second) {
                return partialTick -> Math.max(first.a(partialTick), second.a(partialTick));
            }

            @Override
            public Float2FloatFunction a(TileEntityChest single) {
                return single::a;
            }

            public Float2FloatFunction a() {
                return lid::a;
            }
        };
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityChest(pos, state);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.B_() ? BlockChest.a(blockEntityType, this.q(), TileEntityChest::a) : null;
    }

    public static boolean a(GeneratorAccess level, BlockPosition pos) {
        return BlockChest.a((IBlockAccess)level, pos) || BlockChest.b(level, pos);
    }

    public static boolean a(IBlockAccess level, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        return level.a_(blockPos).d(level, blockPos);
    }

    private static boolean b(GeneratorAccess level, BlockPosition pos) {
        if (level.getMinecraftWorld().paperConfig().entities.behavior.disableChestCatDetection) {
            return false;
        }
        List<EntityCat> entitiesOfClass = level.a(EntityCat.class, new AxisAlignedBB(pos.u(), pos.v() + 1, pos.w(), pos.u() + 1, pos.v() + 2, pos.w() + 1));
        if (!entitiesOfClass.isEmpty()) {
            for (EntityCat cat : entitiesOfClass) {
                if (!cat.gQ()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return Container.b(BlockChest.a(this, state, level, pos, false));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(c, rotation.a(state.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d, e);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityChest) {
            ((TileEntityChest)blockEntity).l();
        }
    }

    public SoundEffect r() {
        return this.i;
    }

    public SoundEffect s() {
        return this.D;
    }

    public static class DoubleInventory
    implements ITileInventory {
        private final ITileInventory delegate;
        public final InventoryLargeChest container;

        private DoubleInventory(ITileInventory delegate, InventoryLargeChest container) {
            this.delegate = delegate;
            this.container = container;
        }

        public static DoubleInventory wrap(ITileInventory delegate, InventoryLargeChest container) {
            return new DoubleInventory(delegate, container);
        }

        @Override
        public @Nullable Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
            return this.delegate.createMenu(syncId, playerInventory, player);
        }

        @Override
        public IChatBaseComponent R_() {
            return this.delegate.R_();
        }
    }
}

